/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.collection;

import java.io.Serializable;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.hibernate.HibernateException;
import org.hibernate.collection.AbstractPersistentCollection;
import org.hibernate.collection.BasicCollectionPersister;
import org.hibernate.collection.CollectionPersister;
import org.hibernate.collection.Map;
import org.hibernate.engine.SessionImplementor;

public class SortedMap
extends Map
implements java.util.SortedMap {
    private Comparator comparator;

    public Serializable snapshot(BasicCollectionPersister persister) throws HibernateException {
        TreeMap clonedMap = new TreeMap(this.comparator);
        Iterator iter = this.map.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry e = iter.next();
            clonedMap.put(e.getKey(), persister.getElementType().deepCopy(e.getValue()));
        }
        return clonedMap;
    }

    public SortedMap(SessionImplementor session) {
        super(session);
    }

    public SortedMap(SessionImplementor session, CollectionPersister persister, Comparator comparator, Serializable disassembled, Object owner) throws HibernateException {
        super(session);
        this.comparator = comparator;
        this.beforeInitialize(persister);
        Serializable[] array = (Serializable[])disassembled;
        for (int i = 0; i < array.length; i += 2) {
            this.map.put(persister.getIndexType().assemble(array[i], session, owner), persister.getElementType().assemble(array[i + 1], session, owner));
        }
        this.setInitialized();
    }

    public void beforeInitialize(CollectionPersister persister) {
        this.map = new TreeMap(this.comparator);
    }

    public void setComparator(Comparator comparator) {
        this.comparator = comparator;
    }

    public SortedMap(SessionImplementor session, java.util.SortedMap map) {
        super(session, map);
        this.comparator = map.comparator();
    }

    public SortedMap() {
    }

    public Comparator comparator() {
        return this.comparator;
    }

    public java.util.SortedMap subMap(Object fromKey, Object toKey) {
        this.read();
        java.util.SortedMap m = ((java.util.SortedMap)this.map).subMap(fromKey, toKey);
        return new SortedSubMap(m);
    }

    public java.util.SortedMap headMap(Object toKey) {
        this.read();
        java.util.SortedMap m = ((java.util.SortedMap)this.map).headMap(toKey);
        return new SortedSubMap(m);
    }

    public java.util.SortedMap tailMap(Object fromKey) {
        this.read();
        java.util.SortedMap m = ((java.util.SortedMap)this.map).tailMap(fromKey);
        return new SortedSubMap(m);
    }

    public Object firstKey() {
        this.read();
        return ((java.util.SortedMap)this.map).firstKey();
    }

    public Object lastKey() {
        this.read();
        return ((java.util.SortedMap)this.map).lastKey();
    }

    class SortedSubMap
    implements java.util.SortedMap {
        java.util.SortedMap submap;

        SortedSubMap(java.util.SortedMap m) {
            this.submap = m;
        }

        public int size() {
            return this.submap.size();
        }

        public boolean isEmpty() {
            return this.submap.isEmpty();
        }

        public boolean containsKey(Object key) {
            return this.submap.containsKey(key);
        }

        public boolean containsValue(Object key) {
            return this.submap.containsValue(key);
        }

        public Object get(Object key) {
            return this.submap.get(key);
        }

        public Object put(Object key, Object value) {
            SortedMap.this.write();
            return this.submap.put(key, value);
        }

        public Object remove(Object key) {
            SortedMap.this.write();
            return this.submap.remove(key);
        }

        public void putAll(java.util.Map other) {
            SortedMap.this.write();
            this.submap.putAll(other);
        }

        public void clear() {
            SortedMap.this.write();
            this.submap.clear();
        }

        public Set keySet() {
            return new AbstractPersistentCollection.SetProxy(this.submap.keySet());
        }

        public Collection values() {
            return new AbstractPersistentCollection.SetProxy(this.submap.values());
        }

        public Set entrySet() {
            return new Map.EntrySetProxy(this.submap.entrySet());
        }

        public Comparator comparator() {
            return this.submap.comparator();
        }

        public java.util.SortedMap subMap(Object fromKey, Object toKey) {
            java.util.SortedMap m = this.submap.subMap(fromKey, toKey);
            return new SortedSubMap(m);
        }

        public java.util.SortedMap headMap(Object toKey) {
            java.util.SortedMap m = this.submap.headMap(toKey);
            return new SortedSubMap(m);
        }

        public java.util.SortedMap tailMap(Object fromKey) {
            java.util.SortedMap m = this.submap.tailMap(fromKey);
            return new SortedSubMap(m);
        }

        public Object firstKey() {
            return this.submap.firstKey();
        }

        public Object lastKey() {
            return this.submap.lastKey();
        }
    }
}

