/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.criterion;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.hibernate.Criteria;
import org.hibernate.EntityMode;
import org.hibernate.HibernateException;
import org.hibernate.criterion.CriteriaQuery;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.MatchMode;
import org.hibernate.criterion.NullExpression;
import org.hibernate.criterion.SimpleExpression;
import org.hibernate.engine.TypedValue;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.type.AbstractComponentType;
import org.hibernate.type.Type;
import org.hibernate.util.StringHelper;

public class Example
implements Criterion {
    private final Object entity;
    private final Set excludedProperties = new HashSet();
    private PropertySelector selector;
    private boolean isLikeEnabled;
    private boolean isIgnoreCaseEnabled;
    private MatchMode matchMode;
    private static final PropertySelector NOT_NULL = new NotNullPropertySelector();
    private static final PropertySelector ALL = new AllPropertySelector();
    private static final PropertySelector NOT_NULL_OR_ZERO = new NotNullOrZeroPropertySelector();
    private static final Object[] TYPED_VALUES = new TypedValue[0];

    public Example setPropertySelector(PropertySelector selector) {
        this.selector = selector;
        return this;
    }

    public Example excludeZeroes() {
        this.setPropertySelector(NOT_NULL_OR_ZERO);
        return this;
    }

    public Example excludeNone() {
        this.setPropertySelector(ALL);
        return this;
    }

    public Example enableLike(MatchMode matchMode) {
        this.isLikeEnabled = true;
        this.matchMode = matchMode;
        return this;
    }

    public Example enableLike() {
        return this.enableLike(MatchMode.EXACT);
    }

    public Example ignoreCase() {
        this.isIgnoreCaseEnabled = true;
        return this;
    }

    public Example excludeProperty(String name) {
        this.excludedProperties.add(name);
        return this;
    }

    public static Example create(Object entity) {
        if (entity == null) {
            throw new NullPointerException("null example");
        }
        return new Example(entity, NOT_NULL);
    }

    protected Example(Object entity, PropertySelector selector) {
        this.entity = entity;
        this.selector = selector;
    }

    public String toString() {
        return "example (" + this.entity + ')';
    }

    private boolean isPropertyIncluded(Object value, String name, Type type) {
        return !this.excludedProperties.contains(name) && !type.isAssociationType() && this.selector.include(value, name, type);
    }

    public String toSqlString(Criteria criteria, CriteriaQuery criteriaQuery) throws HibernateException {
        StringBuffer buf = new StringBuffer().append('(');
        EntityPersister meta = criteriaQuery.getFactory().getEntityPersister(criteriaQuery.getEntityName(criteria));
        String[] propertyNames = meta.getPropertyNames();
        Type[] propertyTypes = meta.getPropertyTypes();
        Object[] propertyValues = meta.getPropertyValues(this.entity, this.getEntityMode(criteria, criteriaQuery));
        int i = 0;
        while (i < propertyNames.length) {
            boolean isPropertyIncluded;
            Object propertyValue = propertyValues[i];
            String propertyName = propertyNames[i];
            boolean bl = isPropertyIncluded = i != meta.getVersionProperty() && this.isPropertyIncluded(propertyValue, propertyName, propertyTypes[i]);
            if (isPropertyIncluded) {
                if (propertyTypes[i].isComponentType()) {
                    this.appendComponentCondition(propertyName, propertyValue, (AbstractComponentType)propertyTypes[i], criteria, criteriaQuery, buf);
                } else {
                    this.appendPropertyCondition(propertyName, propertyValue, criteria, criteriaQuery, buf);
                }
            }
            ++i;
        }
        if (buf.length() == 1) {
            buf.append("1=1");
        }
        return buf.append(')').toString();
    }

    public TypedValue[] getTypedValues(Criteria criteria, CriteriaQuery criteriaQuery) throws HibernateException {
        EntityPersister meta = criteriaQuery.getFactory().getEntityPersister(criteriaQuery.getEntityName(criteria));
        String[] propertyNames = meta.getPropertyNames();
        Type[] propertyTypes = meta.getPropertyTypes();
        Object[] values = meta.getPropertyValues(this.entity, this.getEntityMode(criteria, criteriaQuery));
        ArrayList list = new ArrayList();
        int i = 0;
        while (i < propertyNames.length) {
            boolean isPropertyIncluded;
            Object value = values[i];
            Type type = propertyTypes[i];
            String name = propertyNames[i];
            boolean bl = isPropertyIncluded = i != meta.getVersionProperty() && this.isPropertyIncluded(value, name, type);
            if (isPropertyIncluded) {
                if (propertyTypes[i].isComponentType()) {
                    this.addComponentTypedValues(name, value, (AbstractComponentType)type, list, criteria, criteriaQuery);
                } else {
                    this.addPropertyTypedValue(value, type, list);
                }
            }
            ++i;
        }
        return (TypedValue[])list.toArray(TYPED_VALUES);
    }

    private EntityMode getEntityMode(Criteria criteria, CriteriaQuery criteriaQuery) {
        EntityPersister meta = criteriaQuery.getFactory().getEntityPersister(criteriaQuery.getEntityName(criteria));
        EntityMode result = meta.guessEntityMode(this.entity);
        if (result == null) {
            throw new ClassCastException(this.entity.getClass().getName());
        }
        return result;
    }

    protected void addPropertyTypedValue(Object value, Type type, List list) {
        if (value != null) {
            if (value instanceof String) {
                String string = (String)value;
                if (this.isIgnoreCaseEnabled) {
                    string = string.toLowerCase();
                }
                if (this.isLikeEnabled) {
                    string = this.matchMode.toMatchString(string);
                }
                value = string;
            }
            list.add(new TypedValue(type, value, null));
        }
    }

    protected void addComponentTypedValues(String path, Object component, AbstractComponentType type, List list, Criteria criteria, CriteriaQuery criteriaQuery) throws HibernateException {
        if (component != null) {
            String[] propertyNames = type.getPropertyNames();
            Type[] subtypes = type.getSubtypes();
            Object[] values = type.getPropertyValues(component, this.getEntityMode(criteria, criteriaQuery));
            int i = 0;
            while (i < propertyNames.length) {
                Object value = values[i];
                Type subtype = subtypes[i];
                String subpath = StringHelper.qualify(path, propertyNames[i]);
                if (this.isPropertyIncluded(value, subpath, subtype)) {
                    if (subtype.isComponentType()) {
                        this.addComponentTypedValues(subpath, value, (AbstractComponentType)subtype, list, criteria, criteriaQuery);
                    } else {
                        this.addPropertyTypedValue(value, subtype, list);
                    }
                }
                ++i;
            }
        }
    }

    protected void appendPropertyCondition(String propertyName, Object propertyValue, Criteria criteria, CriteriaQuery cq, StringBuffer buf) throws HibernateException {
        Criterion crit;
        if (propertyValue != null) {
            boolean isString = propertyValue instanceof String;
            String op = this.isLikeEnabled && isString ? " like " : "=";
            crit = new SimpleExpression(propertyName, propertyValue, op, this.isIgnoreCaseEnabled && isString);
        } else {
            crit = new NullExpression(propertyName);
        }
        String critCondition = crit.toSqlString(criteria, cq);
        if (buf.length() > 1 && critCondition.trim().length() > 0) {
            buf.append(" and ");
        }
        buf.append(critCondition);
    }

    protected void appendComponentCondition(String path, Object component, AbstractComponentType type, Criteria criteria, CriteriaQuery criteriaQuery, StringBuffer buf) throws HibernateException {
        if (component != null) {
            String[] propertyNames = type.getPropertyNames();
            Object[] values = type.getPropertyValues(component, this.getEntityMode(criteria, criteriaQuery));
            Type[] subtypes = type.getSubtypes();
            int i = 0;
            while (i < propertyNames.length) {
                Object value = values[i];
                String subpath = StringHelper.qualify(path, propertyNames[i]);
                if (this.isPropertyIncluded(value, subpath, subtypes[i])) {
                    Type subtype = subtypes[i];
                    if (subtype.isComponentType()) {
                        this.appendComponentCondition(subpath, value, (AbstractComponentType)subtype, criteria, criteriaQuery, buf);
                    } else {
                        this.appendPropertyCondition(subpath, value, criteria, criteriaQuery, buf);
                    }
                }
                ++i;
            }
        }
    }

    public static interface PropertySelector {
        public boolean include(Object var1, String var2, Type var3);
    }

    static final class AllPropertySelector
    implements PropertySelector {
        AllPropertySelector() {
        }

        public boolean include(Object object, String propertyName, Type type) {
            return true;
        }
    }

    static final class NotNullPropertySelector
    implements PropertySelector {
        NotNullPropertySelector() {
        }

        public boolean include(Object object, String propertyName, Type type) {
            return object != null;
        }
    }

    static final class NotNullOrZeroPropertySelector
    implements PropertySelector {
        NotNullOrZeroPropertySelector() {
        }

        public boolean include(Object object, String propertyName, Type type) {
            return object != null && (!(object instanceof Number) || ((Number)object).longValue() != 0L);
        }
    }
}

