/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.criterion;

import org.hibernate.Criteria;
import org.hibernate.HibernateException;
import org.hibernate.criterion.CriteriaQuery;
import org.hibernate.criterion.Criterion;
import org.hibernate.engine.TypedValue;
import org.hibernate.util.StringHelper;

public class SimpleExpression
implements Criterion {
    private final String propertyName;
    private final Object value;
    private boolean ignoreCase;
    private final String op;

    protected SimpleExpression(String propertyName, Object value, String op) {
        this.propertyName = propertyName;
        this.value = value;
        this.op = op;
    }

    protected SimpleExpression(String propertyName, Object value, String op, boolean ignoreCase) {
        this.propertyName = propertyName;
        this.value = value;
        this.ignoreCase = ignoreCase;
        this.op = op;
    }

    public SimpleExpression ignoreCase() {
        this.ignoreCase = true;
        return this;
    }

    public String toSqlString(Criteria criteria, CriteriaQuery criteriaQuery) throws HibernateException {
        String[] columns = criteriaQuery.getColumnsUsingProjection(criteria, this.propertyName);
        if (this.ignoreCase) {
            if (columns.length != 1) {
                throw new HibernateException("case insensitive expression may only be applied to single-column properties: " + this.propertyName);
            }
            return criteriaQuery.getFactory().getDialect().getLowercaseFunction() + '(' + columns[0] + ')' + this.getOp() + "?";
        }
        String result = StringHelper.join(" and ", StringHelper.suffix(columns, String.valueOf(this.getOp()) + "?"));
        if (columns.length > 1) {
            result = String.valueOf('(') + result + ')';
        }
        return result;
    }

    public TypedValue[] getTypedValues(Criteria criteria, CriteriaQuery criteriaQuery) throws HibernateException {
        Object icvalue = this.ignoreCase ? this.value.toString().toLowerCase() : this.value;
        return new TypedValue[]{criteriaQuery.getTypedValue(criteria, this.propertyName, icvalue)};
    }

    public String toString() {
        return String.valueOf(this.propertyName) + this.getOp() + this.value;
    }

    protected final String getOp() {
        return this.op;
    }
}

