/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect;

import org.hibernate.Hibernate;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.function.NoArgSQLFunction;
import org.hibernate.dialect.function.SQLFunctionTemplate;
import org.hibernate.dialect.function.StandardSQLFunction;
import org.hibernate.exception.ErrorCodeConverter;
import org.hibernate.exception.SQLExceptionConverter;
import org.hibernate.exception.ViolatedConstraintNameExtracter;
import org.hibernate.util.StringHelper;

public class MySQLDialect
extends Dialect {
    public MySQLDialect() {
        this.registerColumnType(-7, "bit");
        this.registerColumnType(-5, "bigint");
        this.registerColumnType(5, "smallint");
        this.registerColumnType(-6, "tinyint");
        this.registerColumnType(4, "integer");
        this.registerColumnType(1, "char(1)");
        this.registerColumnType(12, "longtext");
        this.registerColumnType(12, 0xFFFFFF, "mediumtext");
        this.registerColumnType(12, 65535, "text");
        this.registerColumnType(12, 255, "varchar($l)");
        this.registerColumnType(6, "float");
        this.registerColumnType(8, "double precision");
        this.registerColumnType(91, "date");
        this.registerColumnType(92, "time");
        this.registerColumnType(93, "datetime");
        this.registerColumnType(-3, "longblob");
        this.registerColumnType(-3, 0xFFFFFF, "mediumblob");
        this.registerColumnType(-3, 65535, "blob");
        this.registerColumnType(-3, 255, "tinyblob");
        this.registerColumnType(2, "numeric($p,$s)");
        this.registerColumnType(2004, "longblob");
        this.registerColumnType(2004, 0xFFFFFF, "mediumblob");
        this.registerColumnType(2004, 65535, "blob");
        this.registerColumnType(2005, "longtext");
        this.registerColumnType(2005, 0xFFFFFF, "mediumtext");
        this.registerColumnType(2005, 65535, "text");
        this.registerFunction("ascii", new StandardSQLFunction("ascii", Hibernate.INTEGER));
        this.registerFunction("bin", new StandardSQLFunction("bin", Hibernate.STRING));
        this.registerFunction("char_length", new StandardSQLFunction("char_length", Hibernate.LONG));
        this.registerFunction("character_length", new StandardSQLFunction("character_length", Hibernate.LONG));
        this.registerFunction("lcase", new StandardSQLFunction("lcase"));
        this.registerFunction("lower", new StandardSQLFunction("lower"));
        this.registerFunction("length", new StandardSQLFunction("length", Hibernate.LONG));
        this.registerFunction("ltrim", new StandardSQLFunction("ltrim"));
        this.registerFunction("ord", new StandardSQLFunction("ord", Hibernate.INTEGER));
        this.registerFunction("quote", new StandardSQLFunction("quote"));
        this.registerFunction("reverse", new StandardSQLFunction("reverse"));
        this.registerFunction("rtrim", new StandardSQLFunction("rtrim"));
        this.registerFunction("soundex", new StandardSQLFunction("soundex"));
        this.registerFunction("space", new StandardSQLFunction("space", Hibernate.STRING));
        this.registerFunction("ucase", new StandardSQLFunction("ucase"));
        this.registerFunction("upper", new StandardSQLFunction("upper"));
        this.registerFunction("unhex", new StandardSQLFunction("unhex", Hibernate.STRING));
        this.registerFunction("abs", new StandardSQLFunction("abs"));
        this.registerFunction("sign", new StandardSQLFunction("sign", Hibernate.INTEGER));
        this.registerFunction("acos", new StandardSQLFunction("acos", Hibernate.DOUBLE));
        this.registerFunction("asin", new StandardSQLFunction("asin", Hibernate.DOUBLE));
        this.registerFunction("atan", new StandardSQLFunction("atan", Hibernate.DOUBLE));
        this.registerFunction("cos", new StandardSQLFunction("cos", Hibernate.DOUBLE));
        this.registerFunction("cot", new StandardSQLFunction("cot", Hibernate.DOUBLE));
        this.registerFunction("crc32", new StandardSQLFunction("crc32", Hibernate.LONG));
        this.registerFunction("exp", new StandardSQLFunction("exp", Hibernate.DOUBLE));
        this.registerFunction("ln", new StandardSQLFunction("ln", Hibernate.DOUBLE));
        this.registerFunction("log", new StandardSQLFunction("log", Hibernate.DOUBLE));
        this.registerFunction("log2", new StandardSQLFunction("log2", Hibernate.DOUBLE));
        this.registerFunction("log10", new StandardSQLFunction("log10", Hibernate.DOUBLE));
        this.registerFunction("pi", new NoArgSQLFunction("pi", Hibernate.DOUBLE));
        this.registerFunction("rand", new NoArgSQLFunction("rand", Hibernate.DOUBLE));
        this.registerFunction("sin", new StandardSQLFunction("sin", Hibernate.DOUBLE));
        this.registerFunction("sqrt", new StandardSQLFunction("sqrt", Hibernate.DOUBLE));
        this.registerFunction("tan", new StandardSQLFunction("tan", Hibernate.DOUBLE));
        this.registerFunction("radians", new StandardSQLFunction("radians", Hibernate.DOUBLE));
        this.registerFunction("degrees", new StandardSQLFunction("degrees", Hibernate.DOUBLE));
        this.registerFunction("ceiling", new StandardSQLFunction("ceiling", Hibernate.INTEGER));
        this.registerFunction("ceil", new StandardSQLFunction("ceil", Hibernate.INTEGER));
        this.registerFunction("floor", new StandardSQLFunction("floor", Hibernate.INTEGER));
        this.registerFunction("round", new StandardSQLFunction("round", Hibernate.INTEGER));
        this.registerFunction("curdate", new NoArgSQLFunction("curdate", Hibernate.DATE));
        this.registerFunction("curtime", new NoArgSQLFunction("curtime", Hibernate.TIME));
        this.registerFunction("current_date", new NoArgSQLFunction("current_date", Hibernate.DATE, false));
        this.registerFunction("current_time", new NoArgSQLFunction("current_time", Hibernate.TIME, false));
        this.registerFunction("current_timestamp", new NoArgSQLFunction("current_timestamp", Hibernate.TIMESTAMP, false));
        this.registerFunction("date", new StandardSQLFunction("date", Hibernate.DATE));
        this.registerFunction("day", new StandardSQLFunction("day", Hibernate.INTEGER));
        this.registerFunction("dayofmonth", new StandardSQLFunction("dayofmonth", Hibernate.INTEGER));
        this.registerFunction("dayname", new StandardSQLFunction("dayname", Hibernate.STRING));
        this.registerFunction("dayofweek", new StandardSQLFunction("dayofweek", Hibernate.INTEGER));
        this.registerFunction("dayofyear", new StandardSQLFunction("dayofyear", Hibernate.INTEGER));
        this.registerFunction("from_days", new StandardSQLFunction("from_days", Hibernate.DATE));
        this.registerFunction("from_unixtime", new StandardSQLFunction("from_unixtime", Hibernate.TIMESTAMP));
        this.registerFunction("hour", new StandardSQLFunction("hour", Hibernate.INTEGER));
        this.registerFunction("last_day", new StandardSQLFunction("last_day", Hibernate.DATE));
        this.registerFunction("localtime", new NoArgSQLFunction("localtime", Hibernate.TIMESTAMP));
        this.registerFunction("localtimestamp", new NoArgSQLFunction("localtimestamp", Hibernate.TIMESTAMP));
        this.registerFunction("microseconds", new StandardSQLFunction("microseconds", Hibernate.INTEGER));
        this.registerFunction("minute", new StandardSQLFunction("minute", Hibernate.INTEGER));
        this.registerFunction("month", new StandardSQLFunction("month", Hibernate.INTEGER));
        this.registerFunction("monthname", new StandardSQLFunction("monthname", Hibernate.STRING));
        this.registerFunction("now", new NoArgSQLFunction("now", Hibernate.TIMESTAMP));
        this.registerFunction("quarter", new StandardSQLFunction("quarter", Hibernate.INTEGER));
        this.registerFunction("second", new StandardSQLFunction("second", Hibernate.INTEGER));
        this.registerFunction("sec_to_time", new StandardSQLFunction("sec_to_time", Hibernate.TIME));
        this.registerFunction("sysdate", new NoArgSQLFunction("sysdate", Hibernate.TIMESTAMP));
        this.registerFunction("time", new StandardSQLFunction("time", Hibernate.TIME));
        this.registerFunction("timestamp", new StandardSQLFunction("timestamp", Hibernate.TIMESTAMP));
        this.registerFunction("time_to_sec", new StandardSQLFunction("time_to_sec", Hibernate.INTEGER));
        this.registerFunction("to_days", new StandardSQLFunction("to_days", Hibernate.LONG));
        this.registerFunction("unix_timestamp", new StandardSQLFunction("unix_timestamp", Hibernate.LONG));
        this.registerFunction("utc_date", new NoArgSQLFunction("utc_date", Hibernate.STRING));
        this.registerFunction("utc_time", new NoArgSQLFunction("utc_time", Hibernate.STRING));
        this.registerFunction("utc_timestamp", new NoArgSQLFunction("utc_timestamp", Hibernate.STRING));
        this.registerFunction("week", new StandardSQLFunction("week", Hibernate.INTEGER));
        this.registerFunction("weekday", new StandardSQLFunction("weekday", Hibernate.INTEGER));
        this.registerFunction("weekofyear", new StandardSQLFunction("weekofyear", Hibernate.INTEGER));
        this.registerFunction("year", new StandardSQLFunction("year", Hibernate.INTEGER));
        this.registerFunction("yearweek", new StandardSQLFunction("yearweek", Hibernate.INTEGER));
        this.registerFunction("hex", new StandardSQLFunction("hex", Hibernate.STRING));
        this.registerFunction("oct", new StandardSQLFunction("oct", Hibernate.STRING));
        this.registerFunction("octet_length", new StandardSQLFunction("octet_length", Hibernate.LONG));
        this.registerFunction("bit_length", new StandardSQLFunction("bit_length", Hibernate.LONG));
        this.registerFunction("bit_count", new StandardSQLFunction("bit_count", Hibernate.LONG));
        this.registerFunction("encrypt", new StandardSQLFunction("encrypt", Hibernate.STRING));
        this.registerFunction("md5", new StandardSQLFunction("md5", Hibernate.STRING));
        this.registerFunction("sha1", new StandardSQLFunction("sha1", Hibernate.STRING));
        this.registerFunction("sha", new StandardSQLFunction("sha", Hibernate.STRING));
        this.registerFunction("concat", new SQLFunctionTemplate(Hibernate.STRING, "concat(?1 || ?2)"));
        this.getDefaultProperties().setProperty("hibernate.max_fetch_depth", "2");
        this.getDefaultProperties().setProperty("hibernate.jdbc.batch_size", "15");
    }

    public String getAddColumnString() {
        return "add column";
    }

    public boolean qualifyIndexName() {
        return false;
    }

    public boolean supportsIdentityColumns() {
        return true;
    }

    public String getIdentitySelectString() {
        return "select last_insert_id()";
    }

    public String getIdentityColumnString() {
        return "not null auto_increment";
    }

    public String getAddForeignKeyConstraintString(String constraintName, String[] foreignKey, String referencedTable, String[] primaryKey) {
        String cols = StringHelper.join(", ", foreignKey);
        return new StringBuffer(30).append(" add index ").append(constraintName).append(" (").append(cols).append("), add constraint ").append(constraintName).append(" foreign key (").append(cols).append(") references ").append(referencedTable).append(" (").append(StringHelper.join(", ", primaryKey)).append(')').toString();
    }

    public boolean supportsLimit() {
        return true;
    }

    public String getDropForeignKeyString() {
        return " drop foreign key ";
    }

    public String getLimitString(String sql, boolean hasOffset) {
        return new StringBuffer(sql.length() + 20).append(sql).append(hasOffset ? " limit ?, ?" : " limit ?").toString();
    }

    public char closeQuote() {
        return '`';
    }

    public char openQuote() {
        return '`';
    }

    public boolean supportsIfExistsBeforeTableName() {
        return true;
    }

    public char getSchemaSeparator() {
        return '_';
    }

    public String getSelectGUIDString() {
        return "select uuid()";
    }

    public boolean supportsCascadeDelete() {
        return false;
    }

    public SQLExceptionConverter buildSQLExceptionConverter() {
        return new ExceptionConverter(this.getViolatedConstraintNameExtracter());
    }

    private static class ExceptionConverter
    extends ErrorCodeConverter {
        private int[] sqlGrammarCodes = new int[]{1054, 1064, 1146};
        private int[] integrityViolationCodes = new int[]{1062, 1216};
        private int[] connectionCodes = new int[]{1049};
        private int[] lockAcquisitionErrorCodes = new int[]{1099, 1100, 1150, 1165, 1192, 1205, 1206, 1207, 1213, 1223};

        public ExceptionConverter(ViolatedConstraintNameExtracter extracter) {
            super(extracter);
        }

        protected int[] getSQLGrammarErrorCodes() {
            return this.sqlGrammarCodes;
        }

        protected int[] getIntegrityViolationErrorCodes() {
            return this.integrityViolationCodes;
        }

        protected int[] getConnectionErrorCodes() {
            return this.connectionCodes;
        }

        protected int[] getLockAcquisitionErrorCodes() {
            return this.lockAcquisitionErrorCodes;
        }
    }
}

