/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect;

import org.hibernate.dialect.Oracle9Dialect;
import org.hibernate.sql.CaseFragment;
import org.hibernate.sql.DecodeCaseFragment;
import org.hibernate.sql.JoinFragment;
import org.hibernate.sql.OracleJoinFragment;

public class OracleDialect
extends Oracle9Dialect {
    public OracleDialect() {
        this.registerColumnType(93, "date");
    }

    public JoinFragment createOuterJoinFragment() {
        return new OracleJoinFragment();
    }

    public CaseFragment createCaseFragment() {
        return new DecodeCaseFragment();
    }

    public String getLimitString(String sql, boolean hasOffset) {
        StringBuffer pagingSelect = new StringBuffer(sql.length() + 100);
        if (hasOffset) {
            pagingSelect.append("select * from ( select row_.*, rownum rownum_ from ( ");
        } else {
            pagingSelect.append("select * from ( ");
        }
        pagingSelect.append(sql);
        if (hasOffset) {
            pagingSelect.append(" ) row_ ) where rownum_ <= ? and rownum_ > ?");
        } else {
            pagingSelect.append(" ) where rownum <= ?");
        }
        return pagingSelect.toString();
    }

    public String getSelectClauseNullString(int sqlType) {
        String literal;
        switch (sqlType) {
            case 12: {
                literal = "'x'";
                break;
            }
            case 1: {
                literal = "'x'";
                break;
            }
            case 91: {
                literal = "'2000-1-1'";
                break;
            }
            case 93: {
                literal = "'2000-1-1 00:00:00'";
            }
            case 92: {
                literal = "'00:00:00'";
            }
            default: {
                literal = "0";
            }
        }
        return "nullif(" + literal + ',' + literal + ')';
    }
}

