/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.AssertionFailure;
import org.hibernate.HibernateException;
import org.hibernate.action.CollectionRecreateAction;
import org.hibernate.action.CollectionRemoveAction;
import org.hibernate.action.CollectionUpdateAction;
import org.hibernate.action.EntityDeleteAction;
import org.hibernate.action.EntityIdentityInsertAction;
import org.hibernate.action.EntityInsertAction;
import org.hibernate.action.EntityUpdateAction;
import org.hibernate.action.Executable;
import org.hibernate.cache.CacheException;
import org.hibernate.engine.SessionImplementor;

public class ActionQueue
implements Serializable {
    private static final Log log;
    private static final int INIT_QUEUE_LIST_SIZE = 5;
    private SessionImplementor session;
    private ArrayList insertions;
    private ArrayList deletions;
    private ArrayList updates;
    private ArrayList collectionCreations;
    private ArrayList collectionUpdates;
    private ArrayList collectionRemovals;
    private transient ArrayList executions;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.hibernate.engine.ActionQueue");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LogFactory.getLog((Class)clazz);
    }

    public ActionQueue(SessionImplementor session) {
        this.session = session;
        this.insertions = new ArrayList(5);
        this.deletions = new ArrayList(5);
        this.updates = new ArrayList(5);
        this.collectionCreations = new ArrayList(5);
        this.collectionRemovals = new ArrayList(5);
        this.collectionUpdates = new ArrayList(5);
        this.executions = new ArrayList(15);
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        ois.defaultReadObject();
        this.executions = new ArrayList(15);
    }

    public void clear() {
        this.updates.clear();
        this.insertions.clear();
        this.deletions.clear();
        this.collectionCreations.clear();
        this.collectionRemovals.clear();
        this.collectionUpdates.clear();
    }

    public void addAction(EntityInsertAction action) {
        this.insertions.add(action);
    }

    public void addAction(EntityDeleteAction action) {
        this.deletions.add(action);
    }

    public void addAction(EntityUpdateAction action) {
        this.updates.add(action);
    }

    public void addAction(CollectionRecreateAction action) {
        this.collectionCreations.add(action);
    }

    public void addAction(CollectionRemoveAction action) {
        this.collectionRemovals.add(action);
    }

    public void addAction(CollectionUpdateAction action) {
        this.collectionUpdates.add(action);
    }

    public void addAction(EntityIdentityInsertAction insert) {
        this.insertions.add(insert);
    }

    public void executeInserts() throws HibernateException {
        this.executeActions(this.insertions);
    }

    public void executeActions() throws HibernateException {
        this.executeActions(this.insertions);
        this.executeActions(this.updates);
        this.executeActions(this.collectionRemovals);
        this.executeActions(this.collectionUpdates);
        this.executeActions(this.collectionCreations);
        this.executeActions(this.deletions);
    }

    public void prepareActions() throws HibernateException {
        this.prepareActions(this.collectionRemovals);
        this.prepareActions(this.collectionUpdates);
        this.prepareActions(this.collectionCreations);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void afterTransactionCompletion(boolean success) {
        int size = this.executions.size();
        boolean invalidateQueryCache = this.session.getFactory().getSettings().isQueryCacheEnabled();
        int i = 0;
        while (true) {
            if (i >= size) {
                this.executions.clear();
                return;
            }
            try {
                Object var6_8;
                Executable exec = (Executable)this.executions.get(i);
                try {
                    exec.afterTransactionCompletion(success);
                }
                catch (Throwable throwable) {
                    var6_8 = null;
                    if (invalidateQueryCache) {
                        this.session.getFactory().getUpdateTimestampsCache().invalidate(exec.getPropertySpaces());
                    }
                    throw throwable;
                }
                {
                    var6_8 = null;
                    if (invalidateQueryCache) {
                        this.session.getFactory().getUpdateTimestampsCache().invalidate(exec.getPropertySpaces());
                    }
                }
            }
            catch (CacheException ce) {
                log.error((Object)"could not release a cache lock", (Throwable)ce);
            }
            catch (Exception e) {
                throw new AssertionFailure("Exception releasing cache locks", e);
            }
            ++i;
        }
    }

    public boolean areTablesToBeUpdated(Set tables) {
        return ActionQueue.areTablesToUpdated(this.updates, tables) || ActionQueue.areTablesToUpdated(this.insertions, tables) || ActionQueue.areTablesToUpdated(this.deletions, tables) || ActionQueue.areTablesToUpdated(this.collectionUpdates, tables) || ActionQueue.areTablesToUpdated(this.collectionCreations, tables) || ActionQueue.areTablesToUpdated(this.collectionRemovals, tables);
    }

    public boolean areInsertionsOrDeletionsQueued() {
        return this.insertions.size() > 0 || this.deletions.size() > 0;
    }

    private static boolean areTablesToUpdated(List executables, Set set) {
        int size = executables.size();
        int j = 0;
        while (j < size) {
            Serializable[] spaces = ((Executable)executables.get(j)).getPropertySpaces();
            int i = 0;
            while (i < spaces.length) {
                if (set.contains(spaces[i])) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("changes must be flushed to space: " + spaces[i]));
                    }
                    return true;
                }
                ++i;
            }
            ++j;
        }
        return false;
    }

    private void executeActions(List list) throws HibernateException {
        int size = list.size();
        int i = 0;
        while (i < size) {
            this.execute((Executable)list.get(i));
            ++i;
        }
        list.clear();
        this.session.getBatcher().executeBatch();
    }

    public void execute(Executable executable) {
        boolean lockQueryCache = this.session.getFactory().getSettings().isQueryCacheEnabled();
        if (executable.hasAfterTransactionCompletion() || lockQueryCache) {
            this.executions.add(executable);
        }
        if (lockQueryCache) {
            this.session.getFactory().getUpdateTimestampsCache().preinvalidate(executable.getPropertySpaces());
        }
        executable.execute();
    }

    private void prepareActions(List queue) throws HibernateException {
        int size = queue.size();
        int i = 0;
        while (i < size) {
            Executable executable = (Executable)queue.get(i);
            executable.beforeExecutions();
            ++i;
        }
    }

    public String toString() {
        return "ActionQueue[insertions=" + this.insertions + " updates=" + this.updates + " deletions=" + this.deletions + " collectionCreations=" + this.collectionCreations + " collectionRemovals=" + this.collectionRemovals + " collectionUpdates=" + this.collectionUpdates + "]";
    }

    public int numberOfCollectionRemovals() {
        return this.collectionRemovals.size();
    }

    public int numberOfCollectionUpdates() {
        return this.collectionUpdates.size();
    }

    public int numberOfCollectionCreations() {
        return this.collectionCreations.size();
    }

    public int numberOfDeletions() {
        return this.deletions.size();
    }

    public int numberOfUpdates() {
        return this.updates.size();
    }

    public int numberOfInsertions() {
        return this.insertions.size();
    }

    public void sortCollectionActions() {
        if (this.session.getFactory().getSettings().isOrderUpdatesEnabled()) {
            Collections.sort(this.collectionCreations);
            Collections.sort(this.collectionUpdates);
            Collections.sort(this.collectionRemovals);
        }
    }

    public void sortUpdateActions() {
        if (this.session.getFactory().getSettings().isOrderUpdatesEnabled()) {
            Collections.sort(this.updates);
        }
    }

    public ArrayList cloneDeletions() {
        return (ArrayList)this.deletions.clone();
    }

    public void clearFromFlushNeededCheck(int previousCollectionRemovalSize) {
        this.collectionCreations.clear();
        this.collectionUpdates.clear();
        this.updates.clear();
        int i = this.collectionRemovals.size() - 1;
        while (i >= previousCollectionRemovalSize) {
            this.collectionRemovals.remove(i);
            --i;
        }
    }

    public List suspendNewDeletions(ArrayList oldDeletions) {
        List suspendedDeletions = this.deletions.subList(oldDeletions.size(), this.deletions.size());
        this.deletions = oldDeletions;
        return suspendedDeletions;
    }

    public void resumeSuspendedDeletions(List suspendedDeletions) {
        this.deletions.addAll(suspendedDeletions);
    }

    public boolean hasAnyQueuedActions() {
        return this.updates.size() > 0 || this.insertions.size() > 0 || this.deletions.size() > 0 || this.collectionUpdates.size() > 0 || this.collectionRemovals.size() > 0 || this.collectionCreations.size() > 0;
    }
}

