/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine;

import java.io.Serializable;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.collections.ReferenceMap;
import org.apache.commons.collections.SequencedHashMap;
import org.hibernate.EntityMode;
import org.hibernate.engine.CollectionEntry;
import org.hibernate.engine.EntityKey;
import org.hibernate.engine.PersistenceContext;
import org.hibernate.engine.Subquery;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.util.MarkerObject;

public class BatchFetchQueue {
    public static final Object MARKER = new MarkerObject("MARKER");
    private final Map batchLoadableEntityKeys = new SequencedHashMap(8);
    private final Map subqueriesByEntityKey = new ReferenceMap(0, 1);
    private final PersistenceContext context;

    public BatchFetchQueue(PersistenceContext context) {
        this.context = context;
    }

    public void clear() {
        this.batchLoadableEntityKeys.clear();
        this.subqueriesByEntityKey.clear();
    }

    public Subquery getSubquery(EntityKey key) {
        return (Subquery)this.subqueriesByEntityKey.get(key);
    }

    public void addSubquery(EntityKey key, Subquery subquery) {
        this.subqueriesByEntityKey.put(key, subquery);
    }

    public void clearSubqueries() {
        this.subqueriesByEntityKey.clear();
    }

    public void removeBatchLoadableEntityKey(EntityKey key) {
        if (key.isBatchLoadable()) {
            this.batchLoadableEntityKeys.remove(key);
        }
    }

    public void removeSubquery(EntityKey key) {
        this.subqueriesByEntityKey.remove(key);
    }

    public void addBatchLoadableEntityKey(EntityKey key) {
        if (key.isBatchLoadable()) {
            this.batchLoadableEntityKeys.put(key, MARKER);
        }
    }

    public Serializable[] getCollectionBatch(CollectionPersister collectionPersister, Serializable id, int batchSize, EntityMode entityMode) {
        Serializable[] keys = new Serializable[batchSize];
        keys[0] = id;
        int i = 1;
        int end = -1;
        boolean checkForEnd = false;
        Iterator iter = this.context.getCollectionEntries().values().iterator();
        while (iter.hasNext()) {
            CollectionEntry ce = (CollectionEntry)iter.next();
            if (ce.isInitialized() || ce.getLoadedPersister() != collectionPersister) continue;
            if (checkForEnd && i == end) {
                return keys;
            }
            boolean isEqual = collectionPersister.getKeyType().isEqual(id, ce.getLoadedKey(), entityMode, collectionPersister.getFactory());
            if (isEqual) {
                end = i;
            } else {
                keys[i++] = ce.getLoadedKey();
            }
            if (i != batchSize) continue;
            i = 1;
            if (end == -1) continue;
            checkForEnd = true;
        }
        return keys;
    }

    public Serializable[] getEntityBatch(String entityName, Serializable id, int batchSize) {
        Serializable[] ids = new Serializable[batchSize];
        ids[0] = id;
        int i = 1;
        int end = -1;
        boolean checkForEnd = false;
        Iterator iter = this.batchLoadableEntityKeys.keySet().iterator();
        while (iter.hasNext()) {
            EntityKey key = (EntityKey)iter.next();
            if (!key.getEntityName().equals(entityName)) continue;
            if (checkForEnd && i == end) {
                return ids;
            }
            if (id.equals(key.getIdentifier())) {
                end = i;
            } else {
                ids[i++] = key.getIdentifier();
            }
            if (i != batchSize) continue;
            i = 1;
            if (end == -1) continue;
            checkForEnd = true;
        }
        return ids;
    }
}

