/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine;

import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.FlushMode;
import org.hibernate.Transaction;
import org.hibernate.TransactionException;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.util.JTAHelper;

public final class CacheSynchronization
implements Synchronization {
    private static final Log log = LogFactory.getLog((Class)(class$org$hibernate$engine$CacheSynchronization == null ? (class$org$hibernate$engine$CacheSynchronization = CacheSynchronization.class$("org.hibernate.engine.CacheSynchronization")) : class$org$hibernate$engine$CacheSynchronization));
    private final SessionImplementor session;
    private final javax.transaction.Transaction transaction;
    private final Transaction hibernateTransaction;
    static /* synthetic */ Class class$org$hibernate$engine$CacheSynchronization;

    public CacheSynchronization(SessionImplementor session, javax.transaction.Transaction transaction, Transaction tx) {
        this.session = session;
        this.transaction = transaction;
        this.hibernateTransaction = tx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void beforeCompletion() {
        boolean flush;
        log.trace((Object)"transaction before completion callback");
        try {
            flush = this.session.getFlushMode() != FlushMode.NEVER && this.session.getFactory().getSettings().isFlushBeforeCompletionEnabled() && !JTAHelper.isRollback(this.transaction.getStatus());
        }
        catch (SystemException se) {
            log.error((Object)"could not determine transaction status", (Throwable)se);
            throw new TransactionException("could not determine transaction status in beforeCompletion()", (Exception)((Object)se));
        }
        try {
            if (flush) {
                log.trace((Object)"automatically flushing session");
                this.session.flush();
            }
            Object var4_3 = null;
            this.session.beforeTransactionCompletion(this.hibernateTransaction);
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.session.beforeTransactionCompletion(this.hibernateTransaction);
            if (this.session.getFactory().getSettings().isAutoCloseSessionEnabled() && this.session.isOpen()) {
                log.trace((Object)"automatically closing session");
                this.session.close();
            }
            throw throwable;
        }
        if (this.session.getFactory().getSettings().isAutoCloseSessionEnabled() && this.session.isOpen()) {
            log.trace((Object)"automatically closing session");
            this.session.close();
        }
    }

    public void afterCompletion(int status) {
        if (log.isTraceEnabled()) {
            log.trace((Object)("transaction after completion callback, status: " + status));
        }
        this.session.afterTransactionCompletion(status == 3, this.hibernateTransaction);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

