/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine;

import java.io.Serializable;
import java.lang.reflect.Constructor;
import org.hibernate.InstantiationException;
import org.hibernate.MappingException;
import org.hibernate.engine.Cascades;
import org.hibernate.property.Getter;
import org.hibernate.type.IdentifierType;
import org.hibernate.type.PrimitiveType;
import org.hibernate.type.Type;
import org.hibernate.type.VersionType;

public class UnsavedValueFactory {
    private static Object instantiate(Constructor constructor) {
        try {
            return constructor.newInstance(null);
        }
        catch (Exception exception) {
            throw new InstantiationException("could not instantiate test object", constructor.getDeclaringClass());
        }
    }

    public static Cascades.IdentifierValue getUnsavedIdentifierValue(String unsavedValue, Getter identifierGetter, Type identifierType, Constructor constructor) {
        if (unsavedValue == null) {
            if (identifierGetter != null && constructor != null) {
                Serializable defaultValue = (Serializable)identifierGetter.get(UnsavedValueFactory.instantiate(constructor));
                return new Cascades.IdentifierValue(defaultValue);
            }
            if (identifierGetter != null && identifierType instanceof PrimitiveType) {
                Serializable defaultValue = ((PrimitiveType)identifierType).getDefaultValue();
                return new Cascades.IdentifierValue(defaultValue);
            }
            return Cascades.SAVE_NULL;
        }
        if ("null".equals(unsavedValue)) {
            return Cascades.SAVE_NULL;
        }
        if ("undefined".equals(unsavedValue)) {
            return Cascades.UNDEFINED;
        }
        if ("none".equals(unsavedValue)) {
            return Cascades.SAVE_NONE;
        }
        if ("any".equals(unsavedValue)) {
            return Cascades.SAVE_ANY;
        }
        try {
            return new Cascades.IdentifierValue((Serializable)((IdentifierType)identifierType).stringToObject(unsavedValue));
        }
        catch (ClassCastException classCastException) {
            throw new MappingException("Bad identifier type: " + identifierType.getName());
        }
        catch (Exception exception) {
            throw new MappingException("Could not parse identifier unsaved-value: " + unsavedValue);
        }
    }

    public static Cascades.VersionValue getUnsavedVersionValue(String versionUnsavedValue, Getter versionGetter, VersionType versionType, Constructor constructor) {
        if (versionUnsavedValue == null) {
            if (constructor != null) {
                Object defaultValue = versionGetter.get(UnsavedValueFactory.instantiate(constructor));
                return versionType.isEqual(versionType.seed(), defaultValue) ? Cascades.VERSION_UNDEFINED : new Cascades.VersionValue(defaultValue);
            }
            return Cascades.VERSION_UNDEFINED;
        }
        if ("undefined".equals(versionUnsavedValue)) {
            return Cascades.VERSION_UNDEFINED;
        }
        if ("null".equals(versionUnsavedValue)) {
            return Cascades.VERSION_SAVE_NULL;
        }
        if ("negative".equals(versionUnsavedValue)) {
            return Cascades.VERSION_NEGATIVE;
        }
        throw new MappingException("Could not parse version unsaved-value: " + versionUnsavedValue);
    }
}

