/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.event;

import java.util.List;
import org.hibernate.HibernateException;
import org.hibernate.event.SessionEventSource;
import org.hibernate.intercept.LazyPropertyInitializer;
import org.hibernate.persister.EntityPersister;
import org.hibernate.type.AbstractComponentType;
import org.hibernate.type.CollectionType;
import org.hibernate.type.EntityType;
import org.hibernate.type.QueryType;
import org.hibernate.type.Type;

public abstract class AbstractVisitor {
    private final SessionEventSource session;

    AbstractVisitor(SessionEventSource session) {
        this.session = session;
    }

    void processValues(Object[] values, Type[] types) throws HibernateException {
        for (int i = 0; i < types.length; ++i) {
            if (!this.includeProperty(values, i)) continue;
            this.processValue(values[i], types[i]);
        }
    }

    boolean includeProperty(Object[] values, int i) {
        return values[i] != LazyPropertyInitializer.UNFETCHED_PROPERTY;
    }

    Object processComponent(Object component, AbstractComponentType componentType) throws HibernateException {
        if (component != null) {
            this.processValues(componentType.getPropertyValues(component, this.session), componentType.getSubtypes());
        }
        return null;
    }

    final Object processValue(Object value, Type type) throws HibernateException {
        if (type.isPersistentCollectionType()) {
            return this.processCollection(value, (CollectionType)type);
        }
        if (type.isEntityType()) {
            return this.processEntity(value, (EntityType)type);
        }
        if (type.isComponentType()) {
            return this.processComponent(value, (AbstractComponentType)type);
        }
        if (type instanceof QueryType) {
            return this.processQueryList((List)value, (QueryType)type);
        }
        return null;
    }

    void process(Object object, EntityPersister persister) throws HibernateException {
        this.processValues(persister.getPropertyValues(object), persister.getPropertyTypes());
    }

    Object processCollection(Object collection, CollectionType type) throws HibernateException {
        return null;
    }

    Object processEntity(Object value, EntityType entityType) throws HibernateException {
        return null;
    }

    Object processQueryList(List value, QueryType type) throws HibernateException {
        return null;
    }

    final SessionEventSource getSession() {
        return this.session;
    }
}

