/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.event;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.CacheMode;
import org.hibernate.CallbackException;
import org.hibernate.HibernateException;
import org.hibernate.LockMode;
import org.hibernate.TransientObjectException;
import org.hibernate.action.EntityDeleteAction;
import org.hibernate.classic.Lifecycle;
import org.hibernate.engine.Cascades;
import org.hibernate.engine.EntityKey;
import org.hibernate.engine.ForeignKeys;
import org.hibernate.engine.Nullability;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.event.AbstractEventListener;
import org.hibernate.event.DeleteEvent;
import org.hibernate.event.DeleteEventListener;
import org.hibernate.event.OnUpdateVisitor;
import org.hibernate.event.SessionEventSource;
import org.hibernate.impl.EntityEntry;
import org.hibernate.impl.Status;
import org.hibernate.persister.EntityPersister;
import org.hibernate.pretty.MessageHelper;
import org.hibernate.type.Type;
import org.hibernate.type.TypeFactory;

public class DefaultDeleteEventListener
extends AbstractEventListener
implements DeleteEventListener {
    private static final Log log = LogFactory.getLog((Class)(class$org$hibernate$event$DefaultDeleteEventListener == null ? (class$org$hibernate$event$DefaultDeleteEventListener = DefaultDeleteEventListener.class$("org.hibernate.event.DefaultDeleteEventListener")) : class$org$hibernate$event$DefaultDeleteEventListener));
    static /* synthetic */ Class class$org$hibernate$event$DefaultDeleteEventListener;

    public void onDelete(DeleteEvent event) throws HibernateException {
        Object version;
        Serializable id;
        EntityPersister persister;
        Object entity;
        SessionEventSource source = event.getSource();
        EntityEntry entityEntry = source.getEntry(entity = source.unproxyAndReassociate(event.getObject()));
        if (entityEntry == null) {
            log.trace((Object)"deleting a transient instance");
            persister = source.getEntityPersister(event.getEntityName(), entity);
            id = persister.getIdentifier(entity);
            if (id == null) {
                throw new TransientObjectException("the transient instance passed to delete() had a null identifier");
            }
            source.checkUniqueness(id, persister, entity);
            new OnUpdateVisitor(source, id).process(entity, persister);
            version = persister.getVersion(entity);
            entityEntry = source.addEntity(entity, Status.MANAGED, persister.getPropertyValues(entity), id, version, LockMode.NONE, true, persister, false);
        } else {
            log.trace((Object)"deleting a persistent instance");
            if (entityEntry.getStatus() == Status.DELETED || entityEntry.getStatus() == Status.GONE) {
                log.trace((Object)"object was already deleted");
                return;
            }
            persister = entityEntry.getPersister();
            id = entityEntry.getId();
            version = entityEntry.getVersion();
        }
        if (!persister.isMutable()) {
            throw new HibernateException("attempted to delete an object of immutable class: " + MessageHelper.infoString((EntityPersister)persister));
        }
        this.deleteEntity(source, entity, entityEntry, event.isCascadeDeleteEnabled(), persister);
        if (source.getFactory().getSettings().isIdentifierRollbackEnabled()) {
            persister.resetIdentifier(entity, id, version);
        }
    }

    protected final void deleteEntity(SessionEventSource session, Object entity, EntityEntry entityEntry, boolean isCascadeDeleteEnabled, EntityPersister persister) throws HibernateException {
        if (log.isTraceEnabled()) {
            log.trace((Object)("deleting " + MessageHelper.infoString((EntityPersister)persister, (Serializable)entityEntry.getId())));
        }
        Type[] propTypes = persister.getPropertyTypes();
        Object version = entityEntry.getVersion();
        Object[] currentState = entityEntry.getLoadedState() == null ? persister.getPropertyValues(entity) : entityEntry.getLoadedState();
        Object[] deletedState = new Object[propTypes.length];
        TypeFactory.deepCopy((Object[])currentState, (Type[])propTypes, (boolean[])persister.getPropertyUpdateability(), (Object[])deletedState);
        entityEntry.setDeletedState(deletedState);
        session.getInterceptor().onDelete(entity, entityEntry.getId(), entityEntry.getDeletedState(), persister.getPropertyNames(), propTypes);
        session.setEntryStatus(entityEntry, Status.DELETED);
        EntityKey key = new EntityKey(entityEntry.getId(), persister);
        HashSet nullifiablesAfterOnDelete = null;
        if (persister.implementsLifecycle()) {
            HashSet oldNullifiables = (HashSet)session.getNullifiables().clone();
            ArrayList oldDeletions = (ArrayList)session.getActionQueue().cloneDeletions();
            session.getNullifiables().add(key);
            try {
                log.debug((Object)"calling onDelete()");
                if (((Lifecycle)entity).onDelete(session)) {
                    session.setEntryStatus(entityEntry, Status.MANAGED);
                    entityEntry.setDeletedState(null);
                    session.setNullifiables(oldNullifiables);
                    log.debug((Object)"deletion vetoed by onDelete()");
                    return;
                }
            }
            catch (CallbackException ce) {
                session.setEntryStatus(entityEntry, Status.MANAGED);
                entityEntry.setDeletedState(null);
                session.setNullifiables(oldNullifiables);
                throw ce;
            }
            if (oldDeletions.size() > session.getActionQueue().numberOfDeletions()) {
                throw new HibernateException("session was flushed during onDelete()");
            }
            session.getActionQueue().suspendDeletionsNewlyAddedDeletions(oldDeletions);
            nullifiablesAfterOnDelete = session.getNullifiables();
            session.setNullifiables(oldNullifiables);
        }
        this.cascadeBeforeDelete(session, persister, entity, entityEntry);
        ForeignKeys.nullifyTransientReferences((Object[])entityEntry.getDeletedState(), (Type[])propTypes, (boolean)false, (Object)entity, (SessionImplementor)session);
        Nullability.checkNullability((Object[])entityEntry.getDeletedState(), (EntityPersister)persister, (boolean)true, (SessionFactoryImplementor)session.getFactory());
        session.getNullifiables().add(key);
        session.getActionQueue().addAction(new EntityDeleteAction(entityEntry.getId(), version, entity, persister, isCascadeDeleteEnabled, (SessionImplementor)session));
        if (persister.implementsLifecycle()) {
            session.getNullifiables().addAll(nullifiablesAfterOnDelete);
            session.getActionQueue().resumeSuspendedDeletions();
        }
        this.cascadeAfterDelete(session, persister, entity);
        session.removeDatabaseSnapshot(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cascadeBeforeDelete(SessionEventSource session, EntityPersister persister, Object entity, EntityEntry entityEntry) throws HibernateException {
        CacheMode cacheMode = session.getCacheMode();
        session.setCacheMode(CacheMode.GET);
        session.incrementCascadeLevel();
        try {
            Cascades.cascade((SessionImplementor)session, (EntityPersister)persister, (Object)entity, (Cascades.CascadingAction)Cascades.ACTION_DELETE, (int)1);
        }
        finally {
            session.decrementCascadeLevel();
            session.setCacheMode(cacheMode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cascadeAfterDelete(SessionEventSource session, EntityPersister persister, Object entity) throws HibernateException {
        CacheMode cacheMode = session.getCacheMode();
        session.setCacheMode(CacheMode.GET);
        session.incrementCascadeLevel();
        try {
            Cascades.cascade((SessionImplementor)session, (EntityPersister)persister, (Object)entity, (Cascades.CascadingAction)Cascades.ACTION_DELETE, (int)2);
        }
        finally {
            session.decrementCascadeLevel();
            session.setCacheMode(cacheMode);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

