/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.event;

import java.io.Serializable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.HibernateException;
import org.hibernate.LockMode;
import org.hibernate.NonUniqueObjectException;
import org.hibernate.ObjectDeletedException;
import org.hibernate.ObjectNotFoundException;
import org.hibernate.PersistentObjectException;
import org.hibernate.cache.CacheConcurrencyStrategy;
import org.hibernate.cache.CacheKey;
import org.hibernate.engine.CacheEntry;
import org.hibernate.engine.EntityKey;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.engine.TwoPhaseLoad;
import org.hibernate.engine.Versioning;
import org.hibernate.event.AbstractLockUpgradeEventListener;
import org.hibernate.event.LoadEvent;
import org.hibernate.event.LoadEventListener;
import org.hibernate.event.PostLoadEvent;
import org.hibernate.event.SessionEventSource;
import org.hibernate.impl.EntityEntry;
import org.hibernate.impl.PersistenceContext;
import org.hibernate.impl.Status;
import org.hibernate.persister.EntityPersister;
import org.hibernate.pretty.MessageHelper;
import org.hibernate.type.Type;
import org.hibernate.type.TypeFactory;

public class DefaultLoadEventListener
extends AbstractLockUpgradeEventListener
implements LoadEventListener {
    private static final Log log = LogFactory.getLog((Class)(class$org$hibernate$event$DefaultLoadEventListener == null ? (class$org$hibernate$event$DefaultLoadEventListener = DefaultLoadEventListener.class$("org.hibernate.event.DefaultLoadEventListener")) : class$org$hibernate$event$DefaultLoadEventListener));
    public static final LockMode DEFAULT_LOCK_MODE = LockMode.NONE;
    static /* synthetic */ Class class$org$hibernate$event$DefaultLoadEventListener;

    public Object onLoad(LoadEvent event, LoadEventListener.LoadType loadType) throws HibernateException {
        EntityPersister persister;
        if (event.getInstanceToLoad() != null) {
            persister = event.getSource().getEntityPersister(null, event.getInstanceToLoad());
            event.setEntityClassName(event.getInstanceToLoad().getClass().getName());
        } else {
            persister = event.getSource().getFactory().getEntityPersister(event.getEntityClassName());
        }
        if (persister == null) {
            throw new HibernateException("Unable to locate persister");
        }
        EntityKey keyToLoad = new EntityKey(event.getEntityId(), persister);
        Options options = new Options();
        if (event.getInstanceToLoad() != null) {
            options.setAllowNulls(false);
            options.setAllowProxyCreation(false);
            options.setCheckDeleted(true);
            options.setImmediateLoad(false);
        } else if (loadType == LoadEventListener.GET) {
            options.setAllowNulls(true);
            options.setAllowProxyCreation(false);
            options.setCheckDeleted(true);
            options.setImmediateLoad(false);
        } else if (loadType == LoadEventListener.LOAD) {
            options.setAllowNulls(false);
            options.setAllowProxyCreation(true);
            options.setCheckDeleted(true);
            options.setImmediateLoad(false);
        } else if (loadType == LoadEventListener.IMMEDIATE_LOAD) {
            options.setAllowNulls(false);
            options.setAllowProxyCreation(false);
            options.setCheckDeleted(true);
            options.setImmediateLoad(true);
        } else if (loadType == LoadEventListener.INTERNAL_LOAD) {
            options.setAllowNulls(false);
            options.setAllowProxyCreation(true);
            options.setCheckDeleted(false);
            options.setImmediateLoad(false);
        } else if (loadType == LoadEventListener.INTERNAL_LOAD_ONE_TO_ONE) {
            options.setAllowNulls(false);
            options.setAllowProxyCreation(false);
            options.setCheckDeleted(false);
            options.setImmediateLoad(false);
        }
        try {
            if (options.isImmediateLoad()) {
                return this.load(event, persister, keyToLoad, options);
            }
            return event.getLockMode() == LockMode.NONE ? this.proxyOrLoad(event, persister, keyToLoad, options) : this.lockAndLoad(event, persister, keyToLoad, options, event.getSource());
        }
        catch (HibernateException e) {
            log.info((Object)"Error performing load command", (Throwable)e);
            throw e;
        }
    }

    protected Object load(LoadEvent event, EntityPersister persister, EntityKey keyToLoad, Options options) throws HibernateException {
        return this.load(event, persister, keyToLoad, options, null);
    }

    protected Object load(LoadEvent event, EntityPersister persister, EntityKey keyToLoad, Options options, Object result) throws HibernateException {
        if (event.getInstanceToLoad() != null) {
            if (event.getSource().getEntry(event.getInstanceToLoad()) != null) {
                throw new PersistentObjectException("attempted to load into an instance that was already associated with the session [class=" + event.getEntityClassName() + ", id=" + event.getEntityId() + "]");
            }
            persister.setIdentifier(event.getInstanceToLoad(), event.getEntityId());
        }
        Object entity = this.doLoad(event, persister, keyToLoad, options, result);
        if (event.getInstanceToLoad() != null) {
            ObjectNotFoundException.throwIfNull(entity, event.getEntityId(), event.getEntityClassName());
            if (entity != event.getInstanceToLoad()) {
                throw new NonUniqueObjectException(event.getEntityId(), event.getEntityClassName());
            }
        }
        return entity;
    }

    protected Object proxyOrLoad(LoadEvent event, EntityPersister persister, EntityKey keyToLoad, Options options) throws HibernateException {
        if (log.isTraceEnabled()) {
            log.trace((Object)("loading entity: " + MessageHelper.infoString(event.getEntityClassName(), event.getEntityId())));
        }
        if (!persister.hasProxy()) {
            return this.load(event, persister, keyToLoad, options);
        }
        SessionEventSource source = event.getSource();
        Object existing = source.getEntity(keyToLoad);
        if (existing != null) {
            log.trace((Object)"entity found in session cache");
            return source.proxyFor(persister, keyToLoad, this.load(event, persister, keyToLoad, options, existing));
        }
        Object proxy = source.getProxy(keyToLoad);
        if (proxy != null) {
            log.trace((Object)"entity proxy found in session cache");
            return source.narrowProxy(proxy, persister, keyToLoad, null);
        }
        if (options.isAllowProxyCreation()) {
            log.trace((Object)"creating new proxy for entity");
            proxy = persister.createProxy(event.getEntityId(), event.getSource());
            if (persister.isBatchLoadable()) {
                source.getBatchLoadableEntityKeys().put(keyToLoad, PersistenceContext.MARKER);
            }
            source.addProxy(keyToLoad, proxy);
            return proxy;
        }
        return this.load(event, persister, keyToLoad, options);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Object lockAndLoad(LoadEvent event, EntityPersister persister, EntityKey keyToLoad, Options options, SessionEventSource source) throws HibernateException {
        Object entity;
        block6: {
            CacheKey ck;
            CacheConcurrencyStrategy.SoftLock lock = null;
            if (persister.hasCache()) {
                ck = new CacheKey(event.getEntityId(), persister.getIdentifierType(), persister.getRootEntityName());
                lock = persister.getCache().lock(ck, null);
            } else {
                ck = null;
            }
            entity = null;
            try {
                entity = this.load(event, persister, keyToLoad, options);
                Object var10_9 = null;
                if (!persister.hasCache()) break block6;
            }
            catch (Throwable throwable) {
                Object var10_10 = null;
                if (persister.hasCache()) {
                    persister.getCache().release(ck, lock);
                }
                throw throwable;
            }
            persister.getCache().release(ck, lock);
        }
        if (!options.isAllowNulls()) {
            ObjectNotFoundException.throwIfNull(entity, event.getEntityId(), event.getEntityClassName());
        }
        return event.getSource().proxyFor(persister, keyToLoad, entity);
    }

    protected Object doLoad(LoadEvent event, EntityPersister persister, EntityKey keyToLoad, Options options, Object result) throws HibernateException {
        Object entity;
        if (log.isTraceEnabled()) {
            log.trace((Object)("attempting to resolve: " + MessageHelper.infoString(event.getEntityClassName(), event.getEntityId())));
        }
        if ((entity = this.loadFromSessionCache(event, keyToLoad, options, result)) != null) {
            if (log.isTraceEnabled()) {
                log.trace((Object)("resolved object in session cache: " + MessageHelper.infoString((EntityPersister)persister, (Serializable)event.getEntityId())));
            }
            return entity;
        }
        if (event.getSource().isNonExistant(keyToLoad)) {
            if (log.isTraceEnabled()) {
                log.trace((Object)"entity does not exist");
            }
            return null;
        }
        entity = this.loadFromSecondLevelCache(event, persister, options);
        if (entity != null) {
            if (log.isTraceEnabled()) {
                log.trace((Object)("resolved object in second-level cache: " + MessageHelper.infoString((EntityPersister)persister, (Serializable)event.getEntityId())));
            }
            return entity;
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("object not resolved in any cache: " + MessageHelper.infoString((EntityPersister)persister, (Serializable)event.getEntityId())));
        }
        return this.loadFromDatasource(event, persister, keyToLoad, options);
    }

    protected Object loadFromDatasource(LoadEvent event, EntityPersister persister, EntityKey keyToLoad, Options options) throws HibernateException {
        SessionEventSource source = event.getSource();
        Object entity = persister.load(event.getEntityId(), event.getInstanceToLoad(), event.getLockMode(), source);
        if (entity == null) {
            source.addNonExist(keyToLoad);
        }
        if (event.isAssociationFetch() && source.getFactory().getStatistics().isStatisticsEnabled()) {
            source.getFactory().getStatisticsImplementor().fetchEntity(event.getEntityClassName());
        }
        return entity;
    }

    protected Object loadFromSessionCache(LoadEvent event, EntityKey keyToLoad, Options options, Object result) throws HibernateException {
        Object old;
        Object object = old = result == null ? event.getSource().getEntity(keyToLoad) : result;
        if (old != null) {
            EntityEntry oldEntry = event.getSource().getEntry(old);
            Status status = oldEntry.getStatus();
            if (options.isCheckDeleted() && (status == Status.DELETED || status == Status.GONE)) {
                throw new ObjectDeletedException("The object with that id was deleted", event.getEntityId(), event.getEntityClassName());
            }
            this.upgradeLock(old, oldEntry, event.getLockMode(), event.getSource());
        }
        return old;
    }

    protected Object loadFromSecondLevelCache(LoadEvent event, EntityPersister persister, Options options) throws HibernateException {
        boolean useCache;
        SessionEventSource source = event.getSource();
        boolean bl = useCache = persister.hasCache() && source.getCacheMode().isGetEnabled() && event.getLockMode().lessThan(LockMode.READ);
        if (useCache) {
            SessionFactoryImplementor factory = source.getFactory();
            CacheKey ck = new CacheKey(event.getEntityId(), persister.getIdentifierType(), persister.getRootEntityName());
            Object ce = persister.getCache().get(ck, source.getTimestamp());
            if (factory.getStatistics().isStatisticsEnabled()) {
                if (ce == null) {
                    factory.getStatisticsImplementor().secondLevelCacheMiss(persister.getCache().getRegionName());
                } else {
                    factory.getStatisticsImplementor().secondLevelCacheHit(persister.getCache().getRegionName());
                }
            }
            if (ce != null) {
                CacheEntry entry = (CacheEntry)persister.getCacheEntryStructure().destructure(ce, factory);
                return this.assembleCacheEntry(entry, event.getEntityId(), persister, event);
            }
        }
        return null;
    }

    private Object assembleCacheEntry(CacheEntry entry, Serializable id, EntityPersister persister, LoadEvent event) throws HibernateException {
        Object optionalObject = event.getInstanceToLoad();
        SessionEventSource session = event.getSource();
        if (log.isTraceEnabled()) {
            log.trace((Object)("resolved object in second-level cache: " + MessageHelper.infoString((EntityPersister)persister, (Serializable)id)));
        }
        EntityPersister subclassPersister = session.getFactory().getEntityPersister(entry.getSubclass());
        Object result = optionalObject == null ? session.instantiate(subclassPersister, id) : optionalObject;
        TwoPhaseLoad.addUninitializedEntity((Serializable)id, (Object)result, (EntityPersister)subclassPersister, (LockMode)LockMode.NONE, (SessionImplementor)session);
        Type[] types = subclassPersister.getPropertyTypes();
        Object[] values = entry.assemble(result, id, subclassPersister, session.getInterceptor(), session);
        TypeFactory.deepCopy((Object[])values, (Type[])types, (boolean[])subclassPersister.getPropertyUpdateability(), (Object[])values);
        Object version = Versioning.getVersion((Object[])values, (EntityPersister)subclassPersister);
        if (log.isTraceEnabled()) {
            log.trace((Object)("Cached Version: " + version));
        }
        session.addEntry(result, Status.MANAGED, values, null, id, version, LockMode.NONE, true, subclassPersister, false);
        subclassPersister.afterInitialize(result, entry.areLazyPropertiesUnfetched(), session);
        session.initializeNonLazyCollections();
        PostLoadEvent postLoadEvent = new PostLoadEvent(result, id, persister, session);
        session.getListeners().getPostLoadEventListener().onPostLoad(postLoadEvent);
        return result;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static final class Options {
        private boolean immediateLoad;
        private boolean allowNulls;
        private boolean checkDeleted;
        private boolean allowProxyCreation;

        private Options() {
        }

        public boolean isAllowNulls() {
            return this.allowNulls;
        }

        public void setAllowNulls(boolean allowNulls) {
            this.allowNulls = allowNulls;
        }

        public boolean isImmediateLoad() {
            return this.immediateLoad;
        }

        public void setImmediateLoad(boolean immediateLoad) {
            this.immediateLoad = immediateLoad;
        }

        public boolean isCheckDeleted() {
            return this.checkDeleted;
        }

        public void setCheckDeleted(boolean checkDeleted) {
            this.checkDeleted = checkDeleted;
        }

        public boolean isAllowProxyCreation() {
            return this.allowProxyCreation;
        }

        public void setAllowProxyCreation(boolean allowProxyCreation) {
            this.allowProxyCreation = allowProxyCreation;
        }
    }
}

