/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.event;

import java.io.Serializable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.HibernateException;
import org.hibernate.PersistentObjectException;
import org.hibernate.UnresolvableObjectException;
import org.hibernate.cache.CacheKey;
import org.hibernate.engine.Cascades;
import org.hibernate.engine.EntityKey;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.event.AbstractEventListener;
import org.hibernate.event.EvictVisitor;
import org.hibernate.event.RefreshEvent;
import org.hibernate.event.RefreshEventListener;
import org.hibernate.event.SessionEventSource;
import org.hibernate.impl.EntityEntry;
import org.hibernate.persister.EntityPersister;
import org.hibernate.pretty.MessageHelper;
import org.hibernate.type.AbstractComponentType;
import org.hibernate.type.CollectionType;
import org.hibernate.type.Type;

public class DefaultRefreshEventListener
extends AbstractEventListener
implements RefreshEventListener {
    private static final Log log = LogFactory.getLog((Class)(class$org$hibernate$event$DefaultRefreshEventListener == null ? (class$org$hibernate$event$DefaultRefreshEventListener = DefaultRefreshEventListener.class$("org.hibernate.event.DefaultRefreshEventListener")) : class$org$hibernate$event$DefaultRefreshEventListener));
    static /* synthetic */ Class class$org$hibernate$event$DefaultRefreshEventListener;

    public void onRefresh(RefreshEvent event) throws HibernateException {
        Serializable id;
        EntityPersister persister;
        SessionEventSource source = event.getSource();
        if (source.reassociateIfUninitializedProxy(event.getObject())) {
            return;
        }
        Object object = source.unproxyAndReassociate(event.getObject());
        EntityEntry e = source.removeEntry(object);
        if (e == null) {
            persister = source.getEntityPersister(null, object);
            id = persister.getIdentifier(object);
            if (log.isTraceEnabled()) {
                log.trace((Object)("refreshing transient " + MessageHelper.infoString((EntityPersister)persister, (Serializable)id)));
            }
            if (source.getEntry(new EntityKey(id, persister)) != null) {
                throw new PersistentObjectException("attempted to refresh transient instance when persistent instance was already associated with the Session: " + MessageHelper.infoString((EntityPersister)persister, (Serializable)id));
            }
        } else {
            if (log.isTraceEnabled()) {
                log.trace((Object)("refreshing " + MessageHelper.infoString((EntityPersister)e.getPersister(), (Serializable)e.getId())));
            }
            if (!e.isExistsInDatabase()) {
                throw new HibernateException("this instance does not yet exist as a row in the database");
            }
            persister = e.getPersister();
            id = e.getId();
            EntityKey key = new EntityKey(id, persister);
            source.removeEntity(key);
            if (persister.hasCollections()) {
                new EvictVisitor(source).process(object, persister);
            }
        }
        if (persister.hasCache()) {
            CacheKey ck = new CacheKey(id, persister.getIdentifierType(), persister.getRootEntityName());
            persister.getCache().remove(ck);
        }
        this.evictCachedCollections(persister, id, source.getFactory());
        Object result = persister.load(id, object, event.getLockMode(), source);
        UnresolvableObjectException.throwIfNull(result, id, persister.getEntityName());
        Cascades.cascade((SessionImplementor)source, (EntityPersister)persister, (Object)object, (Cascades.CascadingAction)Cascades.ACTION_REFRESH, (int)0);
    }

    private void evictCachedCollections(EntityPersister persister, Serializable id, SessionFactoryImplementor factory) throws HibernateException {
        this.evictCachedCollections(persister.getPropertyTypes(), id, factory);
    }

    private void evictCachedCollections(Type[] types, Serializable id, SessionFactoryImplementor factory) throws HibernateException {
        for (int i = 0; i < types.length; ++i) {
            if (types[i].isPersistentCollectionType()) {
                factory.evictCollection(((CollectionType)types[i]).getRole(), id);
                continue;
            }
            if (!types[i].isComponentType()) continue;
            AbstractComponentType actype = (AbstractComponentType)types[i];
            this.evictCachedCollections(actype.getSubtypes(), id, factory);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

