/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.event;

import org.hibernate.HibernateException;
import org.hibernate.collection.PersistentCollection;
import org.hibernate.event.AbstractVisitor;
import org.hibernate.event.SessionEventSource;
import org.hibernate.type.CollectionType;

public class DirtyCollectionSearchVisitor
extends AbstractVisitor {
    private boolean dirty = false;
    private boolean[] propertyVersionability;

    DirtyCollectionSearchVisitor(SessionEventSource session, boolean[] propertyVersionability) {
        super(session);
        this.propertyVersionability = propertyVersionability;
    }

    boolean wasDirtyCollectionFound() {
        return this.dirty;
    }

    Object processCollection(Object collection, CollectionType type) throws HibernateException {
        PersistentCollection coll;
        SessionEventSource session;
        if (collection != null && (session = this.getSession()).getCollectionEntry(coll = type.isArrayType() ? session.getArrayHolder(collection) : (PersistentCollection)collection).isInitializedAndDirty()) {
            this.dirty = true;
            return null;
        }
        return null;
    }

    boolean includeProperty(Object[] values, int i) {
        return this.propertyVersionability[i] && super.includeProperty(values, i);
    }
}

