/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.event;

import java.io.Serializable;
import org.hibernate.HibernateException;
import org.hibernate.collection.CollectionPersister;
import org.hibernate.collection.PersistentCollection;
import org.hibernate.engine.CollectionSnapshot;
import org.hibernate.event.ReattachVisitor;
import org.hibernate.event.SessionEventSource;
import org.hibernate.type.CollectionType;

public class OnUpdateVisitor
extends ReattachVisitor {
    OnUpdateVisitor(SessionEventSource session, Serializable key) {
        super(session, key);
    }

    Object processCollection(Object collection, CollectionType type) throws HibernateException {
        SessionEventSource session = this.getSession();
        Serializable key = this.getKey();
        CollectionPersister persister = session.getCollectionPersister(type.getRole());
        if (collection != null && collection instanceof PersistentCollection) {
            PersistentCollection wrapper = (PersistentCollection)collection;
            if (wrapper.setCurrentSession(session)) {
                CollectionSnapshot snapshot = wrapper.getCollectionSnapshot();
                if (!OnUpdateVisitor.isOwnerUnchanged(snapshot, persister, key)) {
                    session.removeCollection(persister, key);
                }
                this.reattachCollection(wrapper, snapshot);
            } else {
                session.removeCollection(persister, key);
            }
        } else {
            session.removeCollection(persister, key);
        }
        return null;
    }
}

