/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.event;

import java.io.Serializable;
import org.hibernate.HibernateException;
import org.hibernate.collection.CollectionPersister;
import org.hibernate.collection.PersistentCollection;
import org.hibernate.engine.CollectionSnapshot;
import org.hibernate.event.AbstractVisitor;
import org.hibernate.event.SessionEventSource;
import org.hibernate.type.EntityType;

public abstract class ProxyVisitor
extends AbstractVisitor {
    public ProxyVisitor(SessionEventSource session) {
        super(session);
    }

    Object processEntity(Object value, EntityType entityType) throws HibernateException {
        if (value != null) {
            this.getSession().reassociateIfUninitializedProxy(value);
        }
        return null;
    }

    protected static boolean isOwnerUnchanged(CollectionSnapshot snapshot, CollectionPersister persister, Serializable id) {
        return ProxyVisitor.isCollectionSnapshotValid(snapshot) && persister.getRole().equals(snapshot.getRole()) && id.equals(snapshot.getKey());
    }

    private static boolean isCollectionSnapshotValid(CollectionSnapshot snapshot) {
        return snapshot != null && snapshot.getRole() != null && snapshot.getKey() != null;
    }

    protected void reattachCollection(PersistentCollection collection, CollectionSnapshot snapshot) throws HibernateException {
        if (collection.wasInitialized()) {
            this.getSession().addInitializedDetachedCollection(collection, snapshot);
        } else {
            if (!ProxyVisitor.isCollectionSnapshotValid(snapshot)) {
                throw new HibernateException("could not reassociate uninitialized transient collection");
            }
            this.getSession().addUninitializedDetachedCollection(collection, this.getSession().getCollectionPersister(snapshot.getRole()), snapshot.getKey());
        }
    }
}

