/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.event;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.HibernateException;
import org.hibernate.collection.CollectionPersister;
import org.hibernate.collection.PersistentArrayHolder;
import org.hibernate.collection.PersistentCollection;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.event.ProxyVisitor;
import org.hibernate.event.SessionEventSource;
import org.hibernate.persister.EntityPersister;
import org.hibernate.type.AbstractComponentType;
import org.hibernate.type.CollectionType;
import org.hibernate.type.Type;

public class WrapVisitor
extends ProxyVisitor {
    private static final Log log = LogFactory.getLog((Class)(class$org$hibernate$event$WrapVisitor == null ? (class$org$hibernate$event$WrapVisitor = WrapVisitor.class$("org.hibernate.event.WrapVisitor")) : class$org$hibernate$event$WrapVisitor));
    boolean substitute = false;
    static /* synthetic */ Class class$org$hibernate$event$WrapVisitor;

    boolean isSubstitutionRequired() {
        return this.substitute;
    }

    WrapVisitor(SessionEventSource session) {
        super(session);
    }

    Object processCollection(Object collection, CollectionType collectionType) throws HibernateException {
        if (collection != null && collection instanceof PersistentCollection) {
            PersistentCollection coll = (PersistentCollection)collection;
            SessionEventSource session = this.getSession();
            if (coll.setCurrentSession(session)) {
                this.reattachCollection(coll, coll.getCollectionSnapshot());
            }
            return null;
        }
        return this.processArrayOrNewCollection(collection, collectionType);
    }

    final Object processArrayOrNewCollection(Object collection, CollectionType collectionType) throws HibernateException {
        SessionEventSource session = this.getSession();
        if (collection == null) {
            return null;
        }
        CollectionPersister persister = session.getCollectionPersister(collectionType.getRole());
        if (collectionType.isArrayType()) {
            PersistentArrayHolder ah = session.getArrayHolder(collection);
            if (ah == null) {
                ah = new PersistentArrayHolder((SessionImplementor)session, collection);
                session.addNewCollection(ah, persister);
                session.addArrayHolder(ah);
            }
            return null;
        }
        PersistentCollection persistentCollection = collectionType.wrap(session, collection);
        session.addNewCollection(persistentCollection, persister);
        if (log.isTraceEnabled()) {
            log.trace((Object)("Wrapped collection in role: " + collectionType.getRole()));
        }
        return persistentCollection;
    }

    void processValues(Object[] values, Type[] types) throws HibernateException {
        for (int i = 0; i < types.length; ++i) {
            Object result;
            if (!this.includeProperty(values, i) || (result = this.processValue(values[i], types[i])) == null) continue;
            this.substitute = true;
            values[i] = result;
        }
    }

    Object processComponent(Object component, AbstractComponentType componentType) throws HibernateException {
        if (component != null) {
            Object[] values = componentType.getPropertyValues(component, this.getSession());
            Type[] types = componentType.getSubtypes();
            boolean substituteComponent = false;
            for (int i = 0; i < types.length; ++i) {
                Object result = this.processValue(values[i], types[i]);
                if (result == null) continue;
                values[i] = result;
                substituteComponent = true;
            }
            if (substituteComponent) {
                componentType.setPropertyValues(component, values);
            }
        }
        return null;
    }

    void process(Object object, EntityPersister persister) throws HibernateException {
        Object[] values = persister.getPropertyValues(object);
        Type[] types = persister.getPropertyTypes();
        this.processValues(values, types);
        if (this.isSubstitutionRequired()) {
            persister.setPropertyValues(object, values);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

