/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.event.def;

import java.io.Serializable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.HibernateException;
import org.hibernate.LockMode;
import org.hibernate.engine.EntityEntry;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.engine.Status;
import org.hibernate.engine.Versioning;
import org.hibernate.event.AbstractEvent;
import org.hibernate.event.def.AbstractEventListener;
import org.hibernate.event.def.OnLockVisitor;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.pretty.MessageHelper;
import org.hibernate.type.TypeFactory;

public class AbstractReassociateEventListener
extends AbstractEventListener {
    private static final Log log;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.hibernate.event.def.AbstractReassociateEventListener");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LogFactory.getLog((Class)clazz);
    }

    protected final EntityEntry reassociate(AbstractEvent event, Object object, Serializable id, EntityPersister persister) throws HibernateException {
        if (log.isTraceEnabled()) {
            log.trace((Object)("reassociating transient instance: " + MessageHelper.infoString(persister, id, event.getSession().getFactory())));
        }
        SessionImplementor source = event.getSession();
        source.getPersistenceContext().checkUniqueness(id, persister, object);
        Object[] values = persister.getPropertyValues(object, source.getEntityMode());
        TypeFactory.deepCopy(values, persister.getPropertyTypes(), persister.getPropertyUpdateability(), values, source);
        Object version = Versioning.getVersion(values, persister);
        EntityEntry newEntry = source.getPersistenceContext().addEntity(object, Status.MANAGED, values, id, version, LockMode.NONE, true, persister, false);
        new OnLockVisitor(source, id).process(object, persister);
        persister.afterReassociate(object, source);
        return newEntry;
    }
}

