/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.event.def;

import java.io.Serializable;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.HibernateException;
import org.hibernate.action.CollectionRemoveAction;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.event.def.ProxyVisitor;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.pretty.MessageHelper;
import org.hibernate.type.AbstractComponentType;
import org.hibernate.type.QueryType;
import org.hibernate.type.Type;

public abstract class ReattachVisitor
extends ProxyVisitor {
    private static final Log log;
    private final Serializable key;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.hibernate.event.def.ReattachVisitor");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LogFactory.getLog((Class)clazz);
    }

    final Serializable getKey() {
        return this.key;
    }

    public ReattachVisitor(SessionImplementor session, Serializable key) {
        super(session);
        this.key = key;
    }

    Object processComponent(Object component, AbstractComponentType componentType) throws HibernateException {
        Type[] types = componentType.getSubtypes();
        if (component == null) {
            this.processValues(new Object[types.length], types);
        } else {
            super.processComponent(component, componentType);
        }
        return null;
    }

    Object processQueryList(List value, QueryType type) throws HibernateException {
        if (value != null && value instanceof QueryType.ListProxy) {
            ((QueryType.ListProxy)value).setSession(this.getSession());
        }
        return null;
    }

    public void removeCollection(CollectionPersister role, Serializable id, SessionImplementor source) throws HibernateException {
        if (log.isTraceEnabled()) {
            log.trace((Object)("collection dereferenced while transient " + MessageHelper.collectionInfoString(role, id, source.getFactory())));
        }
        source.getActionQueue().addAction(new CollectionRemoveAction(role, id, false, source));
    }
}

