/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.exception;

import java.lang.reflect.Constructor;
import java.sql.SQLException;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.HibernateException;
import org.hibernate.JDBCException;
import org.hibernate.dialect.Dialect;
import org.hibernate.exception.Configurable;
import org.hibernate.exception.GenericJDBCException;
import org.hibernate.exception.SQLExceptionConverter;
import org.hibernate.exception.ViolatedConstraintNameExtracter;
import org.hibernate.util.ReflectHelper;
import org.hibernate.util.StringHelper;

public class SQLExceptionConverterFactory {
    private static final Log log = LogFactory.getLog((Class)(class$org$hibernate$exception$SQLExceptionConverterFactory == null ? (class$org$hibernate$exception$SQLExceptionConverterFactory = SQLExceptionConverterFactory.class$("org.hibernate.exception.SQLExceptionConverterFactory")) : class$org$hibernate$exception$SQLExceptionConverterFactory));
    static /* synthetic */ Class class$org$hibernate$exception$SQLExceptionConverterFactory;
    static /* synthetic */ Class class$org$hibernate$exception$ViolatedConstraintNameExtracter;

    private SQLExceptionConverterFactory() {
    }

    public static SQLExceptionConverter buildSQLExceptionConverter(Dialect dialect, Properties properties) throws HibernateException {
        SQLExceptionConverter converter = null;
        String converterClassName = (String)properties.get("hibernate.sql_exception_converter");
        if (StringHelper.isNotEmpty(converterClassName)) {
            converter = SQLExceptionConverterFactory.constructConverter(converterClassName, dialect.getViolatedConstraintNameExtracter());
        }
        if (converter == null) {
            log.trace((Object)"Using dialect defined converter");
            converter = dialect.buildSQLExceptionConverter();
        }
        if (converter instanceof Configurable) {
            try {
                ((Configurable)((Object)converter)).configure(properties);
            }
            catch (HibernateException e) {
                log.warn((Object)"Unable to configure SQLExceptionConverter", (Throwable)e);
                throw e;
            }
        }
        return converter;
    }

    public static SQLExceptionConverter buildMinimalSQLExceptionConverter() {
        return new SQLExceptionConverter(){

            public JDBCException convert(SQLException sqlException, String message, String sql) {
                return new GenericJDBCException(message, sqlException, sql);
            }
        };
    }

    private static SQLExceptionConverter constructConverter(String converterClassName, ViolatedConstraintNameExtracter violatedConstraintNameExtracter) {
        try {
            log.trace((Object)("Attempting to construct instance of specified SQLExceptionConverter [" + converterClassName + "]"));
            Class converterClass = ReflectHelper.classForName(converterClassName);
            Constructor<?>[] ctors = converterClass.getDeclaredConstructors();
            for (int i = 0; i < ctors.length; ++i) {
                if (ctors[i].getParameterTypes() == null || ctors[i].getParameterTypes().length != 1 || !(class$org$hibernate$exception$ViolatedConstraintNameExtracter == null ? SQLExceptionConverterFactory.class$("org.hibernate.exception.ViolatedConstraintNameExtracter") : class$org$hibernate$exception$ViolatedConstraintNameExtracter).isAssignableFrom(ctors[i].getParameterTypes()[0])) continue;
                try {
                    return (SQLExceptionConverter)ctors[i].newInstance(violatedConstraintNameExtracter);
                }
                catch (Throwable t) {
                    // empty catch block
                }
            }
            return (SQLExceptionConverter)converterClass.newInstance();
        }
        catch (Throwable t) {
            log.warn((Object)"Unable to construct instance of specified SQLExceptionConverter", t);
            return null;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

