/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.hql.ast;

import antlr.SemanticException;
import antlr.collections.AST;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.hql.antlr.HqlSqlTokenTypes;
import org.hibernate.hql.ast.ASTIterator;
import org.hibernate.hql.ast.ASTUtil;
import org.hibernate.hql.ast.DisplayableNode;
import org.hibernate.hql.ast.FromElement;
import org.hibernate.hql.ast.FromElementFactory;
import org.hibernate.hql.ast.HqlSqlWalkerNode;

class FromClause
extends HqlSqlWalkerNode
implements HqlSqlTokenTypes,
DisplayableNode {
    private static Log log;
    private Set fromElements = new HashSet();
    private Map fromElementByClassAlias = new HashMap();
    private Map fromElementByTableAlias = new HashMap();
    private Map fromElementsByPath = new HashMap();
    private Map collectionJoinFromElementsByPath = new HashMap();
    private FromClause parentFromClause;
    private int fromElementCounter = 0;
    private List impliedElements = new LinkedList();
    private static ASTUtil.FilterPredicate fromElementPredicate;
    private static ASTUtil.FilterPredicate projectionListPredicate;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.hibernate.hql.ast.FromClause");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LogFactory.getLog((Class)clazz);
        fromElementPredicate = new ASTUtil.IncludePredicate(){

            public boolean include(AST node) {
                FromElement fromElement = (FromElement)node;
                return fromElement.isFromOrJoinFragment();
            }
        };
        projectionListPredicate = new ASTUtil.IncludePredicate(){

            public boolean include(AST node) {
                FromElement fromElement = (FromElement)node;
                return fromElement.inProjectionList();
            }
        };
    }

    FromClause() {
    }

    FromElement addFromElement(String path, AST alias) throws SemanticException {
        String classAlias = alias == null ? null : alias.getText();
        this.checkForDuplicateClassAlias(classAlias);
        FromElementFactory factory = new FromElementFactory(this, null, path, classAlias, null, false);
        return factory.addFromElement();
    }

    void registerFromElement(FromElement element) {
        this.fromElements.add(element);
        String classAlias = element.getClassAlias();
        if (classAlias != null) {
            this.fromElementByClassAlias.put(classAlias, element);
        }
        String className = element.getClassName();
        String tableAlias = element.getTableAlias();
        if (tableAlias != null) {
            this.fromElementByTableAlias.put(tableAlias, element);
        }
    }

    void addDuplicateAlias(String alias, FromElement element) {
        this.fromElementByClassAlias.put(alias, element);
    }

    private void checkForDuplicateClassAlias(String classAlias) throws SemanticException {
        if (classAlias != null && this.fromElementByClassAlias.containsKey(classAlias)) {
            throw new SemanticException("Duplicate definition of alias '" + classAlias + "'");
        }
    }

    public FromElement getFromElement(String aliasOrClassName) {
        FromElement fromElement = (FromElement)this.fromElementByClassAlias.get(aliasOrClassName);
        if (fromElement == null && this.parentFromClause != null) {
            fromElement = this.parentFromClause.getFromElement(aliasOrClassName);
        }
        return fromElement;
    }

    public List getFromElements() {
        return ASTUtil.collectChildren((AST)this, fromElementPredicate);
    }

    public List getProjectionList() {
        return ASTUtil.collectChildren((AST)this, projectionListPredicate);
    }

    FromElement findCollectionJoin(String path) {
        return (FromElement)this.collectionJoinFromElementsByPath.get(path);
    }

    FromElement findJoinByPath(String path) {
        Map joinsByPath = this.fromElementsByPath;
        FromElement elem = (FromElement)joinsByPath.get(path);
        return elem;
    }

    void addJoinByPathMap(String path, FromElement destination) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("addJoinByPathMap() : " + path + " -> " + destination));
        }
        this.fromElementsByPath.put(path, destination);
    }

    public boolean containsClassAlias(String alias) {
        return this.fromElementByClassAlias.keySet().contains(alias);
    }

    public boolean containsTableAlias(String alias) {
        return this.fromElementByTableAlias.keySet().contains(alias);
    }

    public String getDisplayText() {
        return "FromClause{" + super.toString() + "}";
    }

    public void setParentFromClause(FromClause parentFromClause) {
        this.parentFromClause = parentFromClause;
    }

    public boolean isSubQuery() {
        return this.parentFromClause != null;
    }

    void addCollectionJoinFromElementByPath(String path, FromElement destination) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("addCollectionJoinFromElementByPath() : " + path + " -> " + destination));
        }
        this.collectionJoinFromElementsByPath.put(path, destination);
    }

    public FromClause getParentFromClause() {
        return this.parentFromClause;
    }

    public int nextFromElementCounter() {
        return this.fromElementCounter++;
    }

    void resolve() {
        ASTIterator iter = new ASTIterator((AST)this);
        HashSet<Object> childrenInTree = new HashSet<Object>();
        while (iter.hasNext()) {
            childrenInTree.add(iter.next());
        }
        Iterator iterator = this.fromElements.iterator();
        while (iterator.hasNext()) {
            FromElement fromElement = (FromElement)iterator.next();
            if (childrenInTree.contains(fromElement)) continue;
            log.error((Object)("Element not in AST: " + fromElement));
        }
    }

    public void addImpliedFromElement(FromElement element) {
        this.impliedElements.add(element);
    }
}

