/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.hql.ast;

import antlr.SemanticException;
import antlr.collections.AST;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.MappingException;
import org.hibernate.QueryException;
import org.hibernate.hql.antlr.HqlSqlTokenTypes;
import org.hibernate.hql.ast.ASTUtil;
import org.hibernate.hql.ast.DotNode;
import org.hibernate.hql.ast.FromClause;
import org.hibernate.hql.ast.HqlSqlWalker;
import org.hibernate.hql.ast.IdentNode;
import org.hibernate.hql.ast.InvalidPathException;
import org.hibernate.persister.entity.Queryable;
import org.hibernate.sql.InFragment;
import org.hibernate.type.LiteralType;
import org.hibernate.type.Type;
import org.hibernate.type.TypeFactory;
import org.hibernate.util.ReflectHelper;

class LiteralProcessor
implements HqlSqlTokenTypes {
    private static final Log log;
    private HqlSqlWalker walker;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.hibernate.hql.ast.LiteralProcessor");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LogFactory.getLog((Class)clazz);
    }

    public LiteralProcessor(HqlSqlWalker hqlSqlWalker) {
        this.walker = hqlSqlWalker;
    }

    boolean isAlias(String alias) {
        FromClause from = this.walker.getCurrentFromClause();
        while (from.isSubQuery()) {
            if (from.containsClassAlias(alias)) {
                return true;
            }
            from = from.getParentFromClause();
        }
        return from.containsClassAlias(alias);
    }

    void processConstant(AST constant) throws SemanticException {
        boolean isIdent;
        boolean bl = isIdent = constant.getType() == 109 || constant.getType() == 80;
        if (isIdent && this.isAlias(constant.getText())) {
            IdentNode ident = (IdentNode)constant;
            ident.resolve(false, true);
        } else {
            Queryable queryable = this.walker.getSessionFactoryHelper().findQueryableUsingImports(constant.getText());
            if (isIdent && queryable != null) {
                constant.setText(queryable.getDiscriminatorSQLValue().toString());
            } else {
                this.processLiteral(constant);
            }
        }
    }

    public void lookupConstant(DotNode node) throws SemanticException {
        String text = this.getText((AST)node);
        Queryable persister = this.walker.getSessionFactoryHelper().findQueryableUsingImports(text);
        if (persister != null) {
            Object discrim = persister.getDiscriminatorSQLValue();
            if (InFragment.NULL == discrim || InFragment.NOT_NULL == discrim) {
                throw new InvalidPathException("subclass test not allowed for null or not null discriminator: '" + text + "'");
            }
            this.setConstantValue(node, text, discrim.toString());
        } else {
            Object value = ReflectHelper.getConstantValue(text);
            if (value == null) {
                throw new InvalidPathException("Invalid path: '" + text + "'");
            }
            this.setConstantValue(node, text, value);
        }
    }

    private void setConstantValue(DotNode node, String text, Object value) {
        Type type;
        if (log.isDebugEnabled()) {
            log.debug((Object)("setConstantValue() " + text + " -> " + value + " " + value.getClass().getName()));
        }
        node.setFirstChild(null);
        if (value instanceof String) {
            node.setType(108);
        } else if (value instanceof Integer) {
            node.setType(107);
        } else if (value instanceof Long) {
            node.setType(84);
        } else if (value instanceof Double) {
            node.setType(82);
        } else if (value instanceof Float) {
            node.setType(83);
        } else {
            node.setType(81);
        }
        try {
            type = TypeFactory.heuristicType(value.getClass().getName());
        }
        catch (MappingException me) {
            throw new QueryException(me);
        }
        if (type == null) {
            throw new QueryException("Could not determine type of: " + node.getText());
        }
        try {
            LiteralType literalType = (LiteralType)((Object)type);
            node.setText(literalType.objectToSQLString(value));
        }
        catch (Exception e) {
            throw new QueryException("Could not format constant value to SQL literal: " + node.getText(), e);
        }
        node.setDataType(type);
        node.setResolvedConstant(text);
    }

    private String getText(AST node) {
        return ASTUtil.getPathText(node);
    }

    public void processBoolean(AST constant) {
        String replacement = (String)this.walker.getTokenReplacements().get(constant.getText());
        if (replacement != null) {
            constant.setText(replacement);
        }
    }

    private void processLiteral(AST constant) {
        String replacement = (String)this.walker.getTokenReplacements().get(constant.getText());
        if (replacement != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("processConstant() : Replacing '" + constant.getText() + "' with '" + replacement + "'"));
            }
            constant.setText(replacement);
        }
    }
}

