/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.hql.ast;

import antlr.SemanticException;
import antlr.collections.AST;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.hql.ast.ASTAppender;
import org.hibernate.hql.ast.ASTIterator;
import org.hibernate.hql.ast.ASTPrinter;
import org.hibernate.hql.ast.ConstructorNode;
import org.hibernate.hql.ast.FromClause;
import org.hibernate.hql.ast.FromElement;
import org.hibernate.hql.ast.SelectExpression;
import org.hibernate.hql.ast.SelectExpressionImpl;
import org.hibernate.hql.ast.SelectExpressionList;
import org.hibernate.type.Type;

public class SelectClause
extends SelectExpressionList {
    private static final Log log;
    private boolean prepared = false;
    private boolean scalarSelect;
    private List fromElementsForLoad = new ArrayList();
    private Type[] queryReturnTypes;
    private String[][] columnNames;
    private ConstructorNode constructorNode;
    private FromElement collectionFromElement;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.hibernate.hql.ast.SelectClause");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LogFactory.getLog((Class)clazz);
    }

    public boolean isScalarSelect() {
        return this.scalarSelect;
    }

    public List getFromElementsForLoad() {
        return this.fromElementsForLoad;
    }

    public Type[] getQueryReturnTypes() {
        return this.queryReturnTypes;
    }

    public String[][] getColumnNames() {
        return this.columnNames;
    }

    public Constructor getConstructor() {
        return this.constructorNode == null ? null : this.constructorNode.getConstructor();
    }

    void initializeExplicitSelectClause(FromClause fromClause) throws SemanticException {
        if (this.prepared) {
            throw new IllegalStateException("SelectClause was already prepared!");
        }
        ArrayList<Type> queryReturnTypeList = new ArrayList<Type>();
        SelectExpression[] selectExpressions = this.collectSelectExpressions();
        int i = 0;
        while (i < selectExpressions.length) {
            SelectExpression expr = selectExpressions[i];
            if (expr.isConstructor()) {
                this.constructorNode = (ConstructorNode)expr;
                List constructorArgumentTypeList = this.constructorNode.getConstructorArgumentTypeList();
                queryReturnTypeList.addAll(constructorArgumentTypeList);
                this.scalarSelect = true;
            } else {
                Type type = expr.getDataType();
                if (type == null) {
                    StringBuffer stringBuffer = new StringBuffer("No data type for node: ").append(expr.getClass().getName()).append(" ");
                    Class<?> clazz = class$1;
                    if (clazz == null) {
                        try {
                            clazz = class$1 = Class.forName("org.hibernate.hql.antlr.SqlTokenTypes");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    throw new IllegalStateException(stringBuffer.append(new ASTPrinter(clazz).showAsString((AST)expr, "")).toString());
                }
                if (expr.isScalar()) {
                    this.scalarSelect = true;
                }
                if (this.isReturnableEntity(expr)) {
                    this.fromElementsForLoad.add(expr.getFromElement());
                }
                queryReturnTypeList.add(type);
            }
            ++i;
        }
        if (!this.getWalker().isShallowQuery()) {
            List fromElements = fromClause.getProjectionList();
            ASTAppender appender = new ASTAppender(this.getASTFactory(), (AST)this);
            int size = fromElements.size();
            Iterator iterator = fromElements.iterator();
            int k = 0;
            while (iterator.hasNext()) {
                FromElement fromElement = (FromElement)iterator.next();
                if (fromElement.isFetch()) {
                    boolean collectionOfElements;
                    Type type = fromElement.getSelectType();
                    this.setCollectionFromElement(fromElement);
                    if (type != null && !(collectionOfElements = fromElement.isCollectionOfValuesOrComponents())) {
                        fromElement.setIncludeSubclasses(true);
                        this.fromElementsForLoad.add(fromElement);
                        String text = fromElement.renderIdentifierSelect(size, k);
                        SelectExpressionImpl generatedExpr = (SelectExpressionImpl)appender.append(125, text, false);
                        if (generatedExpr != null) {
                            generatedExpr.setFromElement(fromElement);
                        }
                    }
                }
                ++k;
            }
            this.renderNonScalarSelects(this.collectSelectExpressions(), fromClause);
        }
        if (this.scalarSelect || this.getWalker().isShallowQuery()) {
            this.renderScalarSelects(selectExpressions, fromClause);
        }
        this.finishInitialization(queryReturnTypeList);
    }

    private void finishInitialization(ArrayList queryReturnTypeList) {
        this.queryReturnTypes = queryReturnTypeList.toArray(new Type[queryReturnTypeList.size()]);
        this.initializeColumnNames();
        this.prepared = true;
    }

    private void initializeColumnNames() {
        this.columnNames = this.getSessionFactoryHelper().generateColumnNames(this.queryReturnTypes);
    }

    void initializeDerivedSelectClause(FromClause fromClause) throws SemanticException {
        if (this.prepared) {
            throw new IllegalStateException("SelectClause was already prepared!");
        }
        List fromElements = fromClause.getProjectionList();
        ASTAppender appender = new ASTAppender(this.getASTFactory(), (AST)this);
        int size = fromElements.size();
        ArrayList<Type> sqlResultTypeList = new ArrayList<Type>(size);
        ArrayList<Type> queryReturnTypeList = new ArrayList<Type>(size);
        Iterator iterator = fromElements.iterator();
        int k = 0;
        while (iterator.hasNext()) {
            boolean collectionOfElements;
            FromElement fromElement = (FromElement)iterator.next();
            Type type = fromElement.getSelectType();
            this.setCollectionFromElement(fromElement);
            if (type != null && !(collectionOfElements = fromElement.isCollectionOfValuesOrComponents())) {
                if (!fromElement.isFetch()) {
                    queryReturnTypeList.add(type);
                }
                this.fromElementsForLoad.add(fromElement);
                sqlResultTypeList.add(type);
                String text = fromElement.renderIdentifierSelect(size, k);
                SelectExpressionImpl generatedExpr = (SelectExpressionImpl)appender.append(125, text, false);
                if (generatedExpr != null) {
                    generatedExpr.setFromElement(fromElement);
                }
            }
            ++k;
        }
        SelectExpression[] selectExpressions = this.collectSelectExpressions();
        if (this.getWalker().isShallowQuery()) {
            this.renderScalarSelects(selectExpressions, fromClause);
        } else {
            this.renderNonScalarSelects(selectExpressions, fromClause);
        }
        this.finishInitialization(queryReturnTypeList);
    }

    private void setCollectionFromElement(FromElement fromElement) {
        if (fromElement.isFetch() && (fromElement.isCollectionJoin() || fromElement.getQueryableCollection() != null)) {
            if (this.collectionFromElement == null) {
                this.collectionFromElement = fromElement;
            } else {
                log.warn((Object)"Collection from element was already set.  Trying to fetch more than one collection?");
            }
        }
    }

    protected AST getFirstSelectExpression() {
        AST n = this.getFirstChild();
        while (n != null && (n.getType() == 16 || n.getType() == 4)) {
            n = n.getNextSibling();
        }
        return n;
    }

    private boolean isReturnableEntity(SelectExpression selectExpression) throws SemanticException {
        boolean isFetchOrValueCollection;
        FromElement fromElement = selectExpression.getFromElement();
        boolean bl = isFetchOrValueCollection = fromElement != null && (fromElement.isFetch() || fromElement.isCollectionOfValuesOrComponents());
        if (isFetchOrValueCollection) {
            return false;
        }
        return selectExpression.isReturnableEntity();
    }

    private void renderScalarSelects(SelectExpression[] se, FromClause currentFromClause) throws SemanticException {
        if (!currentFromClause.isSubQuery()) {
            int i = 0;
            while (i < se.length) {
                SelectExpression expr = se[i];
                expr.setScalarColumnText(i);
                ++i;
            }
        }
    }

    private void renderNonScalarSelects(SelectExpression[] selectExpressions, FromClause currentFromClause) throws SemanticException {
        FromElement fromElement;
        ASTAppender appender = new ASTAppender(this.getASTFactory(), (AST)this);
        int size = selectExpressions.length;
        int nonscalarSize = 0;
        int i = 0;
        while (i < size) {
            if (!selectExpressions[i].isScalar()) {
                ++nonscalarSize;
            }
            ++i;
        }
        int j = 0;
        int i2 = 0;
        while (i2 < size) {
            SelectExpression expr;
            if (!selectExpressions[i2].isScalar() && (fromElement = (expr = selectExpressions[i2]).getFromElement()) != null) {
                this.renderNonScalarIdentifiers(fromElement, nonscalarSize, j, expr, appender);
                ++j;
            }
            ++i2;
        }
        if (!currentFromClause.isSubQuery()) {
            int k = 0;
            int i3 = 0;
            while (i3 < size) {
                if (!selectExpressions[i3].isScalar() && (fromElement = selectExpressions[i3].getFromElement()) != null) {
                    this.renderNonScalarProperties(appender, fromElement, nonscalarSize, k);
                    ++k;
                }
                ++i3;
            }
        }
    }

    private void renderNonScalarIdentifiers(FromElement fromElement, int nonscalarSize, int j, SelectExpression expr, ASTAppender appender) {
        String text = fromElement.renderIdentifierSelect(nonscalarSize, j);
        if (!fromElement.getFromClause().isSubQuery()) {
            if (!this.scalarSelect && !this.getWalker().isShallowQuery()) {
                expr.setText(text);
            } else {
                appender.append(123, text, false);
            }
        }
    }

    private void renderNonScalarProperties(ASTAppender appender, FromElement fromElement, int nonscalarSize, int k) {
        appender.append(123, fromElement.renderPropertySelect(nonscalarSize, k), false);
        String text = fromElement.renderCollectionSelectFragment();
        appender.append(123, text, false);
        ASTIterator iter = new ASTIterator((AST)fromElement);
        while (iter.hasNext()) {
            FromElement child = (FromElement)iter.next();
            if (!child.isCollectionOfValuesOrComponents() || !child.isFetch()) continue;
            text = child.renderCollectionSelectFragment();
            appender.append(123, text, false);
        }
    }

    public FromElement getCollectionFromElement() {
        return this.collectionFromElement;
    }
}

