/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.impl;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.sql.Connection;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Element;
import org.hibernate.CacheMode;
import org.hibernate.Criteria;
import org.hibernate.EntityMode;
import org.hibernate.Filter;
import org.hibernate.FlushMode;
import org.hibernate.HibernateException;
import org.hibernate.Interceptor;
import org.hibernate.LockMode;
import org.hibernate.MappingException;
import org.hibernate.ObjectDeletedException;
import org.hibernate.ObjectNotFoundException;
import org.hibernate.Query;
import org.hibernate.QueryException;
import org.hibernate.ReplicationMode;
import org.hibernate.SQLQuery;
import org.hibernate.ScrollMode;
import org.hibernate.ScrollableResults;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.hibernate.TransientObjectException;
import org.hibernate.UnresolvableObjectException;
import org.hibernate.collection.PersistentCollection;
import org.hibernate.engine.ActionQueue;
import org.hibernate.engine.CollectionEntry;
import org.hibernate.engine.EntityEntry;
import org.hibernate.engine.EntityKey;
import org.hibernate.engine.FilterDefinition;
import org.hibernate.engine.NamedQueryDefinition;
import org.hibernate.engine.NamedSQLQueryDefinition;
import org.hibernate.engine.PersistenceContext;
import org.hibernate.engine.QueryParameters;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.engine.Status;
import org.hibernate.event.AutoFlushEvent;
import org.hibernate.event.DeleteEvent;
import org.hibernate.event.DirtyCheckEvent;
import org.hibernate.event.EvictEvent;
import org.hibernate.event.FlushEvent;
import org.hibernate.event.InitializeCollectionEvent;
import org.hibernate.event.LoadEvent;
import org.hibernate.event.LoadEventListener;
import org.hibernate.event.LockEvent;
import org.hibernate.event.MergeEvent;
import org.hibernate.event.PersistEvent;
import org.hibernate.event.RefreshEvent;
import org.hibernate.event.ReplicateEvent;
import org.hibernate.event.SaveOrUpdateEvent;
import org.hibernate.event.SessionEventListenerConfig;
import org.hibernate.hql.FilterTranslator;
import org.hibernate.hql.QuerySplitter;
import org.hibernate.hql.QueryTranslator;
import org.hibernate.impl.CollectionFilterImpl;
import org.hibernate.impl.CriteriaImpl;
import org.hibernate.impl.FilterImpl;
import org.hibernate.impl.QueryImpl;
import org.hibernate.impl.SQLQueryImpl;
import org.hibernate.impl.SessionFactoryImpl;
import org.hibernate.jdbc.Batcher;
import org.hibernate.jdbc.JDBCContext;
import org.hibernate.loader.criteria.CriteriaLoader;
import org.hibernate.loader.custom.CustomLoader;
import org.hibernate.loader.custom.CustomQuery;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.persister.entity.OuterJoinLoadable;
import org.hibernate.pretty.MessageHelper;
import org.hibernate.proxy.HibernateProxy;
import org.hibernate.proxy.LazyInitializer;
import org.hibernate.type.Type;
import org.hibernate.util.ArrayHelper;
import org.hibernate.util.CollectionHelper;
import org.hibernate.util.EmptyIterator;
import org.hibernate.util.JoinedIterator;
import org.hibernate.util.StringHelper;

public final class SessionImpl
implements SessionImplementor,
JDBCContext.Context {
    private static final Log log;
    private transient SessionFactoryImpl factory;
    private EntityMode entityMode = EntityMode.POJO;
    private final long timestamp;
    private boolean closed = false;
    private FlushMode flushMode = FlushMode.AUTO;
    private CacheMode cacheMode = CacheMode.NORMAL;
    private Interceptor interceptor;
    private transient int dontFlushFromFind = 0;
    private ActionQueue actionQueue;
    private PersistenceContext persistenceContext;
    private transient JDBCContext jdbcContext;
    private SessionEventListenerConfig listeners;
    private Map enabledFilters = new HashMap();
    private boolean isRootSession = true;
    private Map childSessionsByEntityMode;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.hibernate.impl.SessionImpl");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LogFactory.getLog((Class)clazz);
    }

    public Session getSession(EntityMode entityMode) {
        SessionImpl rtn;
        if (this.entityMode == entityMode) {
            return this;
        }
        if (this.childSessionsByEntityMode == null) {
            this.childSessionsByEntityMode = new HashMap();
        }
        if ((rtn = (SessionImpl)this.childSessionsByEntityMode.get(entityMode)) == null) {
            rtn = new SessionImpl(this, entityMode);
            this.childSessionsByEntityMode.put(entityMode, rtn);
        }
        return rtn;
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        log.trace((Object)"deserializing session");
        this.interceptor = (Interceptor)ois.readObject();
        this.factory = (SessionFactoryImpl)ois.readObject();
        this.jdbcContext = (JDBCContext)ois.readObject();
        ois.defaultReadObject();
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        if (this.isConnected()) {
            throw new IllegalStateException("Cannot serialize a Session while connected");
        }
        log.trace((Object)"serializing session");
        oos.writeObject(this.interceptor);
        oos.writeObject(this.factory);
        oos.writeObject(this.jdbcContext);
        oos.defaultWriteObject();
    }

    public void clear() {
        this.persistenceContext.clear();
        this.actionQueue.clear();
    }

    private SessionImpl(SessionImpl parent, EntityMode entityMode) {
        this.factory = parent.factory;
        this.timestamp = parent.timestamp;
        this.jdbcContext = parent.jdbcContext;
        this.interceptor = parent.interceptor;
        this.listeners = parent.listeners;
        this.actionQueue = new ActionQueue(this);
        this.entityMode = entityMode;
        this.persistenceContext = new PersistenceContext(this);
        this.isRootSession = false;
        if (this.factory.getStatistics().isStatisticsEnabled()) {
            this.factory.getStatisticsImplementor().openSession();
        }
        log.debug((Object)("opened session [" + entityMode + "]"));
    }

    SessionImpl(Connection connection, SessionFactoryImpl factory, boolean autoclose, long timestamp, Interceptor interceptor, SessionEventListenerConfig listeners, EntityMode entityMode) {
        this.factory = factory;
        this.timestamp = timestamp;
        this.entityMode = entityMode;
        this.interceptor = interceptor;
        this.listeners = listeners;
        this.actionQueue = new ActionQueue(this);
        this.persistenceContext = new PersistenceContext(this);
        this.isRootSession = true;
        this.jdbcContext = new JDBCContext(this, connection, autoclose);
        if (factory.getStatistics().isStatisticsEnabled()) {
            factory.getStatisticsImplementor().openSession();
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("opened session at timestamp: " + timestamp));
        }
    }

    public Batcher getBatcher() {
        return this.jdbcContext.getBatcher();
    }

    public SessionFactoryImplementor getFactory() {
        return this.factory;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public Connection close() throws HibernateException {
        block8: {
            log.trace((Object)"closing session");
            if (this.factory.getStatistics().isStatisticsEnabled()) {
                this.factory.getStatisticsImplementor().closeSession();
            }
            try {
                try {
                    if (this.childSessionsByEntityMode != null) {
                        Iterator childSessions = this.childSessionsByEntityMode.values().iterator();
                        while (childSessions.hasNext()) {
                            SessionImpl child = (SessionImpl)childSessions.next();
                            child.close();
                        }
                    }
                }
                catch (Throwable throwable) {}
                if (!this.isRootSession) break block8;
                Connection connection = this.jdbcContext.release();
                Object var3_5 = null;
                this.closed = true;
                this.cleanup();
                return connection;
            }
            catch (Throwable throwable) {
                Object var3_7 = null;
                this.closed = true;
                this.cleanup();
                throw throwable;
            }
        }
        Connection connection = null;
        Object var3_6 = null;
        this.closed = true;
        this.cleanup();
        return connection;
    }

    public boolean isOpen() {
        return !this.closed;
    }

    public boolean isFlushModeNever() {
        return this.getFlushMode() == FlushMode.NEVER;
    }

    public boolean isFlushBeforeCompletionEnabled() {
        return this.getFactory().getSettings().isFlushBeforeCompletionEnabled();
    }

    public void managedFlush() {
        log.trace((Object)"automatically flushing session");
        this.flush();
        if (this.childSessionsByEntityMode != null) {
            Iterator iter = this.childSessionsByEntityMode.values().iterator();
            while (iter.hasNext()) {
                ((Session)iter.next()).flush();
            }
        }
    }

    public boolean shouldAutoClose() {
        return this.getFactory().getSettings().isAutoCloseSessionEnabled() && this.isOpen();
    }

    public void managedClose() {
        log.trace((Object)"automatically closing session");
        this.close();
    }

    public Connection connection() throws HibernateException {
        return this.jdbcContext.connection();
    }

    public boolean isConnected() {
        return this.jdbcContext.isConnected();
    }

    public Connection disconnect() throws HibernateException {
        log.debug((Object)"disconnecting session");
        return this.jdbcContext.disconnect();
    }

    public void reconnect() throws HibernateException {
        log.debug((Object)"reconnecting session");
        this.jdbcContext.reconnect();
    }

    public void reconnect(Connection conn) throws HibernateException {
        log.debug((Object)"reconnecting session");
        this.jdbcContext.reconnect(conn);
    }

    public void beforeTransactionCompletion(Transaction tx) {
        log.trace((Object)"before transaction completion");
        if (!this.isRootSession) {
            log.trace((Object)"skipping beforeTransactionCompletion processing as this is not root session");
            return;
        }
        try {
            this.interceptor.beforeTransactionCompletion(tx);
        }
        catch (Throwable t) {
            log.error((Object)"exception in interceptor beforeTransactionCompletion()", t);
        }
    }

    public void afterTransactionCompletion(boolean success, Transaction tx) {
        log.trace((Object)"after transaction completion");
        this.persistenceContext.afterTransactionCompletion();
        this.actionQueue.afterTransactionCompletion(success);
        if (this.isRootSession) {
            try {
                this.interceptor.afterTransactionCompletion(tx);
            }
            catch (Throwable t) {
                log.error((Object)"exception in interceptor beforeTransactionCompletion()", t);
            }
        }
    }

    private void cleanup() {
        this.persistenceContext.clear();
    }

    public LockMode getCurrentLockMode(Object object) throws HibernateException {
        if (object == null) {
            throw new NullPointerException("null object passed to getCurrentLockMode()");
        }
        if (object instanceof HibernateProxy && (object = ((HibernateProxy)object).getHibernateLazyInitializer().getImplementation(this)) == null) {
            return LockMode.NONE;
        }
        EntityEntry e = this.persistenceContext.getEntry(object);
        if (e == null) {
            throw new TransientObjectException("Given object not associated with the session");
        }
        if (e.getStatus() != Status.MANAGED) {
            throw new ObjectDeletedException("The given object was deleted", e.getId(), e.getPersister().getEntityName());
        }
        return e.getLockMode();
    }

    public Object getEntityUsingInterceptor(EntityKey key) throws HibernateException {
        Object result = this.persistenceContext.getEntity(key);
        if (result == null) {
            Object newObject = this.interceptor.getEntity(key.getEntityName(), key.getIdentifier());
            if (newObject != null) {
                this.lock(newObject, LockMode.NONE);
            }
            return newObject;
        }
        return result;
    }

    public void saveOrUpdate(Object object) throws HibernateException {
        this.saveOrUpdate(null, object);
    }

    public void saveOrUpdate(String entityName, Object obj) throws HibernateException {
        SaveOrUpdateEvent event = new SaveOrUpdateEvent(entityName, obj, this);
        this.listeners.getSaveOrUpdateEventListener().onSaveOrUpdate(event);
    }

    public void save(Object obj, Serializable id) throws HibernateException {
        this.save(null, obj, id);
    }

    public Serializable save(Object obj) throws HibernateException {
        return this.save(null, obj);
    }

    public Serializable save(String entityName, Object object) throws HibernateException {
        SaveOrUpdateEvent event = new SaveOrUpdateEvent(entityName, object, this);
        return this.listeners.getSaveEventListener().onSaveOrUpdate(event);
    }

    public void save(String entityName, Object object, Serializable id) throws HibernateException {
        SaveOrUpdateEvent event = new SaveOrUpdateEvent(entityName, object, id, this);
        this.listeners.getSaveEventListener().onSaveOrUpdate(event);
    }

    public void update(Object obj) throws HibernateException {
        this.update(null, obj);
    }

    public void update(Object obj, Serializable id) throws HibernateException {
        this.update(null, obj, id);
    }

    public void update(String entityName, Object object) throws HibernateException {
        SaveOrUpdateEvent event = new SaveOrUpdateEvent(entityName, object, this);
        this.listeners.getUpdateEventListener().onSaveOrUpdate(event);
    }

    public void update(String entityName, Object object, Serializable id) throws HibernateException {
        SaveOrUpdateEvent event = new SaveOrUpdateEvent(entityName, object, id, this);
        this.listeners.getUpdateEventListener().onSaveOrUpdate(event);
    }

    public void lock(Object object, LockMode lockMode) throws HibernateException {
        this.listeners.getLockEventListener().onLock(new LockEvent(object, lockMode, this));
    }

    public void lock(String entityName, Object object, LockMode lockMode) throws HibernateException {
        LockEvent event = new LockEvent(entityName, object, lockMode, this);
        this.listeners.getLockEventListener().onLock(event);
    }

    public void persist(String entityName, Object object, Map copiedAlready) throws HibernateException {
        PersistEvent event = new PersistEvent(entityName, object, this);
        this.listeners.getCreateEventListener().onPersist(event, copiedAlready);
    }

    public void persist(String entityName, Object object) throws HibernateException {
        PersistEvent event = new PersistEvent(entityName, object, this);
        this.listeners.getCreateEventListener().onPersist(event);
    }

    public void persist(Object object) throws HibernateException {
        this.persist(null, object);
    }

    public Object merge(String entityName, Object object) throws HibernateException {
        MergeEvent event = new MergeEvent(entityName, object, this);
        return this.listeners.getMergeEventListener().onMerge(event);
    }

    public Object merge(Object object) throws HibernateException {
        return this.merge(null, object);
    }

    public void merge(String entityName, Object object, Map copiedAlready) throws HibernateException {
        MergeEvent event = new MergeEvent(entityName, object, this);
        this.listeners.getMergeEventListener().onMerge(event, copiedAlready);
    }

    public Object saveOrUpdateCopy(String entityName, Object object) throws HibernateException {
        MergeEvent event = new MergeEvent(entityName, object, this);
        return this.listeners.getSaveOrUpdateCopyEventListener().onMerge(event);
    }

    public Object saveOrUpdateCopy(Object object) throws HibernateException {
        return this.saveOrUpdateCopy(null, object);
    }

    public Object saveOrUpdateCopy(String entityName, Object object, Serializable id) throws HibernateException {
        MergeEvent event = new MergeEvent(entityName, object, id, this);
        return this.listeners.getSaveOrUpdateCopyEventListener().onMerge(event);
    }

    public Object saveOrUpdateCopy(Object object, Serializable id) throws HibernateException {
        return this.saveOrUpdateCopy(null, object, id);
    }

    public void saveOrUpdateCopy(String entityName, Object object, Map copiedAlready) throws HibernateException {
        MergeEvent event = new MergeEvent(entityName, object, this);
        this.listeners.getSaveOrUpdateCopyEventListener().onMerge(event, copiedAlready);
    }

    public void delete(Object object) throws HibernateException {
        DeleteEvent event = new DeleteEvent(object, this);
        this.listeners.getDeleteEventListener().onDelete(event);
    }

    public void delete(String entityName, Object object, boolean isCascadeDeleteEnabled) throws HibernateException {
        DeleteEvent event = new DeleteEvent(entityName, object, isCascadeDeleteEnabled, this);
        this.listeners.getDeleteEventListener().onDelete(event);
    }

    public void load(Object object, Serializable id) throws HibernateException {
        LoadEvent event = new LoadEvent(id, object, this);
        this.listeners.getLoadEventListener().onLoad(event, null);
    }

    public Object load(Class entityClass, Serializable id) throws HibernateException {
        return this.load(entityClass.getName(), id);
    }

    public Object load(String entityName, Serializable id) throws HibernateException {
        LoadEvent event = new LoadEvent(id, entityName, false, (SessionImplementor)this);
        Object result = this.listeners.getLoadEventListener().onLoad(event, LoadEventListener.LOAD);
        ObjectNotFoundException.throwIfNull(result, id, entityName);
        return result;
    }

    public Object get(Class entityClass, Serializable id) throws HibernateException {
        return this.get(entityClass.getName(), id);
    }

    public Object get(String entityName, Serializable id) throws HibernateException {
        LoadEvent event = new LoadEvent(id, entityName, false, (SessionImplementor)this);
        return this.listeners.getLoadEventListener().onLoad(event, LoadEventListener.GET);
    }

    public Object immediateLoad(String entityName, Serializable id) throws HibernateException {
        if (log.isDebugEnabled()) {
            EntityPersister persister = this.getFactory().getEntityPersister(entityName);
            log.debug((Object)("initializing proxy: " + MessageHelper.infoString(persister, id, this.getFactory())));
        }
        LoadEvent event = new LoadEvent(id, entityName, true, (SessionImplementor)this);
        Object result = this.listeners.getLoadEventListener().onLoad(event, LoadEventListener.IMMEDIATE_LOAD);
        ObjectNotFoundException.throwIfNull(result, id, entityName);
        return result;
    }

    public Object internalLoadOneToOne(String entityName, Serializable id) throws HibernateException {
        LoadEvent event = new LoadEvent(id, entityName, true, (SessionImplementor)this);
        return this.listeners.getLoadEventListener().onLoad(event, LoadEventListener.INTERNAL_LOAD_ONE_TO_ONE);
    }

    public Object internalLoad(String entityName, Serializable id) throws HibernateException {
        LoadEvent event = new LoadEvent(id, entityName, true, (SessionImplementor)this);
        Object result = this.listeners.getLoadEventListener().onLoad(event, LoadEventListener.INTERNAL_LOAD);
        UnresolvableObjectException.throwIfNull(result, id, entityName);
        return result;
    }

    public Object load(Class entityClass, Serializable id, LockMode lockMode) throws HibernateException {
        return this.load(entityClass.getName(), id, lockMode);
    }

    public Object load(String entityName, Serializable id, LockMode lockMode) throws HibernateException {
        LoadEvent event = new LoadEvent(id, entityName, lockMode, (SessionImplementor)this);
        return this.listeners.getLoadEventListener().onLoad(event, LoadEventListener.LOAD);
    }

    public Object get(Class entityClass, Serializable id, LockMode lockMode) throws HibernateException {
        return this.get(entityClass.getName(), id, lockMode);
    }

    public Object get(String entityName, Serializable id, LockMode lockMode) throws HibernateException {
        LoadEvent event = new LoadEvent(id, entityName, lockMode, (SessionImplementor)this);
        return this.listeners.getLoadEventListener().onLoad(event, LoadEventListener.GET);
    }

    public void refresh(Object object) throws HibernateException {
        this.listeners.getRefreshEventListener().onRefresh(new RefreshEvent(object, this));
    }

    public void refresh(Object object, LockMode lockMode) throws HibernateException {
        this.listeners.getRefreshEventListener().onRefresh(new RefreshEvent(object, lockMode, this));
    }

    public void replicate(Object obj, ReplicationMode replicationMode) throws HibernateException {
        ReplicateEvent event = new ReplicateEvent(obj, replicationMode, this);
        this.listeners.getReplicateEventListener().onReplicate(event);
    }

    public void replicate(String entityName, Object obj, ReplicationMode replicationMode) throws HibernateException {
        ReplicateEvent event = new ReplicateEvent(entityName, obj, replicationMode, this);
        this.listeners.getReplicateEventListener().onReplicate(event);
    }

    public void evict(Object object) throws HibernateException {
        this.listeners.getEvictEventListener().onEvict(new EvictEvent(object, this));
    }

    private boolean autoFlushIfRequired(Set querySpaces) throws HibernateException {
        AutoFlushEvent event = new AutoFlushEvent(querySpaces, this);
        return this.listeners.getAutoFlushEventListener().onAutoFlush(event);
    }

    public boolean isDirty() throws HibernateException {
        log.debug((Object)"checking session dirtiness");
        if (this.actionQueue.areInsertionsOrDeletionsQueued()) {
            log.debug((Object)"session dirty (scheduled updates and insertions)");
            return true;
        }
        DirtyCheckEvent event = new DirtyCheckEvent(this);
        return this.listeners.getDirtyCheckEventListener().onDirtyCheck(event);
    }

    public void flush() throws HibernateException {
        if (this.persistenceContext.getCascadeLevel() > 0) {
            throw new HibernateException("Flush during cascade is dangerous");
        }
        this.listeners.getFlushEventListener().onFlush(new FlushEvent(this));
    }

    public void forceFlush(EntityEntry e) throws HibernateException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("flushing to force deletion of re-saved object: " + MessageHelper.infoString(e.getPersister(), e.getId(), this.getFactory())));
        }
        if (this.persistenceContext.getCascadeLevel() > 0) {
            throw new ObjectDeletedException("deleted object would be re-saved by cascade (remove deleted object from associations)", e.getId(), e.getPersister().getEntityName());
        }
        this.flush();
    }

    public Filter enableFilter(String filterName) {
        FilterImpl filter = new FilterImpl(this.factory.getFilterDefinition(filterName));
        this.enabledFilters.put(filterName, filter);
        return filter;
    }

    public Filter getEnabledFilter(String filterName) {
        return (Filter)this.enabledFilters.get(filterName);
    }

    public void disableFilter(String filterName) {
        this.enabledFilters.remove(filterName);
    }

    public Object getFilterParameterValue(String filterParameterName) {
        String[] parsed = this.parseFilterParameterName(filterParameterName);
        FilterImpl filter = (FilterImpl)this.enabledFilters.get(parsed[0]);
        if (filter == null) {
            throw new IllegalArgumentException("Filter [" + parsed[0] + "] currently not enabled");
        }
        return filter.getParameter(parsed[1]);
    }

    public Type getFilterParameterType(String filterParameterName) {
        String[] parsed = this.parseFilterParameterName(filterParameterName);
        FilterDefinition filterDef = this.factory.getFilterDefinition(parsed[0]);
        if (filterDef == null) {
            throw new IllegalArgumentException("Filter [" + parsed[0] + "] not defined");
        }
        Type type = filterDef.getParameterType(parsed[1]);
        if (type == null) {
            throw new InternalError("Unable to locate type for filter parameter");
        }
        return type;
    }

    public Map getEnabledFilters() {
        Iterator itr = this.enabledFilters.values().iterator();
        while (itr.hasNext()) {
            Filter filter = (Filter)itr.next();
            filter.validate();
        }
        return this.enabledFilters;
    }

    private String[] parseFilterParameterName(String filterParameterName) {
        int dot = filterParameterName.indexOf(46);
        if (dot <= 0) {
            throw new IllegalArgumentException("Invalid filter-parametter name format");
        }
        String filterName = filterParameterName.substring(0, dot);
        String parameterName = filterParameterName.substring(dot + 1);
        return new String[]{filterName, parameterName};
    }

    public List find(String query) throws HibernateException {
        return this.list(query, new QueryParameters());
    }

    public List find(String query, Object value, Type type) throws HibernateException {
        return this.list(query, new QueryParameters(type, value));
    }

    public List find(String query, Object[] values, Type[] types) throws HibernateException {
        return this.list(query, new QueryParameters(types, values));
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List list(String query, QueryParameters queryParameters) throws HibernateException {
        if (log.isTraceEnabled()) {
            log.trace((Object)("find: " + query));
            queryParameters.traceParameters(this.factory);
        }
        queryParameters.validateParameters();
        QueryTranslator[] q = this.getQueries(query, false);
        List results = CollectionHelper.EMPTY_LIST;
        ++this.dontFlushFromFind;
        try {
            int i = 0;
            while (i < q.length) {
                List currentResults = q[i].list(this, queryParameters);
                currentResults.addAll(results);
                results = currentResults;
                ++i;
            }
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            --this.dontFlushFromFind;
            throw throwable;
        }
        {
            Object var7_9 = null;
            --this.dontFlushFromFind;
            return results;
        }
    }

    public int executeUpdate(String query, QueryParameters queryParameters) throws HibernateException {
        if (log.isTraceEnabled()) {
            log.trace((Object)("executeUpdate: " + query));
            queryParameters.traceParameters(this.factory);
        }
        queryParameters.validateParameters();
        QueryTranslator[] q = this.getQueries(query, false);
        if (q.length > 1) {
            log.warn((Object)"update query returned multiple translators");
        }
        return q[0].executeUpdate(queryParameters, this);
    }

    private QueryTranslator[] getQueries(String query, boolean scalar) throws HibernateException {
        QueryTranslator[] q = this.factory.getQuery(query, scalar, this.getEnabledFilters());
        return this.prepareQueries(q);
    }

    private QueryTranslator[] prepareQueries(QueryTranslator[] q) {
        HashSet qs = new HashSet();
        int i = 0;
        while (i < q.length) {
            qs.addAll(q[i].getQuerySpaces());
            ++i;
        }
        this.autoFlushIfRequired(qs);
        return q;
    }

    public Iterator iterate(String query) throws HibernateException {
        return this.iterate(query, new QueryParameters());
    }

    public Iterator iterate(String query, Object value, Type type) throws HibernateException {
        return this.iterate(query, new QueryParameters(type, value));
    }

    public Iterator iterate(String query, Object[] values, Type[] types) throws HibernateException {
        return this.iterate(query, new QueryParameters(types, values));
    }

    public Iterator iterate(String query, QueryParameters queryParameters) throws HibernateException {
        boolean many;
        if (log.isTraceEnabled()) {
            log.trace((Object)("iterate: " + query));
            queryParameters.traceParameters(this.factory);
        }
        queryParameters.validateParameters();
        QueryTranslator[] q = this.getQueries(query, true);
        if (q.length == 0) {
            return EmptyIterator.INSTANCE;
        }
        Iterator result = null;
        Iterator[] results = null;
        boolean bl = many = q.length > 1;
        if (many) {
            results = new Iterator[q.length];
        }
        ++this.dontFlushFromFind;
        try {
            int i = 0;
            while (i < q.length) {
                result = q[i].iterate(queryParameters, this);
                if (many) {
                    results[i] = result;
                }
                ++i;
            }
            JoinedIterator joinedIterator = many ? new JoinedIterator(results) : result;
            Object var8_9 = null;
            --this.dontFlushFromFind;
            return joinedIterator;
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            --this.dontFlushFromFind;
            throw throwable;
        }
    }

    public ScrollableResults scroll(String query, QueryParameters queryParameters) throws HibernateException {
        QueryTranslator[] q;
        if (log.isTraceEnabled()) {
            log.trace((Object)("scroll: " + query));
            queryParameters.traceParameters(this.factory);
        }
        if ((q = this.factory.getQuery(query, false, this.getEnabledFilters())).length != 1) {
            throw new QueryException("implicit polymorphism not supported for scroll() queries");
        }
        this.autoFlushIfRequired(q[0].getQuerySpaces());
        ++this.dontFlushFromFind;
        try {
            ScrollableResults scrollableResults = q[0].scroll(queryParameters, this);
            Object var4_5 = null;
            --this.dontFlushFromFind;
            return scrollableResults;
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            --this.dontFlushFromFind;
            throw throwable;
        }
    }

    public int delete(String query) throws HibernateException {
        return this.delete(query, ArrayHelper.EMPTY_OBJECT_ARRAY, ArrayHelper.EMPTY_TYPE_ARRAY);
    }

    public int delete(String query, Object value, Type type) throws HibernateException {
        return this.delete(query, new Object[]{value}, new Type[]{type});
    }

    public int delete(String query, Object[] values, Type[] types) throws HibernateException {
        if (query == null) {
            throw new IllegalArgumentException("attempt to perform delete-by-query with null query");
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("delete: " + query));
            if (values.length != 0) {
                log.trace((Object)("parameters: " + StringHelper.toString(values)));
            }
        }
        List list = this.find(query, values, types);
        int deletionCount = list.size();
        int i = 0;
        while (i < deletionCount) {
            this.delete(list.get(i));
            ++i;
        }
        return deletionCount;
    }

    public Query createFilter(Object collection, String queryString) {
        return new CollectionFilterImpl(queryString, collection, (SessionImplementor)this);
    }

    public Query createQuery(String queryString) {
        return new QueryImpl(queryString, this);
    }

    private Query createQuery(String queryString, FlushMode queryFlushMode) {
        return new QueryImpl(queryString, queryFlushMode, this);
    }

    public Query getNamedQuery(String queryName) throws MappingException {
        Query query;
        NamedQueryDefinition nqd = this.factory.getNamedQuery(queryName);
        if (nqd != null) {
            query = this.createQuery(nqd.getQueryString(), nqd.getFlushMode());
            if (this.factory.getSettings().isCommentsEnabled()) {
                query.setComment("named query " + queryName);
            }
        } else {
            NamedSQLQueryDefinition nsqlqd = this.factory.getNamedSQLQuery(queryName);
            if (nsqlqd == null) {
                throw new MappingException("Named query not known: " + queryName);
            }
            query = new SQLQueryImpl(nsqlqd, (SessionImplementor)this);
            nqd = nsqlqd;
            if (this.factory.getSettings().isCommentsEnabled()) {
                query.setComment("named SQL query " + queryName);
            }
        }
        query.setCacheable(nqd.isCacheable());
        query.setCacheRegion(nqd.getCacheRegion());
        if (nqd.getTimeout() != null) {
            query.setTimeout(nqd.getTimeout());
        }
        if (nqd.getFetchSize() != null) {
            query.setFetchSize(nqd.getFetchSize());
        }
        return query;
    }

    public Object instantiate(String entityName, Serializable id) throws HibernateException {
        return this.instantiate(this.factory.getEntityPersister(entityName), id);
    }

    public Object instantiate(EntityPersister persister, Serializable id) throws HibernateException {
        Object result = this.interceptor.instantiate(persister.getEntityName(), this.entityMode, id);
        if (result == null) {
            result = persister.instantiate(id, this.entityMode);
        }
        return result;
    }

    public EntityMode getEntityMode() {
        return this.entityMode;
    }

    public void setFlushMode(FlushMode flushMode) {
        if (log.isTraceEnabled()) {
            log.trace((Object)("setting flush mode to: " + flushMode));
        }
        this.flushMode = flushMode;
    }

    public FlushMode getFlushMode() {
        return this.flushMode;
    }

    public CacheMode getCacheMode() {
        return this.cacheMode;
    }

    public void setCacheMode(CacheMode cacheMode) {
        if (log.isTraceEnabled()) {
            log.trace((Object)("setting cache mode to: " + cacheMode));
        }
        this.cacheMode = cacheMode;
    }

    public Transaction beginTransaction() throws HibernateException {
        if (!this.isRootSession) {
            log.warn((Object)"Transaction started on non-root session");
        }
        Transaction tx = this.jdbcContext.beginTransaction();
        this.interceptor.afterTransactionBegin(tx);
        return tx;
    }

    public EntityPersister getEntityPersister(String entityName, Object object) {
        if (entityName == null) {
            return this.factory.getEntityPersister(this.guessEntityName(object));
        }
        return this.factory.getEntityPersister(entityName).getSubclassEntityPersister(object, this.getFactory(), this.entityMode);
    }

    public Serializable getIdentifier(Object object) throws HibernateException {
        if (object instanceof HibernateProxy) {
            LazyInitializer li = ((HibernateProxy)object).getHibernateLazyInitializer();
            if (li.getSession() != this) {
                throw new TransientObjectException("The proxy was not associated with this session");
            }
            return li.getIdentifier();
        }
        EntityEntry entry = this.persistenceContext.getEntry(object);
        if (entry == null) {
            throw new TransientObjectException("The instance was not associated with this session");
        }
        return entry.getId();
    }

    public Serializable getEntityIdentifier(Object object) {
        if (object instanceof HibernateProxy) {
            return this.getProxyIdentifier(object);
        }
        EntityEntry entry = this.persistenceContext.getEntry(object);
        return entry != null ? entry.getId() : null;
    }

    private Serializable getProxyIdentifier(Object proxy) {
        return ((HibernateProxy)proxy).getHibernateLazyInitializer().getIdentifier();
    }

    public Collection filter(Object collection, String filter) throws HibernateException {
        return this.listFilter(collection, filter, new QueryParameters(new Type[1], new Object[1]));
    }

    public Collection filter(Object collection, String filter, Object value, Type type) throws HibernateException {
        Type[] typeArray = new Type[2];
        typeArray[1] = type;
        Object[] objectArray = new Object[2];
        objectArray[1] = value;
        return this.listFilter(collection, filter, new QueryParameters(typeArray, objectArray));
    }

    public Collection filter(Object collection, String filter, Object[] values, Type[] types) throws HibernateException {
        Object[] vals = new Object[values.length + 1];
        Type[] typs = new Type[types.length + 1];
        System.arraycopy(values, 0, vals, 1, values.length);
        System.arraycopy(types, 0, typs, 1, types.length);
        return this.listFilter(collection, filter, new QueryParameters(typs, vals));
    }

    private FilterTranslator getFilterTranslator(Object collection, String filter, QueryParameters parameters, boolean scalar) throws HibernateException {
        FilterTranslator filterTranslator;
        CollectionEntry entry;
        CollectionPersister roleBeforeFlush;
        if (collection == null) {
            throw new NullPointerException("null collection passed to filter");
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("filter: " + filter));
            parameters.traceParameters(this.factory);
        }
        CollectionPersister collectionPersister = roleBeforeFlush = (entry = this.persistenceContext.getCollectionEntryOrNull(collection)) == null ? null : entry.getLoadedPersister();
        if (roleBeforeFlush == null) {
            CollectionPersister roleAfterFlush;
            this.flush();
            entry = this.persistenceContext.getCollectionEntryOrNull(collection);
            CollectionPersister collectionPersister2 = roleAfterFlush = entry == null ? null : entry.getLoadedPersister();
            if (roleAfterFlush == null) {
                throw new QueryException("The collection was unreferenced");
            }
            filterTranslator = this.factory.getFilter(filter, roleAfterFlush.getRole(), scalar, this.getEnabledFilters());
        } else {
            filterTranslator = this.factory.getFilter(filter, roleBeforeFlush.getRole(), scalar, this.getEnabledFilters());
            if (this.autoFlushIfRequired(filterTranslator.getQuerySpaces())) {
                CollectionPersister roleAfterFlush;
                entry = this.persistenceContext.getCollectionEntryOrNull(collection);
                CollectionPersister collectionPersister3 = roleAfterFlush = entry == null ? null : entry.getLoadedPersister();
                if (roleBeforeFlush != roleAfterFlush) {
                    if (roleAfterFlush == null) {
                        throw new QueryException("The collection was dereferenced");
                    }
                    filterTranslator = this.factory.getFilter(filter, roleAfterFlush.getRole(), scalar, this.getEnabledFilters());
                }
            }
        }
        parameters.getPositionalParameterValues()[0] = entry.getLoadedKey();
        parameters.getPositionalParameterTypes()[0] = entry.getLoadedPersister().getKeyType();
        return filterTranslator;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List listFilter(Object collection, String filter, QueryParameters queryParameters) throws HibernateException {
        String[] concreteFilters = QuerySplitter.concreteQueries(filter, this.factory);
        FilterTranslator[] filters = new FilterTranslator[concreteFilters.length];
        int i = 0;
        while (i < concreteFilters.length) {
            filters[i] = this.getFilterTranslator(collection, concreteFilters[i], queryParameters, false);
            ++i;
        }
        ++this.dontFlushFromFind;
        List results = CollectionHelper.EMPTY_LIST;
        try {
            int i2 = 0;
            while (i2 < concreteFilters.length) {
                List currentResults = filters[i2].list(this, queryParameters);
                currentResults.addAll(results);
                results = currentResults;
                ++i2;
            }
            Object var9_12 = null;
            --this.dontFlushFromFind;
            return results;
        }
        catch (Throwable throwable) {
            Object var9_11 = null;
            --this.dontFlushFromFind;
            throw throwable;
        }
    }

    public Iterator iterateFilter(Object collection, String filter, QueryParameters queryParameters) throws HibernateException {
        boolean many;
        String[] concreteFilters = QuerySplitter.concreteQueries(filter, this.factory);
        FilterTranslator[] filters = new FilterTranslator[concreteFilters.length];
        int i = 0;
        while (i < concreteFilters.length) {
            filters[i] = this.getFilterTranslator(collection, concreteFilters[i], queryParameters, true);
            ++i;
        }
        if (filters.length == 0) {
            return EmptyIterator.INSTANCE;
        }
        Iterator result = null;
        Iterator[] results = null;
        boolean bl = many = filters.length > 1;
        if (many) {
            results = new Iterator[filters.length];
        }
        int i2 = 0;
        while (i2 < filters.length) {
            result = filters[i2].iterate(queryParameters, this);
            if (many) {
                results[i2] = result;
            }
            ++i2;
        }
        return many ? new JoinedIterator(results) : result;
    }

    public Criteria createCriteria(Class persistentClass, String alias) {
        return new CriteriaImpl(persistentClass.getName(), alias, this);
    }

    public Criteria createCriteria(String entityName, String alias) {
        return new CriteriaImpl(entityName, alias, this);
    }

    public Criteria createCriteria(Class persistentClass) {
        return new CriteriaImpl(persistentClass.getName(), this);
    }

    public Criteria createCriteria(String entityName) {
        return new CriteriaImpl(entityName, this);
    }

    public ScrollableResults scroll(CriteriaImpl criteria, ScrollMode scrollMode) {
        String entityName = criteria.getEntityOrClassName();
        CriteriaLoader loader = new CriteriaLoader(this.getOuterJoinLoadable(entityName), this.factory, criteria, entityName, this.getEnabledFilters());
        this.autoFlushIfRequired(loader.getQuerySpaces());
        ++this.dontFlushFromFind;
        try {
            ScrollableResults scrollableResults = loader.scroll(this, scrollMode);
            Object var5_6 = null;
            --this.dontFlushFromFind;
            return scrollableResults;
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            --this.dontFlushFromFind;
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List list(CriteriaImpl criteria) throws HibernateException {
        String[] implementors = this.factory.getImplementors(criteria.getEntityOrClassName());
        int size = implementors.length;
        CriteriaLoader[] loaders = new CriteriaLoader[size];
        HashSet spaces = new HashSet();
        int i = 0;
        while (i < size) {
            loaders[i] = new CriteriaLoader(this.getOuterJoinLoadable(implementors[i]), this.factory, criteria, implementors[i], this.getEnabledFilters());
            spaces.addAll(loaders[i].getQuerySpaces());
            ++i;
        }
        this.autoFlushIfRequired(spaces);
        List results = Collections.EMPTY_LIST;
        ++this.dontFlushFromFind;
        try {
            int i2 = 0;
            while (i2 < size) {
                List currentResults = loaders[i2].list(this);
                currentResults.addAll(results);
                results = currentResults;
                ++i2;
            }
            Object var9_12 = null;
            --this.dontFlushFromFind;
            return results;
        }
        catch (Throwable throwable) {
            Object var9_11 = null;
            --this.dontFlushFromFind;
            throw throwable;
        }
    }

    private OuterJoinLoadable getOuterJoinLoadable(String entityName) throws MappingException {
        EntityPersister persister = this.factory.getEntityPersister(entityName);
        if (!(persister instanceof OuterJoinLoadable)) {
            throw new MappingException("class persister is not OuterJoinLoadable: " + entityName);
        }
        return (OuterJoinLoadable)persister;
    }

    public boolean contains(Object object) {
        if (object instanceof HibernateProxy) {
            LazyInitializer li = ((HibernateProxy)object).getHibernateLazyInitializer();
            if (li.isUninitialized()) {
                return li.getSession() == this;
            }
            object = li.getImplementation();
        }
        return this.persistenceContext.isEntryFor(object);
    }

    public SQLQuery createSQLQuery(String sql) {
        return new SQLQueryImpl(sql, (SessionImplementor)this);
    }

    public Query createSQLQuery(String sql, String returnAlias, Class returnClass) {
        return new SQLQueryImpl(sql, new String[]{returnAlias}, new Class[]{returnClass}, this);
    }

    public Query createSQLQuery(String sql, String[] returnAliases, Class[] returnClasses) {
        return new SQLQueryImpl(sql, returnAliases, returnClasses, this);
    }

    public ScrollableResults scrollCustomQuery(CustomQuery customQuery, QueryParameters queryParameters) throws HibernateException {
        if (log.isTraceEnabled()) {
            log.trace((Object)("scroll SQL query: " + customQuery.getSQL()));
        }
        CustomLoader loader = new CustomLoader(customQuery, this.getFactory());
        this.autoFlushIfRequired(loader.getQuerySpaces());
        ++this.dontFlushFromFind;
        try {
            ScrollableResults scrollableResults = loader.scroll(queryParameters, this);
            Object var4_5 = null;
            --this.dontFlushFromFind;
            return scrollableResults;
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            --this.dontFlushFromFind;
            throw throwable;
        }
    }

    public List listCustomQuery(CustomQuery customQuery, QueryParameters queryParameters) throws HibernateException {
        if (log.isTraceEnabled()) {
            log.trace((Object)("SQL query: " + customQuery.getSQL()));
        }
        CustomLoader loader = new CustomLoader(customQuery, this.getFactory());
        this.autoFlushIfRequired(loader.getQuerySpaces());
        ++this.dontFlushFromFind;
        try {
            List list = loader.list(this, queryParameters);
            Object var4_5 = null;
            --this.dontFlushFromFind;
            return list;
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            --this.dontFlushFromFind;
            throw throwable;
        }
    }

    public SessionFactory getSessionFactory() {
        return this.factory;
    }

    public void initializeCollection(PersistentCollection collection, boolean writing) throws HibernateException {
        this.listeners.getInitializeCollectionEventListener().onInitializeCollection(new InitializeCollectionEvent(collection, this));
    }

    public String bestGuessEntityName(Object object) {
        EntityEntry entry;
        if (object instanceof HibernateProxy) {
            object = ((HibernateProxy)object).getHibernateLazyInitializer().getImplementation();
        }
        if ((entry = this.persistenceContext.getEntry(object)) == null) {
            return this.guessEntityName(object);
        }
        return entry.getPersister().getEntityName();
    }

    public String getEntityName(Object object) {
        EntityEntry entry;
        if (object instanceof HibernateProxy) {
            if (!this.persistenceContext.containsProxy(object)) {
                throw new TransientObjectException("proxy was not associated with the session");
            }
            object = ((HibernateProxy)object).getHibernateLazyInitializer().getImplementation();
        }
        if ((entry = this.persistenceContext.getEntry(object)) == null) {
            this.throwTransientObjectException(object);
        }
        return entry.getPersister().getEntityName();
    }

    private void throwTransientObjectException(Object object) throws HibernateException {
        throw new TransientObjectException("object references an unsaved transient instance - save the transient instance before flushing: " + this.guessEntityName(object));
    }

    public String guessEntityName(Object object) throws HibernateException {
        String entity = this.interceptor.getEntityName(object);
        if (entity == null) {
            if (object instanceof Map) {
                entity = (String)((Map)object).get("type");
                if (entity == null) {
                    throw new HibernateException("could not determine type of dynamic entity");
                }
            } else {
                if (object instanceof Element) {
                    return ((Element)object).getName();
                }
                entity = object.getClass().getName();
            }
        }
        return entity;
    }

    public void cancelQuery() throws HibernateException {
        this.getBatcher().cancelLastQuery();
    }

    public Interceptor getInterceptor() {
        return this.interceptor;
    }

    public int getDontFlushFromFind() {
        return this.dontFlushFromFind;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer(500).append(this.getClass().getName()).append('(');
        if (this.isOpen()) {
            buf.append(this.persistenceContext).append(" ").append(this.actionQueue);
        } else {
            buf.append("<closed>");
        }
        return buf.append(')').toString();
    }

    public SessionEventListenerConfig getListeners() {
        return this.listeners;
    }

    public ActionQueue getActionQueue() {
        return this.actionQueue;
    }

    public PersistenceContext getPersistenceContext() {
        return this.persistenceContext;
    }
}

