/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.intercept;

import java.io.Serializable;
import java.util.Set;
import net.sf.cglib.transform.impl.InterceptFieldCallback;
import org.hibernate.LazyInitializationException;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.intercept.LazyPropertyInitializer;

public class FieldInterceptor
implements InterceptFieldCallback,
Serializable {
    private transient SessionImplementor session;
    private Set uninitializedFields;
    private final String entityName;
    private transient boolean initializing;

    public FieldInterceptor(SessionImplementor session, String entityName, Set uninitializedFields) {
        this.session = session;
        this.entityName = entityName;
        this.uninitializedFields = uninitializedFields;
    }

    public void setSession(SessionImplementor session) {
        this.session = session;
    }

    public boolean isInitialized() {
        return this.uninitializedFields == null || this.uninitializedFields.size() == 0;
    }

    public boolean isInitialized(String field) {
        return this.uninitializedFields == null || !this.uninitializedFields.contains(field);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Object intercept(Object target, String fieldName, Object value) {
        if (this.initializing) {
            return value;
        }
        if (this.uninitializedFields != null && this.uninitializedFields.contains(fieldName)) {
            Object result;
            if (this.session == null) {
                throw new LazyInitializationException("entity with lazy properties is not associated with a session");
            }
            if (!this.session.isOpen() || !this.session.isConnected()) {
                throw new LazyInitializationException("session is not connected");
            }
            this.initializing = true;
            try {
                result = ((LazyPropertyInitializer)((Object)this.session.getFactory().getEntityPersister(this.entityName))).initializeLazyProperty(fieldName, target, this.session);
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                this.initializing = false;
                throw throwable;
            }
            {
                Object var5_7 = null;
                this.initializing = false;
                this.uninitializedFields = null;
                return result;
            }
        }
        return value;
    }

    public boolean readBoolean(Object target, String name, boolean oldValue) {
        return (Boolean)this.intercept(target, name, oldValue ? Boolean.TRUE : Boolean.FALSE);
    }

    public byte readByte(Object target, String name, byte oldValue) {
        return (Byte)this.intercept(target, name, new Byte(oldValue));
    }

    public char readChar(Object target, String name, char oldValue) {
        return ((Character)this.intercept(target, name, new Character(oldValue))).charValue();
    }

    public double readDouble(Object target, String name, double oldValue) {
        return (Double)this.intercept(target, name, new Double(oldValue));
    }

    public float readFloat(Object target, String name, float oldValue) {
        return ((Float)this.intercept(target, name, new Float(oldValue))).floatValue();
    }

    public int readInt(Object target, String name, int oldValue) {
        return (Integer)this.intercept(target, name, new Integer(oldValue));
    }

    public long readLong(Object target, String name, long oldValue) {
        return (Long)this.intercept(target, name, new Long(oldValue));
    }

    public short readShort(Object target, String name, short oldValue) {
        return (Short)this.intercept(target, name, new Short(oldValue));
    }

    public Object readObject(Object target, String name, Object oldValue) {
        return this.intercept(target, name, oldValue);
    }

    public boolean writeBoolean(Object target, String name, boolean oldValue, boolean newValue) {
        this.intercept(target, name, oldValue ? Boolean.TRUE : Boolean.FALSE);
        return newValue;
    }

    public byte writeByte(Object target, String name, byte oldValue, byte newValue) {
        this.intercept(target, name, new Byte(oldValue));
        return newValue;
    }

    public char writeChar(Object target, String name, char oldValue, char newValue) {
        this.intercept(target, name, new Character(oldValue));
        return newValue;
    }

    public double writeDouble(Object target, String name, double oldValue, double newValue) {
        this.intercept(target, name, new Double(oldValue));
        return newValue;
    }

    public float writeFloat(Object target, String name, float oldValue, float newValue) {
        this.intercept(target, name, new Float(oldValue));
        return newValue;
    }

    public int writeInt(Object target, String name, int oldValue, int newValue) {
        this.intercept(target, name, new Integer(oldValue));
        return newValue;
    }

    public long writeLong(Object target, String name, long oldValue, long newValue) {
        this.intercept(target, name, new Long(oldValue));
        return newValue;
    }

    public short writeShort(Object target, String name, short oldValue, short newValue) {
        this.intercept(target, name, new Short(oldValue));
        return newValue;
    }

    public Object writeObject(Object target, String name, Object oldValue, Object newValue) {
        this.intercept(target, name, oldValue);
        return newValue;
    }

    public String toString() {
        return "FieldInterceptor for " + this.entityName + " unitializedFields=" + this.uninitializedFields;
    }
}

