/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.loader;

import java.io.Serializable;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.HibernateException;
import org.hibernate.MappingException;
import org.hibernate.collection.CollectionPersister;
import org.hibernate.collection.QueryableCollection;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.loader.CollectionInitializer;
import org.hibernate.loader.CollectionLoader;
import org.hibernate.loader.Loader;
import org.hibernate.loader.OneToManyLoader;
import org.hibernate.util.ArrayHelper;

public class BatchingCollectionInitializer
implements CollectionInitializer {
    private static final Log log = LogFactory.getLog((Class)(class$org$hibernate$loader$BatchingCollectionInitializer == null ? (class$org$hibernate$loader$BatchingCollectionInitializer = BatchingCollectionInitializer.class$("org.hibernate.loader.BatchingCollectionInitializer")) : class$org$hibernate$loader$BatchingCollectionInitializer));
    private final Loader[] loaders;
    private final int[] batchSizes;
    private final CollectionPersister collectionPersister;
    static /* synthetic */ Class class$org$hibernate$loader$BatchingCollectionInitializer;

    public BatchingCollectionInitializer(CollectionPersister collPersister, int[] batchSizes, Loader[] loaders) {
        this.loaders = loaders;
        this.batchSizes = batchSizes;
        this.collectionPersister = collPersister;
    }

    public void initialize(Serializable id, SessionImplementor session) throws HibernateException {
        Serializable[] batch = session.getCollectionBatch(this.collectionPersister, id, this.batchSizes[0]);
        for (int i = 0; i < this.batchSizes.length - 1; ++i) {
            int smallBatchSize = this.batchSizes[i];
            if (batch[smallBatchSize - 1] == null) continue;
            Serializable[] smallBatch = new Serializable[smallBatchSize];
            System.arraycopy(batch, 0, smallBatch, 0, smallBatchSize);
            this.loaders[i].loadCollectionBatch(session, smallBatch, this.collectionPersister.getKeyType());
            log.debug((Object)"done batch load");
            return;
        }
        this.loaders[this.batchSizes.length - 1].loadCollection(session, id, this.collectionPersister.getKeyType());
        log.debug((Object)"done unique load");
    }

    public static CollectionInitializer createBatchingOneToManyInitializer(QueryableCollection persister, int maxBatchSize, SessionFactoryImplementor factory, Map enabledFilters) throws MappingException {
        if (maxBatchSize > 1) {
            int[] batchSizesToCreate = ArrayHelper.getBatchSizes(maxBatchSize);
            Loader[] loadersToCreate = new Loader[batchSizesToCreate.length];
            for (int i = 0; i < batchSizesToCreate.length; ++i) {
                loadersToCreate[i] = new OneToManyLoader(persister, batchSizesToCreate[i], factory, enabledFilters);
            }
            return new BatchingCollectionInitializer(persister, batchSizesToCreate, loadersToCreate);
        }
        return new OneToManyLoader(persister, factory, enabledFilters);
    }

    public static CollectionInitializer createBatchingCollectionInitializer(QueryableCollection persister, int maxBatchSize, SessionFactoryImplementor factory, Map enabledFilters) throws MappingException {
        if (maxBatchSize > 1) {
            int[] batchSizesToCreate = ArrayHelper.getBatchSizes(maxBatchSize);
            Loader[] loadersToCreate = new Loader[batchSizesToCreate.length];
            for (int i = 0; i < batchSizesToCreate.length; ++i) {
                loadersToCreate[i] = new CollectionLoader(persister, batchSizesToCreate[i], factory, enabledFilters);
            }
            return new BatchingCollectionInitializer(persister, batchSizesToCreate, loadersToCreate);
        }
        return new CollectionLoader(persister, factory, enabledFilters);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

