/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.loader;

import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hibernate.FetchMode;
import org.hibernate.Hibernate;
import org.hibernate.HibernateException;
import org.hibernate.LockMode;
import org.hibernate.MappingException;
import org.hibernate.QueryException;
import org.hibernate.ScrollMode;
import org.hibernate.ScrollableResults;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.QueryParameters;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.impl.CriteriaImpl;
import org.hibernate.loader.AbstractEntityLoader;
import org.hibernate.loader.CriteriaQueryTranslator;
import org.hibernate.persister.Joinable;
import org.hibernate.persister.Loadable;
import org.hibernate.persister.OuterJoinLoadable;
import org.hibernate.persister.Queryable;
import org.hibernate.sql.ForUpdateFragment;
import org.hibernate.type.AssociationType;
import org.hibernate.type.Type;
import org.hibernate.util.ArrayHelper;

public class CriteriaLoader
extends AbstractEntityLoader {
    private final CriteriaQueryTranslator translator;
    private final Set querySpaces = new HashSet();
    private final Type[] resultTypes;
    private final String[] userAliases;
    private final List userAliasList = new ArrayList();

    public CriteriaLoader(OuterJoinLoadable persister, SessionFactoryImplementor factory, CriteriaImpl criteria, Map enabledFilters) throws HibernateException {
        super(persister, factory, enabledFilters);
        this.translator = new CriteriaQueryTranslator(persister, factory, criteria);
        this.addAllToPropertySpaces(persister.getQuerySpaces());
        this.resultTypes = new Type[1];
        this.resultTypes[0] = Hibernate.entity(persister.getEntityName());
        if (this.translator.hasProjection()) {
            this.initProjection(this.translator.getSelect(), this.translator.getWhereCondition(), this.translator.getOrderBy(), LockMode.NONE);
        } else {
            this.initAll(this.translator.getWhereCondition(), this.translator.getOrderBy(), LockMode.NONE);
        }
        this.userAliasList.add(criteria.getAlias());
        this.userAliases = ArrayHelper.toStringArray(this.userAliasList);
        this.postInstantiate();
    }

    public ScrollableResults scroll(SessionImplementor session, ScrollMode scrollMode) throws HibernateException {
        QueryParameters qp = this.translator.getQueryParameters();
        qp.setScrollMode(scrollMode);
        return this.scroll(qp, this.resultTypes, null, session);
    }

    public List list(SessionImplementor session) throws HibernateException {
        return this.list(session, this.translator.getQueryParameters(), this.querySpaces, this.resultTypes);
    }

    protected Object getResultColumnOrRow(Object[] row, ResultSet rs, SessionImplementor session) throws SQLException, HibernateException {
        if (this.translator.hasProjection()) {
            Type[] types = this.translator.getProjectedTypes();
            Object[] result = new Object[types.length];
            String[] columnAliases = this.translator.getProjectedColumnAliases();
            for (int i = 0; i < result.length; ++i) {
                result[i] = types[i].nullSafeGet(rs, columnAliases[i], session, null);
            }
            return this.translator.getCriteria().getResultTransformer().transformTuple(result, this.translator.getProjectedAliases());
        }
        return this.translator.getCriteria().getResultTransformer().transformTuple(row, this.userAliases);
    }

    protected int getJoinType(AssociationType type, FetchMode config, String path) throws MappingException {
        if (this.translator.getCriteria().isJoin(path)) {
            return 0;
        }
        FetchMode fm = this.translator.getCriteria().getFetchMode(path);
        if (fm == null || fm == FetchMode.DEFAULT) {
            return super.getJoinType(type, config, path);
        }
        return fm == FetchMode.JOIN ? 1 : -1;
    }

    protected String getWhereFragment() throws MappingException {
        return super.getWhereFragment() + ((Queryable)this.getPersister()).filterFragment(this.getAlias(), this.getEnabledFilters());
    }

    protected String generateTableAlias(int n, String path, Joinable joinable) {
        if (joinable.consumesAlias()) {
            String userDefinedAlias = this.translator.getCriteria().getAlias(path);
            if (userDefinedAlias != null) {
                this.userAliasList.add(userDefinedAlias);
                return this.translator.getSQLAlias(userDefinedAlias);
            }
            this.userAliasList.add(null);
        }
        return super.generateTableAlias(n, path, joinable);
    }

    protected String generateRootAlias(String tableName) {
        return "this_";
    }

    public Set getQuerySpaces() {
        return this.querySpaces;
    }

    protected void addToPropertySpaces(Serializable space) {
        this.querySpaces.add(space);
    }

    protected String applyLocks(String sqlSelectString, Map lockModes, Dialect dialect) throws QueryException {
        if (lockModes == null || lockModes.size() == 0) {
            return sqlSelectString;
        }
        HashMap<String, String[]> keyColumnNames = null;
        Loadable[] persisters = this.getEntityPersisters();
        String[] entityAliases = this.getEntityAliases();
        if (dialect.forUpdateOfColumns()) {
            keyColumnNames = new HashMap<String, String[]>();
            for (int i = 0; i < entityAliases.length; ++i) {
                keyColumnNames.put(entityAliases[i], persisters[i].getIdentifierColumnNames());
            }
        }
        return sqlSelectString + new ForUpdateFragment(dialect, lockModes, keyColumnNames).toFragmentString();
    }

    protected LockMode[] getLockModes(Map lockModes) {
        String[] entityAliases = this.getEntityAliases();
        if (entityAliases == null) {
            return null;
        }
        int size = entityAliases.length;
        LockMode[] lockModesArray = new LockMode[size];
        for (int i = 0; i < size; ++i) {
            LockMode lockMode = (LockMode)lockModes.get(entityAliases[i]);
            lockModesArray[i] = lockMode == null ? LockMode.NONE : lockMode;
        }
        return lockModesArray;
    }

    protected List getResultList(List results) {
        return this.translator.getCriteria().getResultTransformer().transformList(results);
    }

    public String getComment() {
        return null;
    }
}

