/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.loader;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hibernate.FetchMode;
import org.hibernate.LockMode;
import org.hibernate.MappingException;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.JoinHelper;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.loader.BasicLoader;
import org.hibernate.loader.OuterJoinableAssociation;
import org.hibernate.persister.collection.QueryableCollection;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.persister.entity.Joinable;
import org.hibernate.persister.entity.Loadable;
import org.hibernate.persister.entity.OuterJoinLoadable;
import org.hibernate.sql.ConditionFragment;
import org.hibernate.sql.DisjunctionFragment;
import org.hibernate.sql.InFragment;
import org.hibernate.sql.JoinFragment;
import org.hibernate.type.AbstractComponentType;
import org.hibernate.type.AssociationType;
import org.hibernate.type.EntityType;
import org.hibernate.type.ForeignKeyDirection;
import org.hibernate.type.Type;
import org.hibernate.util.ArrayHelper;
import org.hibernate.util.StringHelper;

public abstract class OuterJoinLoader
extends BasicLoader {
    protected Loadable[] persisters;
    protected LockMode[] lockModeArray;
    protected int[] owners;
    protected AssociationType[] ownerAssociationType;
    protected String sql;
    protected String[] suffixes;
    private Map enabledFilters;

    protected final Dialect getDialect() {
        return this.getFactory().getDialect();
    }

    public OuterJoinLoader(SessionFactoryImplementor factory, Map enabledFilters) {
        super(factory);
        this.enabledFilters = enabledFilters;
    }

    protected boolean isJoinedFetchEnabled(AssociationType type, FetchMode config) {
        return type.isEntityType() && this.isJoinedFetchEnabledInMapping(config, type);
    }

    protected boolean isDuplicateAssociation(Set visitedAssociationKeys, String lhsTable, String[] lhsColumnNames, AssociationType type) {
        String[] foreignKeyColumns;
        String foreignKeyTable;
        if (type.getForeignKeyDirection() == ForeignKeyDirection.FOREIGN_KEY_FROM_PARENT) {
            foreignKeyTable = lhsTable;
            foreignKeyColumns = lhsColumnNames;
        } else {
            foreignKeyTable = type.getAssociatedJoinable(this.getFactory()).getTableName();
            foreignKeyColumns = JoinHelper.getRHSColumnNames(type, this.getFactory());
        }
        return this.isDuplicateAssociation(visitedAssociationKeys, foreignKeyTable, foreignKeyColumns);
    }

    protected boolean isJoinable(int joinType, Set visitedAssociationKeys, String lhsTable, String[] lhsColumnNames, AssociationType type, int depth) {
        boolean tooDeep;
        if (joinType < 0) {
            return false;
        }
        if (joinType == 0) {
            return true;
        }
        Integer maxFetchDepth = this.getFactory().getSettings().getMaximumFetchDepth();
        boolean bl = tooDeep = maxFetchDepth != null && depth >= maxFetchDepth;
        return !tooDeep && !this.isDuplicateAssociation(visitedAssociationKeys, lhsTable, lhsColumnNames, type);
    }

    protected boolean isDuplicateAssociation(Set visitedAssociationKeys, String foreignKeyTable, String[] foreignKeyColumns) {
        return !visitedAssociationKeys.add(new AssociationKey(foreignKeyColumns, foreignKeyTable));
    }

    protected boolean isTooDeep(int currentDepth) {
        Integer maxFetchDepth = this.getFactory().getSettings().getMaximumFetchDepth();
        return maxFetchDepth != null && currentDepth >= maxFetchDepth;
    }

    protected int getJoinType(AssociationType type, FetchMode config, String path, Set visitedAssociations, String lhsTable, String[] lhsColumns, boolean nullable, int currentDepth) throws MappingException {
        if (!this.isJoinedFetchEnabled(type, config)) {
            return -1;
        }
        if (this.isTooDeep(currentDepth)) {
            return -1;
        }
        boolean dupe = this.isDuplicateAssociation(visitedAssociations, lhsTable, lhsColumns, type);
        if (dupe) {
            return -1;
        }
        return this.getJoinType(nullable, currentDepth);
    }

    protected int getJoinType(boolean nullable, int currentDepth) {
        return !nullable && currentDepth == 0 ? 0 : 1;
    }

    protected final List walkEntityTree(OuterJoinLoadable persister, String alias) throws MappingException {
        ArrayList associations = new ArrayList();
        this.walkEntityTree(persister, alias, associations, new HashSet(), "", 0);
        return associations;
    }

    protected final List walkCollectionTree(QueryableCollection persister, String alias) throws MappingException {
        return this.walkCollectionTree(persister, alias, new ArrayList(), new HashSet(), "", 0);
    }

    private final List walkCollectionTree(QueryableCollection persister, String alias, List associations, Set visitedAssociations, String path, int currentDepth) throws MappingException {
        if (persister.isOneToMany()) {
            this.walkEntityTree((OuterJoinLoadable)persister.getElementPersister(), alias, associations, visitedAssociations, path, currentDepth);
        } else {
            Type type = persister.getElementType();
            if (type.isAssociationType()) {
                AssociationType associationType = (AssociationType)type;
                String[] aliasedLhsColumns = persister.getElementColumnNames(alias);
                String[] lhsColumns = persister.getElementColumnNames();
                int joinType = this.getJoinType(associationType, persister.getFetchMode(), path, visitedAssociations, persister.getTableName(), lhsColumns, false, currentDepth);
                this.addAssociationToJoinTreeIfNecessary(associationType, aliasedLhsColumns, alias, associations, visitedAssociations, path, currentDepth, joinType);
            } else if (type.isComponentType()) {
                this.walkCompositeElementTree((AbstractComponentType)type, persister.getElementColumnNames(), persister, alias, associations, new HashSet(), path, currentDepth);
            }
        }
        return associations;
    }

    private final void walkEntityAssociationTree(AssociationType associationType, OuterJoinLoadable persister, int propertyNumber, String alias, List associations, Set visitedAssociations, String path, boolean nullable, int currentDepth) throws MappingException {
        String[] aliasedLhsColumns = JoinHelper.getAliasedLHSColumnNames(associationType, alias, propertyNumber, persister, this.getFactory());
        String[] lhsColumns = JoinHelper.getLHSColumnNames(associationType, propertyNumber, persister, this.getFactory());
        String lhsTable = JoinHelper.getLHSTableName(associationType, propertyNumber, persister);
        String subpath = OuterJoinLoader.subPath(path, persister.getSubclassPropertyName(propertyNumber));
        int joinType = this.getJoinType(associationType, persister.getFetchMode(propertyNumber), subpath, visitedAssociations, lhsTable, lhsColumns, nullable, currentDepth);
        this.addAssociationToJoinTreeIfNecessary(associationType, aliasedLhsColumns, alias, associations, visitedAssociations, subpath, currentDepth, joinType);
    }

    private final void walkEntityTree(OuterJoinLoadable persister, String alias, List associations, Set visitedAssociations, String path, int currentDepth) throws MappingException {
        int n = persister.countSubclassProperties();
        int i = 0;
        while (i < n) {
            Type type = persister.getSubclassPropertyType(i);
            if (type.isAssociationType()) {
                this.walkEntityAssociationTree((AssociationType)type, persister, i, alias, associations, visitedAssociations, path, persister.isSubclassPropertyNullable(i), currentDepth);
            } else if (type.isComponentType()) {
                this.walkComponentTree((AbstractComponentType)type, i, 0, persister, alias, associations, visitedAssociations, OuterJoinLoader.subPath(path, persister.getSubclassPropertyName(i)), currentDepth);
            }
            ++i;
        }
    }

    private void walkComponentTree(AbstractComponentType componentType, int propertyNumber, int begin, OuterJoinLoadable persister, String alias, List associations, Set visitedAssociations, String path, int currentDepth) throws MappingException {
        Type[] types = componentType.getSubtypes();
        String[] propertyNames = componentType.getPropertyNames();
        int i = 0;
        while (i < types.length) {
            if (types[i].isAssociationType()) {
                AssociationType associationType = (AssociationType)types[i];
                String[] aliasedLhsColumns = JoinHelper.getAliasedLHSColumnNames(associationType, alias, propertyNumber, begin, persister, this.getFactory());
                String[] lhsColumns = JoinHelper.getLHSColumnNames(associationType, propertyNumber, begin, persister, this.getFactory());
                String lhsTable = JoinHelper.getLHSTableName(associationType, propertyNumber, persister);
                String subpath = OuterJoinLoader.subPath(path, propertyNames[i]);
                boolean[] propertyNullability = componentType.getPropertyNullability();
                int joinType = this.getJoinType(associationType, componentType.getFetchMode(i), subpath, visitedAssociations, lhsTable, lhsColumns, propertyNullability == null || propertyNullability[i], currentDepth);
                this.addAssociationToJoinTreeIfNecessary(associationType, aliasedLhsColumns, alias, associations, visitedAssociations, subpath, currentDepth, joinType);
            } else if (types[i].isComponentType()) {
                String subpath = OuterJoinLoader.subPath(path, propertyNames[i]);
                this.walkComponentTree((AbstractComponentType)types[i], propertyNumber, begin, persister, alias, associations, visitedAssociations, subpath, currentDepth);
            }
            begin += types[i].getColumnSpan(this.getFactory());
            ++i;
        }
    }

    private void walkCompositeElementTree(AbstractComponentType compositeType, String[] cols, QueryableCollection persister, String alias, List associations, Set visitedAssociations, String path, int currentDepth) throws MappingException {
        Type[] types = compositeType.getSubtypes();
        String[] propertyNames = compositeType.getPropertyNames();
        int begin = 0;
        int i = 0;
        while (i < types.length) {
            int length = types[i].getColumnSpan(this.getFactory());
            String[] lhsColumns = ArrayHelper.slice(cols, begin, length);
            if (types[i].isAssociationType()) {
                AssociationType associationType = (AssociationType)types[i];
                String[] aliasedLhsColumns = StringHelper.qualify(alias, lhsColumns);
                String subpath = OuterJoinLoader.subPath(path, propertyNames[i]);
                boolean[] propertyNullability = compositeType.getPropertyNullability();
                int joinType = this.getJoinType(associationType, compositeType.getFetchMode(i), subpath, visitedAssociations, persister.getTableName(), lhsColumns, propertyNullability == null || propertyNullability[i], currentDepth);
                this.addAssociationToJoinTreeIfNecessary(associationType, aliasedLhsColumns, alias, associations, visitedAssociations, subpath, currentDepth, joinType);
            } else if (types[i].isComponentType()) {
                String subpath = OuterJoinLoader.subPath(path, propertyNames[i]);
                this.walkCompositeElementTree((AbstractComponentType)types[i], lhsColumns, persister, alias, associations, visitedAssociations, subpath, currentDepth);
            }
            begin += length;
            ++i;
        }
    }

    protected boolean isJoinedFetchEnabledInMapping(FetchMode config, AssociationType type) throws MappingException {
        if (!type.isEntityType() && !type.isCollectionType()) {
            return false;
        }
        if (config == FetchMode.JOIN) {
            return true;
        }
        if (config == FetchMode.SELECT) {
            return false;
        }
        if (type.isEntityType()) {
            EntityType entityType = (EntityType)type;
            EntityPersister persister = this.getFactory().getEntityPersister(entityType.getAssociatedEntityName());
            return !persister.hasProxy();
        }
        return false;
    }

    private void addAssociationToJoinTreeIfNecessary(AssociationType type, String[] aliasedLhsColumns, String alias, List associations, Set visitedAssociations, String path, int currentDepth, int joinType) throws MappingException {
        boolean isCartesianProduct;
        if (joinType < 0) {
            return;
        }
        boolean bl = isCartesianProduct = joinType != 0 && type.getAssociatedJoinable(this.getFactory()).isCollection() && OuterJoinLoader.containsCollectionPersister(associations);
        if (!isCartesianProduct) {
            this.addAssociationToJoinTree(type, aliasedLhsColumns, alias, associations, visitedAssociations, path, currentDepth, joinType);
        }
    }

    private void addAssociationToJoinTree(AssociationType type, String[] aliasedLhsColumns, String alias, List associations, Set visitedAssociations, String path, int currentDepth, int joinType) throws MappingException {
        Joinable joinable = type.getAssociatedJoinable(this.getFactory());
        String subalias = this.generateTableAlias(associations.size() + 1, path, joinable);
        OuterJoinableAssociation assoc = new OuterJoinableAssociation(type, alias, aliasedLhsColumns, subalias, joinType, this.getFactory(), this.enabledFilters);
        assoc.validateJoin(path);
        associations.add(assoc);
        int nextDepth = currentDepth + 1;
        if (!joinable.isCollection()) {
            if (joinable instanceof OuterJoinLoadable) {
                this.walkEntityTree((OuterJoinLoadable)joinable, subalias, associations, visitedAssociations, path, nextDepth);
            }
        } else if (joinable instanceof QueryableCollection) {
            this.walkCollectionTree((QueryableCollection)joinable, subalias, associations, visitedAssociations, path, nextDepth);
        }
    }

    protected final String selectString(List associations) throws MappingException {
        if (associations.size() == 0) {
            return "";
        }
        StringBuffer buf = new StringBuffer(associations.size() * 100).append(", ");
        int aliasCount = 0;
        int i = 0;
        while (i < associations.size()) {
            OuterJoinableAssociation join = (OuterJoinableAssociation)associations.get(i);
            Joinable joinable = join.getJoinable();
            String selectFragment = joinable.selectFragment(join.getRHSAlias(), this.getSuffixes()[aliasCount], join.getJoinType() == 1);
            buf.append(selectFragment);
            if (joinable.consumesAlias()) {
                ++aliasCount;
            }
            if (i < associations.size() - 1 && selectFragment.trim().length() > 0) {
                buf.append(", ");
            }
            ++i;
        }
        return buf.toString();
    }

    protected String[] getSuffixes() {
        return this.suffixes;
    }

    protected String generateTableAlias(int n, String path, Joinable joinable) {
        return StringHelper.generateAlias(joinable.getName(), n);
    }

    protected String generateRootAlias(String description) {
        return StringHelper.generateAlias(description, 0);
    }

    protected final JoinFragment mergeOuterJoins(List associations) throws MappingException {
        JoinFragment outerjoin = this.getDialect().createOuterJoinFragment();
        Iterator iter = associations.iterator();
        while (iter.hasNext()) {
            OuterJoinableAssociation oj = (OuterJoinableAssociation)iter.next();
            oj.addJoins(outerjoin);
        }
        return outerjoin;
    }

    protected static final int countEntityPersisters(List associations) throws MappingException {
        int result = 0;
        Iterator iter = associations.iterator();
        while (iter.hasNext()) {
            OuterJoinableAssociation oj = (OuterJoinableAssociation)iter.next();
            if (!oj.getJoinable().consumesAlias()) continue;
            ++result;
        }
        return result;
    }

    protected static boolean containsCollectionPersister(List associations) throws MappingException {
        Iterator iter = associations.iterator();
        while (iter.hasNext()) {
            OuterJoinableAssociation oj = (OuterJoinableAssociation)iter.next();
            if (!oj.getJoinable().isCollection()) continue;
            return true;
        }
        return false;
    }

    private static String subPath(String path, String property) {
        if (path == null || path.length() == 0) {
            return property;
        }
        return StringHelper.qualify(path, property);
    }

    protected StringBuffer whereString(String alias, String[] columnNames, int batchSize, String subquery) {
        if (columnNames.length == 1) {
            InFragment in = new InFragment().setColumn(alias, columnNames[0]);
            int i = 0;
            while (i < batchSize) {
                in.addValue("?");
                ++i;
            }
            return new StringBuffer(in.toFragmentString());
        }
        ConditionFragment byId = new ConditionFragment().setTableAlias(alias).setCondition(columnNames, "?");
        StringBuffer whereString = new StringBuffer();
        if (batchSize == 1) {
            whereString.append(byId.toFragmentString());
        } else {
            whereString.append('(');
            DisjunctionFragment df = new DisjunctionFragment();
            int i = 0;
            while (i < batchSize) {
                df.addCondition(byId);
                ++i;
            }
            whereString.append(df.toFragmentString());
            whereString.append(')');
        }
        return whereString;
    }

    protected final String getSQLString() {
        return this.sql;
    }

    protected final Loadable[] getEntityPersisters() {
        return this.persisters;
    }

    protected int[] getOwners() {
        return this.owners;
    }

    protected AssociationType[] getOwnerAssociationTypes() {
        return this.ownerAssociationType;
    }

    protected LockMode[] getLockModes(Map lockModes) {
        return this.lockModeArray;
    }

    public Map getEnabledFilters() {
        return this.enabledFilters;
    }

    private static final class AssociationKey {
        private String[] columns;
        private String table;

        AssociationKey(String[] columns, String table) {
            this.columns = columns;
            this.table = table;
        }

        public boolean equals(Object other) {
            AssociationKey that = (AssociationKey)other;
            return that.table.equals(this.table) && Arrays.equals(this.columns, that.columns);
        }

        public int hashCode() {
            return this.table.hashCode();
        }
    }
}

