/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.loader;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hibernate.HibernateException;
import org.hibernate.LockMode;
import org.hibernate.MappingException;
import org.hibernate.collection.QueryableCollection;
import org.hibernate.engine.SQLQueryCollectionReturn;
import org.hibernate.engine.SQLQueryJoinReturn;
import org.hibernate.engine.SQLQueryReturn;
import org.hibernate.engine.SQLQueryRootReturn;
import org.hibernate.engine.SQLQueryScalarReturn;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.persister.EntityPersister;
import org.hibernate.persister.SQLLoadable;
import org.hibernate.type.EntityType;
import org.hibernate.type.Type;

public class SQLQueryReturnProcessor {
    private SQLQueryReturn[] queryReturns;
    private SQLQueryScalarReturn[] scalarQueryReturns;
    private final List aliases = new ArrayList();
    private final List persisters = new ArrayList();
    private final List lockModes = new ArrayList();
    private final Map alias2Persister = new HashMap();
    private final Map alias2Return = new HashMap();
    private final Map alias2OwnerAlias = new HashMap();
    private final List scalarTypes = new ArrayList();
    private final List scalarColumnAliases = new ArrayList();
    private final SessionFactoryImplementor factory;
    private int collectionOwner;
    private String collectionOwnerAlias;
    private String collectionAlias;
    private QueryableCollection collectionPersister;
    private boolean isCollectionInitializer = false;

    private SessionFactoryImplementor getFactory() {
        return this.factory;
    }

    private SQLLoadable getSQLLoadable(String entityName) throws MappingException {
        EntityPersister persister = this.getFactory().getEntityPersister(entityName);
        if (!(persister instanceof SQLLoadable)) {
            throw new MappingException("class persister is not SQLLoadable: " + entityName);
        }
        return (SQLLoadable)persister;
    }

    public SQLQueryReturnProcessor(SQLQueryReturn[] queryReturns, SQLQueryScalarReturn[] scalarQueryReturns, SessionFactoryImplementor factory) {
        this.queryReturns = queryReturns;
        this.scalarQueryReturns = scalarQueryReturns;
        this.factory = factory;
    }

    public void process() {
        int i;
        for (i = 0; i < this.queryReturns.length; ++i) {
            this.alias2Return.put(this.queryReturns[i].getAlias(), this.queryReturns[i]);
            if (this.queryReturns[i] instanceof SQLQueryJoinReturn) {
                SQLQueryJoinReturn roleReturn = (SQLQueryJoinReturn)this.queryReturns[i];
                this.alias2OwnerAlias.put(roleReturn.getAlias(), roleReturn.getOwnerAlias());
                continue;
            }
            if (!(this.queryReturns[i] instanceof SQLQueryCollectionReturn)) continue;
            this.isCollectionInitializer = true;
        }
        for (i = 0; i < this.queryReturns.length; ++i) {
            this.processReturn(this.queryReturns[i]);
        }
        if (this.scalarQueryReturns != null) {
            for (i = 0; i < this.scalarQueryReturns.length; ++i) {
                this.processScalarReturn(this.scalarQueryReturns[i]);
            }
        }
    }

    private void processReturn(SQLQueryReturn rtn) {
        if (rtn instanceof SQLQueryRootReturn) {
            this.processRootReturn((SQLQueryRootReturn)rtn);
        } else if (rtn instanceof SQLQueryCollectionReturn) {
            this.processCollectionReturn((SQLQueryCollectionReturn)rtn);
        } else {
            this.processRoleReturn((SQLQueryJoinReturn)rtn);
        }
    }

    private void processScalarReturn(SQLQueryScalarReturn typeReturn) {
        this.scalarColumnAliases.add(typeReturn.getColumnAlias());
        this.scalarTypes.add(typeReturn.getType());
    }

    private void processRootReturn(SQLQueryRootReturn rootReturn) {
        if (this.alias2Persister.containsKey(rootReturn.getAlias())) {
            return;
        }
        SQLLoadable persister = this.getSQLLoadable(rootReturn.getReturnEntityName());
        this.aliases.add(rootReturn.getAlias());
        this.persisters.add(persister);
        this.alias2Persister.put(rootReturn.getAlias(), persister);
        this.lockModes.add(rootReturn.getLockMode());
    }

    private void addCollection(String role, String alias, LockMode lockMode) {
        this.collectionPersister = (QueryableCollection)this.getFactory().getCollectionPersister(role);
        this.collectionAlias = alias;
        if (this.collectionPersister.isOneToMany()) {
            SQLLoadable persister = (SQLLoadable)this.collectionPersister.getElementPersister();
            this.aliases.add(alias);
            this.persisters.add(persister);
            this.lockModes.add(lockMode);
            this.alias2Persister.put(alias, persister);
        }
    }

    private void processCollectionReturn(SQLQueryCollectionReturn collectionReturn) {
        this.collectionOwner = -1;
        String role = collectionReturn.getOwnerEntityName() + '.' + collectionReturn.getOwnerProperty();
        this.addCollection(role, collectionReturn.getAlias(), collectionReturn.getLockMode());
    }

    private void processRoleReturn(SQLQueryJoinReturn roleReturn) {
        SQLLoadable ownerPersister;
        Type returnType;
        if (this.alias2Persister.containsKey(roleReturn.getAlias()) || roleReturn.getAlias().equals(this.collectionAlias)) {
            return;
        }
        String ownerAlias = roleReturn.getOwnerAlias();
        if (!this.alias2Return.containsKey(ownerAlias)) {
            throw new HibernateException("Owner alias [" + ownerAlias + "] is unknown for alias [" + roleReturn.getAlias() + "]");
        }
        if (!this.alias2Persister.containsKey(ownerAlias)) {
            SQLQueryReturn ownerReturn = (SQLQueryReturn)this.alias2Return.get(ownerAlias);
            this.processReturn(ownerReturn);
        }
        if ((returnType = (ownerPersister = (SQLLoadable)this.alias2Persister.get(ownerAlias)).getPropertyType(roleReturn.getOwnerProperty())).isPersistentCollectionType()) {
            if (this.isCollectionInitializer) {
                throw new HibernateException("A sql query cannot name both a collection to be initialized and a collection to be fetched");
            }
            if (this.collectionAlias != null) {
                throw new HibernateException("Only one colection role return can be specified per sql-query");
            }
            String role = ownerPersister.getEntityName() + '.' + roleReturn.getOwnerProperty();
            this.addCollection(role, roleReturn.getAlias(), roleReturn.getLockMode());
            this.collectionOwnerAlias = ownerAlias;
        } else if (returnType.isEntityType()) {
            EntityType eType = (EntityType)returnType;
            String returnEntityName = eType.getAssociatedEntityName();
            SQLLoadable persister = this.getSQLLoadable(returnEntityName);
            this.aliases.add(roleReturn.getAlias());
            this.persisters.add(persister);
            this.lockModes.add(roleReturn.getLockMode());
            this.alias2Persister.put(roleReturn.getAlias(), persister);
        }
    }

    public String getCollectionAlias() {
        return this.collectionAlias;
    }

    public int getCollectionOwner() {
        return this.collectionOwner;
    }

    public String getCollectionOwnerAlias() {
        return this.collectionOwnerAlias;
    }

    public QueryableCollection getCollectionPersister() {
        return this.collectionPersister;
    }

    public Map getAlias2Persister() {
        return this.alias2Persister;
    }

    public List getAliases() {
        return this.aliases;
    }

    public boolean isCollectionInitializer() {
        return this.isCollectionInitializer;
    }

    public List getLockModes() {
        return this.lockModes;
    }

    public List getPersisters() {
        return this.persisters;
    }

    public Map getAlias2OwnerAlias() {
        return this.alias2OwnerAlias;
    }

    public List getScalarTypes() {
        return this.scalarTypes;
    }

    public List getScalarColumnAliases() {
        return this.scalarColumnAliases;
    }
}

