/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.loader.collection;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.HibernateException;
import org.hibernate.LockMode;
import org.hibernate.MappingException;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.loader.BasicLoader;
import org.hibernate.loader.OuterJoinLoader;
import org.hibernate.loader.OuterJoinableAssociation;
import org.hibernate.loader.collection.CollectionInitializer;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.persister.collection.QueryableCollection;
import org.hibernate.persister.entity.Loadable;
import org.hibernate.persister.entity.OuterJoinLoadable;
import org.hibernate.sql.JoinFragment;
import org.hibernate.sql.Select;
import org.hibernate.type.AssociationType;
import org.hibernate.type.Type;
import org.hibernate.util.ArrayHelper;

public class OneToManyLoader
extends OuterJoinLoader
implements CollectionInitializer {
    private static final Log log;
    private final QueryableCollection collectionPersister;
    private final Type keyType;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.hibernate.loader.collection.OneToManyLoader");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LogFactory.getLog((Class)clazz);
    }

    protected boolean isDuplicateAssociation(Set visitedAssociationKeys, String foreignKeyTable, String[] foreignKeyColumns) {
        boolean isSameJoin;
        boolean bl = isSameJoin = this.collectionPersister.getTableName().equals(foreignKeyTable) && Arrays.equals(foreignKeyColumns, this.collectionPersister.getKeyColumnNames());
        return isSameJoin || super.isDuplicateAssociation(visitedAssociationKeys, foreignKeyTable, foreignKeyColumns);
    }

    public OneToManyLoader(QueryableCollection collPersister, SessionFactoryImplementor session, Map enabledFilters) throws MappingException {
        this(collPersister, 1, session, enabledFilters);
    }

    public OneToManyLoader(QueryableCollection collPersister, int batchSize, SessionFactoryImplementor factory, Map enabledFilters) throws MappingException {
        this(collPersister, batchSize, null, factory, enabledFilters);
    }

    public OneToManyLoader(QueryableCollection collPersister, int batchSize, String subquery, SessionFactoryImplementor factory, Map enabledFilters) throws MappingException {
        super(factory, enabledFilters);
        this.collectionPersister = collPersister;
        this.keyType = collPersister.getKeyType();
        OuterJoinLoadable persister = (OuterJoinLoadable)collPersister.getElementPersister();
        String alias = this.generateRootAlias(collPersister.getRole());
        List associations = this.walkEntityTree(persister, alias);
        this.initPersisters(persister, associations);
        this.initStatementString(collPersister, persister, alias, associations, batchSize, subquery);
        this.postInstantiate();
        log.debug((Object)("Static select for one-to-many " + collPersister.getRole() + ": " + this.getSQLString()));
    }

    protected CollectionPersister getCollectionPersister() {
        return this.collectionPersister;
    }

    public void initialize(Serializable id, SessionImplementor session) throws HibernateException {
        this.loadCollection(session, id, this.keyType);
    }

    private void initPersisters(OuterJoinLoadable persister, List associations) throws MappingException {
        int joins = associations.size();
        this.lockModeArray = ArrayHelper.fillArray(LockMode.NONE, joins + 1);
        this.persisters = new Loadable[joins + 1];
        this.owners = new int[joins + 1];
        this.ownerAssociationType = new AssociationType[joins + 1];
        int i = 0;
        while (i < joins) {
            OuterJoinableAssociation oj = (OuterJoinableAssociation)associations.get(i);
            this.persisters[i] = (Loadable)((Object)oj.getJoinable());
            this.owners[i] = oj.getOwner(associations);
            this.ownerAssociationType[i] = oj.getJoinableType();
            ++i;
        }
        this.persisters[joins] = persister;
        this.owners[joins] = -1;
        if (ArrayHelper.isAllNegative(this.owners)) {
            this.owners = null;
        }
    }

    private void initStatementString(QueryableCollection collPersister, OuterJoinLoadable persister, String alias, List associations, int batchSize, String subquery) throws MappingException {
        int joins = associations.size();
        this.suffixes = BasicLoader.generateSuffixes(joins + 1);
        StringBuffer whereString = this.whereString(alias, collPersister.getKeyColumnNames(), batchSize, subquery);
        String filter = collPersister.filterFragment(alias, this.getEnabledFilters());
        if (filter.trim().length() > 0) {
            filter = String.valueOf(filter) + " and ";
        }
        if (filter.startsWith(" and ")) {
            filter = filter.substring(4);
        }
        whereString.insert(0, filter);
        JoinFragment ojf = this.mergeOuterJoins(associations);
        Select select = new Select(this.getDialect()).setSelectClause(String.valueOf(collPersister.selectFragment(alias, this.suffixes[joins], true)) + this.selectString(associations)).setFromClause(String.valueOf(persister.fromTableFragment(alias)) + persister.fromJoinFragment(alias, true, true)).setWhereClause(whereString.toString()).setOuterJoins(ojf.toFromFragmentString(), String.valueOf(ojf.toWhereFragmentString()) + persister.whereJoinFragment(alias, true, true));
        if (collPersister.hasOrdering()) {
            select.setOrderByClause(collPersister.getSQLOrderByString(alias));
        }
        if (this.getFactory().getSettings().isCommentsEnabled()) {
            select.setComment("load one-to-many " + collPersister.getRole());
        }
        this.sql = select.toStatementString();
    }

    protected Type getKeyType() {
        return this.keyType;
    }

    public String toString() {
        return String.valueOf(this.getClass().getName()) + '(' + this.collectionPersister.getRole() + ')';
    }
}

