/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.loader.custom;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hibernate.QueryException;
import org.hibernate.persister.collection.QueryableCollection;
import org.hibernate.persister.entity.SQLLoadable;
import org.hibernate.util.StringHelper;

public class SQLQueryParser {
    private final String sqlQuery;
    private final Map alias2Persister;
    private final String[] aliases;
    private final String collectionAlias;
    private final QueryableCollection collectionPersister;
    private final String[] suffixes;
    private int parameterCount = 0;
    private final Map namedParameters = new HashMap();

    public SQLQueryParser(String sqlQuery, Map alias2Persister, String[] aliases, String collectionAlias, QueryableCollection collectionPersister, String[] suffixes) {
        this.sqlQuery = sqlQuery;
        this.alias2Persister = alias2Persister;
        this.collectionAlias = collectionAlias;
        this.collectionPersister = collectionPersister;
        this.suffixes = suffixes;
        this.aliases = aliases;
    }

    private SQLLoadable getPersisterByResultAlias(String aliasName) {
        return (SQLLoadable)this.alias2Persister.get(aliasName);
    }

    private boolean isEntityAlias(String aliasName) {
        return this.alias2Persister.containsKey(aliasName);
    }

    public int getPersisterIndex(String aliasName) {
        int i = 0;
        while (i < this.aliases.length) {
            if (aliasName.equals(this.aliases[i])) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public String process() {
        return this.substituteParams(this.substituteBrackets());
    }

    private String substituteBrackets() throws QueryException {
        StringBuffer result = new StringBuffer(this.sqlQuery.length() + 20);
        int curr = 0;
        while (curr < this.sqlQuery.length()) {
            int left = this.sqlQuery.indexOf(123, curr);
            if (left < 0) {
                result.append(this.sqlQuery.substring(curr));
                break;
            }
            result.append(this.sqlQuery.substring(curr, left));
            int right = this.sqlQuery.indexOf(125, left + 1);
            if (right < 0) {
                throw new QueryException("Unmatched braces for alias path", this.sqlQuery);
            }
            String aliasPath = this.sqlQuery.substring(left + 1, right);
            int firstDot = aliasPath.indexOf(46);
            if (firstDot == -1) {
                if (this.isEntityAlias(aliasPath)) {
                    result.append(aliasPath);
                } else {
                    result.append('{').append(aliasPath).append('}');
                }
            } else {
                String aliasName = aliasPath.substring(0, firstDot);
                boolean isCollection = aliasName.equals(this.collectionAlias);
                boolean isEntity = this.isEntityAlias(aliasName);
                if (isCollection) {
                    result.append(this.collectionPersister.selectFragment(aliasName));
                    if (isEntity) {
                        result.append(", ");
                    }
                }
                if (isEntity) {
                    String propertyName = aliasPath.substring(firstDot + 1);
                    this.resolveProperties(aliasName, propertyName, result, this.getPersisterByResultAlias(aliasName));
                }
                if (!isEntity && !isCollection) {
                    result.append('{').append(aliasPath).append('}');
                }
            }
            curr = right + 1;
        }
        return result.toString();
    }

    private void resolveProperties(String aliasName, String propertyName, StringBuffer result, SQLLoadable currentPersister) {
        int currentPersisterIndex = this.getPersisterIndex(aliasName);
        if (!aliasName.equals(this.aliases[currentPersisterIndex])) {
            throw new QueryException("Alias [" + aliasName + "] does not correspond to return alias " + this.aliases[currentPersisterIndex], this.sqlQuery);
        }
        if ("*".equals(propertyName)) {
            result.append(currentPersister.selectFragment(aliasName, this.suffixes[currentPersisterIndex]));
        } else {
            String[] columnAliases = currentPersister.getSubclassPropertyColumnAliases(propertyName, this.suffixes[currentPersisterIndex]);
            if (columnAliases == null || columnAliases.length == 0) {
                throw new QueryException("No column name found for property [" + propertyName + "]", this.sqlQuery);
            }
            if (columnAliases.length != 1) {
                throw new QueryException("SQL queries only support properties mapped to a single column - property [" + propertyName + "] is mapped to " + columnAliases.length + " columns.", this.sqlQuery);
            }
            result.append(columnAliases[0]);
        }
    }

    private String substituteParams(String sqlString) {
        StringBuffer result = new StringBuffer(sqlString.length());
        int curr = 0;
        while (curr < sqlString.length()) {
            int left = sqlString.indexOf(":", curr);
            if (left < 0) {
                result.append(sqlString.substring(curr));
                break;
            }
            result.append(sqlString.substring(curr, left));
            int right = StringHelper.firstIndexOfChar(sqlString, " \n\r\f\t,()=<>&|+-=/*'^![]#~\\", left + 1);
            boolean foundSeperator = right > 0;
            int chopLocation = -1;
            chopLocation = right < 0 ? sqlString.length() : right;
            String param = sqlString.substring(left + 1, chopLocation);
            this.addNamedParameter(param);
            result.append("?");
            if (!foundSeperator) break;
            result.append(sqlString.charAt(right));
            curr = right + 1;
        }
        return result.toString();
    }

    private void addNamedParameter(String name) {
        Integer loc = new Integer(this.parameterCount++);
        Object o = this.namedParameters.get(name);
        if (o == null) {
            this.namedParameters.put(name, loc);
        } else if (o instanceof Integer) {
            ArrayList<Object> list = new ArrayList<Object>(4);
            list.add(o);
            list.add(loc);
            this.namedParameters.put(name, list);
        } else {
            ((List)o).add(loc);
        }
    }

    public Map getNamedParameters() {
        return this.namedParameters;
    }
}

