/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.loader.hql;

import java.lang.reflect.Constructor;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.HibernateException;
import org.hibernate.LockMode;
import org.hibernate.QueryException;
import org.hibernate.ScrollableResults;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.QueryParameters;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.engine.TypedValue;
import org.hibernate.exception.JDBCExceptionHelper;
import org.hibernate.hql.QueryTranslator;
import org.hibernate.hql.ast.FromElement;
import org.hibernate.hql.ast.SelectClause;
import org.hibernate.impl.IteratorImpl;
import org.hibernate.loader.BasicLoader;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.persister.collection.QueryableCollection;
import org.hibernate.persister.entity.Loadable;
import org.hibernate.persister.entity.Queryable;
import org.hibernate.sql.ForUpdateFragment;
import org.hibernate.type.AssociationType;
import org.hibernate.type.EntityType;
import org.hibernate.type.Type;
import org.hibernate.util.ArrayHelper;

public class QueryLoader
extends BasicLoader {
    private static final Log log;
    private QueryTranslator queryTranslator;
    private Queryable[] entityPersisters;
    private String[] entityAliases;
    private String[] sqlAliases;
    private String[] sqlAliasSuffixes;
    private boolean[] includeInSelect;
    private boolean hasScalars;
    private String[][] scalarColumnNames;
    private Type[] queryReturnTypes;
    private final Map sqlAliasByEntityAlias = new HashMap(8);
    private AssociationType[] ownerAssociationTypes;
    private int[] owners;
    private int collectionOwner = -1;
    private QueryableCollection collectionPersister;
    private int selectLength;
    private Constructor holderConstructor;
    private LockMode[] defaultLockModes;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.hibernate.loader.hql.QueryLoader");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LogFactory.getLog((Class)clazz);
    }

    public QueryLoader(QueryTranslator queryTranslator, SessionFactoryImplementor factory, SelectClause selectClause) {
        super(factory);
        this.queryTranslator = queryTranslator;
        this.initialize(selectClause);
        this.postInstantiate();
    }

    private void initialize(SelectClause selectClause) {
        List fromElementList = selectClause.getFromElementsForLoad();
        this.hasScalars = selectClause.isScalarSelect();
        this.scalarColumnNames = selectClause.getColumnNames();
        this.queryReturnTypes = selectClause.getQueryReturnTypes();
        this.holderConstructor = selectClause.getConstructor();
        FromElement collectionFromElement = selectClause.getCollectionFromElement();
        if (collectionFromElement != null) {
            this.collectionPersister = collectionFromElement.getQueryableCollection();
            this.collectionOwner = fromElementList.indexOf(collectionFromElement.getOrigin());
        }
        int size = fromElementList.size();
        this.entityPersisters = new Queryable[size];
        this.entityAliases = new String[size];
        this.sqlAliases = new String[size];
        this.sqlAliasSuffixes = new String[size];
        this.includeInSelect = new boolean[size];
        this.owners = new int[size];
        this.ownerAssociationTypes = new AssociationType[size];
        int i = 0;
        while (i < size) {
            FromElement element = (FromElement)fromElementList.get(i);
            this.entityPersisters[i] = (Queryable)element.getEntityPersister();
            if (this.entityPersisters[i] == null) {
                throw new IllegalStateException("No entity persister for " + element.toString());
            }
            this.sqlAliases[i] = element.getTableAlias();
            this.entityAliases[i] = element.getClassAlias();
            this.sqlAliasByEntityAlias.put(this.entityAliases[i], this.sqlAliases[i]);
            this.sqlAliasSuffixes[i] = size == 1 ? "" : String.valueOf(Integer.toString(i)) + "_";
            boolean bl = this.includeInSelect[i] = !element.isFetch();
            if (this.includeInSelect[i]) {
                ++this.selectLength;
            }
            this.owners[i] = -1;
            if (element.isFetch() && !element.isCollectionJoin() && element.getQueryableCollection() == null && element.getDataType().isEntityType()) {
                EntityType entityType = (EntityType)element.getDataType();
                if (entityType.isOneToOne()) {
                    this.owners[i] = fromElementList.indexOf(element.getOrigin());
                }
                this.ownerAssociationTypes[i] = entityType;
            }
            ++i;
        }
        this.defaultLockModes = ArrayHelper.fillArray(LockMode.NONE, size);
    }

    public Loadable[] getEntityPersisters() {
        return this.entityPersisters;
    }

    public String[] getAliases() {
        return this.entityAliases;
    }

    public String[] getSqlAliasSuffixes() {
        return this.sqlAliasSuffixes;
    }

    public String[] getSuffixes() {
        return this.getSqlAliasSuffixes();
    }

    protected String getQueryIdentifier() {
        return this.queryTranslator.getQueryString();
    }

    protected String getSQLString() {
        return this.queryTranslator.getSQLString();
    }

    protected CollectionPersister getCollectionPersister() {
        return this.collectionPersister;
    }

    protected int getCollectionOwner() {
        return this.collectionOwner;
    }

    protected int[] getOwners() {
        return this.owners;
    }

    protected AssociationType[] getOwnerAssociationTypes() {
        return this.ownerAssociationTypes;
    }

    protected int bindNamedParameters(PreparedStatement ps, Map namedParams, int start, SessionImplementor session) throws SQLException, HibernateException {
        if (namedParams != null) {
            Iterator iter = namedParams.entrySet().iterator();
            int result = 0;
            while (iter.hasNext()) {
                Map.Entry e = iter.next();
                String name = (String)e.getKey();
                TypedValue typedval = (TypedValue)e.getValue();
                int[] locs = this.getNamedParameterLocs(name);
                int i = 0;
                while (i < locs.length) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("bindNamedParameters() " + typedval.getValue() + " -> " + name + " [" + (locs[i] + start) + "]"));
                    }
                    typedval.getType().nullSafeSet(ps, typedval.getValue(), locs[i] + start, session);
                    ++i;
                }
                result += locs.length;
            }
            return result;
        }
        return 0;
    }

    protected LockMode[] getLockModes(Map lockModes) {
        if (lockModes == null || lockModes.size() == 0) {
            return this.defaultLockModes;
        }
        LockMode[] lockModeArray = new LockMode[this.entityAliases.length];
        int i = 0;
        while (i < this.entityAliases.length) {
            LockMode lockMode = (LockMode)lockModes.get(this.entityAliases[i]);
            if (lockMode == null) {
                lockMode = LockMode.NONE;
            }
            lockModeArray[i] = lockMode;
            ++i;
        }
        return lockModeArray;
    }

    protected String applyLocks(String sql, Map lockModes, Dialect dialect) throws QueryException {
        if (lockModes == null || lockModes.size() == 0) {
            return sql;
        }
        HashMap aliasedLockModes = new HashMap();
        Iterator iter = lockModes.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry me = iter.next();
            String userAlias = (String)me.getKey();
            String sqlAlias = (String)this.sqlAliasByEntityAlias.get(userAlias);
            aliasedLockModes.put(sqlAlias, me.getValue());
        }
        HashMap<String, String[]> keyColumnNames = null;
        if (dialect.forUpdateOfColumns()) {
            Loadable[] persisters = this.getEntityPersisters();
            keyColumnNames = new HashMap<String, String[]>();
            int i = 0;
            while (i < this.sqlAliases.length) {
                keyColumnNames.put(this.sqlAliases[i], persisters[i].getIdentifierColumnNames());
                ++i;
            }
        }
        return String.valueOf(sql) + new ForUpdateFragment(dialect, aliasedLockModes, keyColumnNames).toFragmentString();
    }

    protected boolean upgradeLocks() {
        return true;
    }

    protected Object getResultColumnOrRow(Object[] row, ResultSet rs, SessionImplementor session) throws SQLException, HibernateException {
        row = this.toResultRow(row);
        if (this.hasScalars) {
            String[][] scalarColumns = this.scalarColumnNames;
            int queryCols = this.queryReturnTypes.length;
            if (this.holderConstructor == null && queryCols == 1) {
                return this.queryReturnTypes[0].nullSafeGet(rs, scalarColumns[0], session, null);
            }
            row = new Object[queryCols];
            int i = 0;
            while (i < queryCols) {
                row[i] = this.queryReturnTypes[i].nullSafeGet(rs, scalarColumns[i], session, null);
                ++i;
            }
            return row;
        }
        if (this.holderConstructor == null) {
            return row.length == 1 ? row[0] : row;
        }
        return row;
    }

    protected List getResultList(List results) throws QueryException {
        if (this.holderConstructor != null) {
            int i = 0;
            while (i < results.size()) {
                Object[] row = (Object[])results.get(i);
                try {
                    results.set(i, this.holderConstructor.newInstance(row));
                }
                catch (Exception e) {
                    throw new QueryException("could not instantiate: " + this.holderConstructor.getDeclaringClass().getName(), e);
                }
                ++i;
            }
        }
        return results;
    }

    public List list(SessionImplementor session, QueryParameters queryParameters) throws HibernateException {
        return this.list(session, queryParameters, this.queryTranslator.getQuerySpaces(), this.queryReturnTypes);
    }

    public Iterator iterate(QueryParameters queryParameters, SessionImplementor session) throws HibernateException {
        boolean stats = session.getFactory().getStatistics().isStatisticsEnabled();
        long startTime = 0L;
        if (stats) {
            startTime = System.currentTimeMillis();
        }
        try {
            PreparedStatement st = this.prepareQueryStatement(queryParameters, false, session);
            ResultSet rs = this.getResultSet(st, queryParameters.getRowSelection(), session);
            IteratorImpl result = new IteratorImpl(rs, st, session, this.queryReturnTypes, this.queryTranslator.getColumnNames(), this.holderConstructor == null ? null : this.holderConstructor.getDeclaringClass());
            if (stats) {
                session.getFactory().getStatisticsImplementor().queryExecuted("HQL: " + this.queryTranslator.getQueryString(), 0, System.currentTimeMillis() - startTime);
            }
            return result;
        }
        catch (SQLException sqle) {
            throw JDBCExceptionHelper.convert(this.getFactory().getSQLExceptionConverter(), sqle, "could not execute query using iterate", this.getSQLString());
        }
    }

    public ScrollableResults scroll(QueryParameters queryParameters, SessionImplementor session) throws HibernateException {
        return this.scroll(queryParameters, this.queryReturnTypes, null, session);
    }

    private Object[] toResultRow(Object[] row) {
        if (this.selectLength == row.length) {
            return row;
        }
        Object[] result = new Object[this.selectLength];
        int j = 0;
        int i = 0;
        while (i < row.length) {
            if (this.includeInSelect[i]) {
                result[j++] = row[i];
            }
            ++i;
        }
        return result;
    }

    private int[] getNamedParameterLocs(String name) throws QueryException {
        return this.queryTranslator.getNamedParameterLocs(name);
    }
}

