/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.persister;

import java.util.HashMap;
import java.util.Map;
import org.hibernate.MappingException;
import org.hibernate.QueryException;
import org.hibernate.engine.Mapping;
import org.hibernate.persister.PropertyMapping;
import org.hibernate.type.AbstractComponentType;
import org.hibernate.type.AssociationType;
import org.hibernate.type.EntityType;
import org.hibernate.type.Type;
import org.hibernate.util.ArrayHelper;
import org.hibernate.util.StringHelper;

public abstract class AbstractPropertyMapping
implements PropertyMapping {
    private final Map typesByPropertyPath = new HashMap();
    private final Map columnsByPropertyPath = new HashMap();
    private final Map formulaTemplatesByPropertyPath = new HashMap();

    public String[] getIdentifierColumnNames() {
        throw new UnsupportedOperationException("one-to-one is not supported here");
    }

    protected abstract String getEntityName();

    public Type toType(String propertyName) throws QueryException {
        Type type = (Type)this.typesByPropertyPath.get(propertyName);
        if (type == null) {
            this.throwPropertyException(propertyName);
        }
        return type;
    }

    protected final void throwPropertyException(String propertyName) throws QueryException {
        throw new QueryException("could not resolve property: " + propertyName + " of: " + this.getEntityName());
    }

    public String[] getColumnNames(String propertyName) {
        String[] cols = (String[])this.columnsByPropertyPath.get(propertyName);
        if (cols == null) {
            throw new MappingException("unknown property: " + propertyName);
        }
        return cols;
    }

    public String[] toColumns(String alias, String propertyName) throws QueryException {
        String[] columns = (String[])this.columnsByPropertyPath.get(propertyName);
        if (columns == null) {
            this.throwPropertyException(propertyName);
        }
        String[] templates = (String[])this.formulaTemplatesByPropertyPath.get(propertyName);
        String[] result = new String[columns.length];
        for (int i = 0; i < columns.length; ++i) {
            result[i] = columns[i] == null ? StringHelper.replace(templates[i], "$PlaceHolder$", alias) : StringHelper.qualify(alias, columns[i]);
        }
        return result;
    }

    protected void addPropertyPath(String path, Type type, String[] columns) {
        this.typesByPropertyPath.put(path, type);
        this.columnsByPropertyPath.put(path, columns);
    }

    protected void addFormulaPropertyPath(String path, Type type, String[] templates) {
        this.typesByPropertyPath.put(path, type);
        this.formulaTemplatesByPropertyPath.put(path, templates);
    }

    protected void initPropertyPaths(String path, Type type, String[] columns, String[] formulaTemplates, Mapping factory) throws MappingException {
        this.addFormulaPropertyPath(path, type, formulaTemplates);
        this.initPropertyPaths(path, type, columns, factory);
    }

    protected void initPropertyPaths(String path, Type type, String[] columns, Mapping factory) throws MappingException {
        if (columns.length != type.getColumnSpan(factory)) {
            throw new MappingException("broken column mapping for: " + path + " of: " + this.getEntityName());
        }
        if (type.isAssociationType()) {
            AssociationType actype = (AssociationType)type;
            if (actype.useLHSPrimaryKey()) {
                columns = this.getIdentifierColumnNames();
            } else {
                String foreignKeyProperty = actype.getLHSPropertyName();
                if (foreignKeyProperty != null && (columns = (String[])this.columnsByPropertyPath.get(foreignKeyProperty)) == null) {
                    return;
                }
            }
        }
        if (path != null) {
            this.addPropertyPath(path, type, columns);
        }
        if (type.isComponentType()) {
            this.initComponentPropertyPaths(path, (AbstractComponentType)type, columns, factory);
        } else if (type.isEntityType()) {
            this.initIdentifierPropertyPaths(path, (EntityType)type, columns, factory);
        }
    }

    protected void initIdentifierPropertyPaths(String path, EntityType etype, String[] columns, Mapping factory) throws MappingException {
        String idPropName;
        Type idtype = etype.getIdentifierOrUniqueKeyType(factory);
        if (etype.isReferenceToPrimaryKey()) {
            String idpath1 = AbstractPropertyMapping.extendPath(path, "id");
            this.addPropertyPath(idpath1, idtype, columns);
            this.initPropertyPaths(idpath1, idtype, columns, factory);
        }
        if ((idPropName = etype.getIdentifierOrUniqueKeyPropertyName(factory)) != null) {
            String idpath2 = AbstractPropertyMapping.extendPath(path, idPropName);
            this.addPropertyPath(idpath2, idtype, columns);
            this.initPropertyPaths(idpath2, idtype, columns, factory);
        }
    }

    protected void initComponentPropertyPaths(String path, AbstractComponentType type, String[] columns, Mapping factory) throws MappingException {
        Type[] types = type.getSubtypes();
        String[] properties = type.getPropertyNames();
        int begin = 0;
        for (int i = 0; i < properties.length; ++i) {
            String subpath = AbstractPropertyMapping.extendPath(path, properties[i]);
            try {
                int length = types[i].getColumnSpan(factory);
                String[] columnSlice = ArrayHelper.slice(columns, begin, length);
                this.initPropertyPaths(subpath, types[i], columnSlice, factory);
                begin += length;
                continue;
            }
            catch (Exception e) {
                throw new MappingException("bug in initComponentPropertyPaths", e);
            }
        }
    }

    private static String extendPath(String path, String property) {
        if (path == null) {
            return property;
        }
        return StringHelper.qualify(path, property);
    }
}

