/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.persister;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.hibernate.HibernateException;
import org.hibernate.MappingException;
import org.hibernate.cache.CacheConcurrencyStrategy;
import org.hibernate.engine.Mapping;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.Formula;
import org.hibernate.mapping.Join;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.Selectable;
import org.hibernate.mapping.Subclass;
import org.hibernate.mapping.Table;
import org.hibernate.mapping.Value;
import org.hibernate.persister.BasicEntityPersister;
import org.hibernate.persister.Loadable;
import org.hibernate.persister.Queryable;
import org.hibernate.sql.InFragment;
import org.hibernate.sql.Insert;
import org.hibernate.sql.SelectFragment;
import org.hibernate.type.AssociationType;
import org.hibernate.type.DiscriminatorType;
import org.hibernate.type.Type;
import org.hibernate.util.ArrayHelper;
import org.hibernate.util.MarkerObject;

public class SingleTableEntityPersister
extends BasicEntityPersister {
    private final int joinSpan;
    private final String[] qualifiedTableNames;
    private final boolean[] isInverseTable;
    private final boolean[] isNullableTable;
    private final String[][] keyColumnNames;
    private final boolean[] cascadeDeleteEnabled;
    private final boolean hasSequentialSelects;
    private final String[] spaces;
    private final String[] subclassClosure;
    private final String[] subclassTableNameClosure;
    private final boolean[] subclassTableIsLazyClosure;
    private final boolean[] isInverseSubclassTable;
    private final boolean[] isNullableSubclassTable;
    private final boolean[] subclassTableSequentialSelect;
    private final String[][] subclassTableKeyColumnClosure;
    private final boolean[] isClassOrSuperclassTable;
    private final int[] propertyTableNumbers;
    private final int[] subclassPropertyTableNumberClosure;
    private final int[] subclassColumnTableNumberClosure;
    private final int[] subclassFormulaTableNumberClosure;
    private final Map subclassesByDiscriminatorValue = new HashMap();
    private final boolean forceDiscriminator;
    private final String discriminatorColumnName;
    private final String discriminatorFormula;
    private final String discriminatorFormulaTemplate;
    private final String discriminatorAlias;
    private final Type discriminatorType;
    private final Object discriminatorSQLValue;
    private final boolean discriminatorInsertable;
    private final Map propertyTableNumbersByNameAndSubclass = new HashMap();
    private final Map sequentialSelectStringsByEntityName = new HashMap();
    private static final Object NULL_DISCRIMINATOR = new MarkerObject("<null discriminator>");
    private static final Object NOT_NULL_DISCRIMINATOR = new MarkerObject("<not null discriminator>");

    /*
     * WARNING - void declaration
     */
    public SingleTableEntityPersister(PersistentClass persistentClass, CacheConcurrencyStrategy cache, SessionFactoryImplementor factory, Mapping mapping) throws HibernateException {
        super(persistentClass, cache, factory);
        Object discriminatorValue;
        Iterator iter;
        this.joinSpan = persistentClass.getJoinClosureSpan() + 1;
        this.qualifiedTableNames = new String[this.joinSpan];
        this.isInverseTable = new boolean[this.joinSpan];
        this.isNullableTable = new boolean[this.joinSpan];
        this.keyColumnNames = new String[this.joinSpan][];
        Table table = persistentClass.getRootTable();
        this.qualifiedTableNames[0] = table.getQualifiedName(factory.getDialect(), factory.getSettings().getDefaultCatalogName(), factory.getSettings().getDefaultSchemaName());
        this.isInverseTable[0] = false;
        this.isNullableTable[0] = false;
        this.keyColumnNames[0] = this.getIdentifierColumnNames();
        this.cascadeDeleteEnabled = new boolean[this.joinSpan];
        this.customSQLInsert = new String[this.joinSpan];
        this.customSQLUpdate = new String[this.joinSpan];
        this.customSQLDelete = new String[this.joinSpan];
        this.insertCallable = new boolean[this.joinSpan];
        this.updateCallable = new boolean[this.joinSpan];
        this.deleteCallable = new boolean[this.joinSpan];
        this.customSQLInsert[0] = persistentClass.getCustomSQLInsert();
        this.customSQLUpdate[0] = persistentClass.getCustomSQLUpdate();
        this.customSQLDelete[0] = persistentClass.getCustomSQLDelete();
        this.insertCallable[0] = persistentClass.isCustomInsertCallable();
        this.updateCallable[0] = persistentClass.isCustomUpdateCallable();
        this.deleteCallable[0] = persistentClass.isCustomDeleteCallable();
        Iterator joinIter = persistentClass.getJoinClosureIterator();
        int j = 1;
        while (joinIter.hasNext()) {
            Join join = (Join)joinIter.next();
            this.qualifiedTableNames[j] = join.getTable().getQualifiedName(factory.getDialect(), factory.getSettings().getDefaultCatalogName(), factory.getSettings().getDefaultSchemaName());
            this.isInverseTable[j] = join.isInverse();
            this.isNullableTable[j] = join.isOptional();
            this.cascadeDeleteEnabled[j] = join.getKey().isCascadeDeleteEnabled() && factory.getDialect().supportsCascadeDelete();
            this.customSQLInsert[j] = join.getCustomSQLInsert();
            this.customSQLUpdate[j] = join.getCustomSQLUpdate();
            this.customSQLDelete[j] = join.getCustomSQLDelete();
            this.insertCallable[j] = join.isCustomInsertCallable();
            this.updateCallable[j] = join.isCustomUpdateCallable();
            this.deleteCallable[j] = join.isCustomDeleteCallable();
            Iterator iter2 = join.getKey().getColumnIterator();
            this.keyColumnNames[j] = new String[join.getKey().getColumnSpan()];
            int i = 0;
            while (iter2.hasNext()) {
                Column col = (Column)iter2.next();
                this.keyColumnNames[j][i++] = col.getQuotedName(factory.getDialect());
            }
            ++j;
        }
        this.spaces = ArrayHelper.join(this.qualifiedTableNames, ArrayHelper.toStringArray(persistentClass.getSynchronizedTables()));
        boolean lazyAvailable = this.isLazyAvailable();
        boolean hasDeferred = false;
        ArrayList<String> subclassTables = new ArrayList<String>();
        ArrayList<String[]> joinKeyColumns = new ArrayList<String[]>();
        ArrayList<Boolean> isConcretes = new ArrayList<Boolean>();
        ArrayList<Boolean> isDeferreds = new ArrayList<Boolean>();
        ArrayList<Boolean> isInverses = new ArrayList<Boolean>();
        ArrayList<Boolean> isNullables = new ArrayList<Boolean>();
        ArrayList<Boolean> isLazies = new ArrayList<Boolean>();
        subclassTables.add(this.qualifiedTableNames[0]);
        joinKeyColumns.add(this.getIdentifierColumnNames());
        isConcretes.add(Boolean.TRUE);
        isDeferreds.add(Boolean.FALSE);
        isInverses.add(Boolean.FALSE);
        isNullables.add(Boolean.FALSE);
        isLazies.add(Boolean.FALSE);
        joinIter = persistentClass.getSubclassJoinClosureIterator();
        while (joinIter.hasNext()) {
            Join join = (Join)joinIter.next();
            isConcretes.add(new Boolean(persistentClass.isClassOrSuperclassJoin(join)));
            isDeferreds.add(new Boolean(join.isSequentialSelect()));
            isInverses.add(new Boolean(join.isInverse()));
            isNullables.add(new Boolean(join.isOptional()));
            isLazies.add(new Boolean(lazyAvailable && join.isLazy()));
            if (join.isSequentialSelect() && !persistentClass.isClassOrSuperclassJoin(join)) {
                hasDeferred = true;
            }
            subclassTables.add(join.getTable().getQualifiedName(factory.getDialect(), factory.getSettings().getDefaultCatalogName(), factory.getSettings().getDefaultSchemaName()));
            iter = join.getKey().getColumnIterator();
            String[] keyCols = new String[join.getKey().getColumnSpan()];
            int i = 0;
            while (iter.hasNext()) {
                Column col = (Column)iter.next();
                keyCols[i++] = col.getQuotedName(factory.getDialect());
            }
            joinKeyColumns.add(keyCols);
        }
        this.subclassTableSequentialSelect = ArrayHelper.toBooleanArray(isDeferreds);
        this.subclassTableNameClosure = ArrayHelper.toStringArray(subclassTables);
        this.subclassTableIsLazyClosure = ArrayHelper.toBooleanArray(isLazies);
        this.subclassTableKeyColumnClosure = ArrayHelper.to2DStringArray(joinKeyColumns);
        this.isClassOrSuperclassTable = ArrayHelper.toBooleanArray(isConcretes);
        this.isInverseSubclassTable = ArrayHelper.toBooleanArray(isInverses);
        this.isNullableSubclassTable = ArrayHelper.toBooleanArray(isNullables);
        this.hasSequentialSelects = hasDeferred;
        if (persistentClass.isPolymorphic()) {
            Value discrimValue = persistentClass.getDiscriminator();
            if (discrimValue == null) {
                throw new MappingException("discriminator mapping required for single table polymorphic persistence");
            }
            this.forceDiscriminator = persistentClass.isForceDiscriminator();
            Selectable selectable = (Selectable)discrimValue.getColumnIterator().next();
            if (discrimValue.hasFormula()) {
                Formula formula = (Formula)selectable;
                this.discriminatorFormula = formula.getFormula();
                this.discriminatorFormulaTemplate = formula.getTemplate(factory.getDialect());
                this.discriminatorColumnName = null;
                this.discriminatorAlias = "clazz_";
            } else {
                Column column = (Column)selectable;
                this.discriminatorColumnName = column.getQuotedName(factory.getDialect());
                this.discriminatorAlias = column.getAlias();
                this.discriminatorFormula = null;
                this.discriminatorFormulaTemplate = null;
            }
            this.discriminatorType = persistentClass.getDiscriminator().getType();
            if (persistentClass.isDiscriminatorValueNull()) {
                discriminatorValue = NULL_DISCRIMINATOR;
                this.discriminatorSQLValue = InFragment.NULL;
                this.discriminatorInsertable = false;
            } else if (persistentClass.isDiscriminatorValueNotNull()) {
                discriminatorValue = NOT_NULL_DISCRIMINATOR;
                this.discriminatorSQLValue = InFragment.NOT_NULL;
                this.discriminatorInsertable = false;
            } else {
                this.discriminatorInsertable = persistentClass.isDiscriminatorInsertable() && !discrimValue.hasFormula();
                try {
                    DiscriminatorType dtype = (DiscriminatorType)this.discriminatorType;
                    discriminatorValue = dtype.stringToObject(persistentClass.getDiscriminatorValue());
                    this.discriminatorSQLValue = dtype.objectToSQLString(discriminatorValue);
                }
                catch (ClassCastException cce) {
                    throw new MappingException("Illegal discriminator type: " + this.discriminatorType.getName());
                }
                catch (Exception e) {
                    throw new MappingException("Could not format discriminator value to SQL string", e);
                }
            }
        } else {
            this.forceDiscriminator = false;
            this.discriminatorInsertable = false;
            this.discriminatorColumnName = null;
            this.discriminatorAlias = null;
            this.discriminatorType = null;
            discriminatorValue = null;
            this.discriminatorSQLValue = null;
            this.discriminatorFormula = null;
            this.discriminatorFormulaTemplate = null;
        }
        this.propertyTableNumbers = new int[this.getPropertySpan()];
        iter = persistentClass.getPropertyClosureIterator();
        int i = 0;
        while (iter.hasNext()) {
            Property prop = (Property)iter.next();
            this.propertyTableNumbers[i++] = persistentClass.getJoinNumber(prop);
        }
        ArrayList<Integer> columnJoinNumbers = new ArrayList<Integer>();
        ArrayList<Integer> formulaJoinedNumbers = new ArrayList<Integer>();
        ArrayList<Integer> propertyJoinNumbers = new ArrayList<Integer>();
        iter = persistentClass.getSubclassPropertyClosureIterator();
        while (iter.hasNext()) {
            Property prop = (Property)iter.next();
            Integer join = new Integer(persistentClass.getJoinNumber(prop));
            propertyJoinNumbers.add(join);
            this.propertyTableNumbersByNameAndSubclass.put(prop.getPersistentClass().getEntityName() + '.' + prop.getName(), join);
            Iterator citer = prop.getColumnIterator();
            while (citer.hasNext()) {
                Selectable thing = (Selectable)citer.next();
                if (thing.isFormula()) {
                    formulaJoinedNumbers.add(join);
                    continue;
                }
                columnJoinNumbers.add(join);
            }
        }
        this.subclassColumnTableNumberClosure = ArrayHelper.toIntArray(columnJoinNumbers);
        this.subclassFormulaTableNumberClosure = ArrayHelper.toIntArray(formulaJoinedNumbers);
        this.subclassPropertyTableNumberClosure = ArrayHelper.toIntArray(propertyJoinNumbers);
        int subclassSpan = persistentClass.getSubclassSpan() + 1;
        this.subclassClosure = new String[subclassSpan];
        this.subclassClosure[0] = this.getEntityName();
        if (persistentClass.isPolymorphic()) {
            void var17_20;
            this.subclassesByDiscriminatorValue.put(var17_20, this.getEntityName());
        }
        if (persistentClass.isPolymorphic()) {
            iter = persistentClass.getSubclassIterator();
            int k = 1;
            while (iter.hasNext()) {
                Subclass sc = (Subclass)iter.next();
                this.subclassClosure[k++] = sc.getEntityName();
                if (sc.isDiscriminatorValueNull()) {
                    this.subclassesByDiscriminatorValue.put(NULL_DISCRIMINATOR, sc.getEntityName());
                    continue;
                }
                if (sc.isDiscriminatorValueNotNull()) {
                    this.subclassesByDiscriminatorValue.put(NOT_NULL_DISCRIMINATOR, sc.getEntityName());
                    continue;
                }
                try {
                    DiscriminatorType dtype = (DiscriminatorType)this.discriminatorType;
                    this.subclassesByDiscriminatorValue.put(dtype.stringToObject(sc.getDiscriminatorValue()), sc.getEntityName());
                }
                catch (ClassCastException cce) {
                    throw new MappingException("Illegal discriminator type: " + this.discriminatorType.getName());
                }
                catch (Exception e) {
                    throw new MappingException("Error parsing discriminator value", e);
                }
            }
        }
        this.initLockers();
        this.initSubclassPropertyAliasesMap(persistentClass);
        this.postConstruct(mapping);
    }

    protected boolean isInverseTable(int j) {
        return this.isInverseTable[j];
    }

    protected boolean isInverseSubclassTable(int j) {
        return this.isInverseSubclassTable[j];
    }

    protected String getDiscriminatorColumnName() {
        return this.discriminatorColumnName;
    }

    protected String getDiscriminatorAlias() {
        return this.discriminatorAlias;
    }

    protected String getDiscriminatorFormulaTemplate() {
        return this.discriminatorFormulaTemplate;
    }

    public String getTableName() {
        return this.qualifiedTableNames[0];
    }

    public Type getDiscriminatorType() {
        return this.discriminatorType;
    }

    public Object getDiscriminatorSQLValue() {
        return this.discriminatorSQLValue;
    }

    public String[] getSubclassClosure() {
        return this.subclassClosure;
    }

    public String getSubclassForDiscriminatorValue(Object value) {
        if (value == null) {
            return (String)this.subclassesByDiscriminatorValue.get(NULL_DISCRIMINATOR);
        }
        String result = (String)this.subclassesByDiscriminatorValue.get(value);
        if (result == null) {
            result = (String)this.subclassesByDiscriminatorValue.get(NOT_NULL_DISCRIMINATOR);
        }
        return result;
    }

    public Serializable[] getPropertySpaces() {
        return this.spaces;
    }

    protected boolean isDiscriminatorFormula() {
        return this.discriminatorColumnName == null;
    }

    protected String getDiscriminatorFormula() {
        return this.discriminatorFormula;
    }

    protected String getTableName(int j) {
        return this.qualifiedTableNames[j];
    }

    protected String[] getKeyColumns(int j) {
        return this.keyColumnNames[j];
    }

    protected boolean isTableCascadeDeleteEnabled(int j) {
        return this.cascadeDeleteEnabled[j];
    }

    protected boolean isPropertyOfTable(int property, int j) {
        return this.propertyTableNumbers[property] == j;
    }

    protected boolean isSubclassTableSequentialSelect(int j) {
        return this.subclassTableSequentialSelect[j] && !this.isClassOrSuperclassTable[j];
    }

    public String fromTableFragment(String name) {
        return this.getTableName() + ' ' + name;
    }

    public String filterFragment(String alias) throws MappingException {
        String result = this.discriminatorFilterFragment(alias);
        if (this.hasWhere()) {
            result = result + " and " + this.getSQLWhereString(alias);
        }
        return result;
    }

    public String oneToManyFilterFragment(String alias) throws MappingException {
        return this.forceDiscriminator ? this.discriminatorFilterFragment(alias) : "";
    }

    private String discriminatorFilterFragment(String alias) throws MappingException {
        if (this.needsDiscriminator()) {
            InFragment frag = new InFragment();
            if (this.isDiscriminatorFormula()) {
                frag.setFormula(alias, this.getDiscriminatorFormulaTemplate());
            } else {
                frag.setColumn(alias, this.getDiscriminatorColumnName());
            }
            String[] subclasses = this.getSubclassClosure();
            for (int i = 0; i < subclasses.length; ++i) {
                frag.addValue(((Queryable)this.getFactory().getEntityPersister(subclasses[i])).getDiscriminatorSQLValue());
            }
            StringBuffer buf = new StringBuffer(50).append(" and ").append(frag.toFragmentString());
            return buf.toString();
        }
        return "";
    }

    private boolean needsDiscriminator() {
        return this.forceDiscriminator || this.isInherited();
    }

    public String getSubclassPropertyTableName(int i) {
        return this.subclassTableNameClosure[this.subclassPropertyTableNumberClosure[i]];
    }

    protected void addDiscriminatorToSelect(SelectFragment select, String name, String suffix) {
        if (this.isDiscriminatorFormula()) {
            select.addFormula(name, this.getDiscriminatorFormulaTemplate(), this.getDiscriminatorAlias());
        } else {
            select.addColumn(name, this.getDiscriminatorColumnName(), this.getDiscriminatorAlias());
        }
    }

    protected int[] getPropertyTableNumbersInSelect() {
        return this.propertyTableNumbers;
    }

    protected int getSubclassPropertyTableNumber(int i) {
        return this.subclassPropertyTableNumberClosure[i];
    }

    protected int getTableSpan() {
        return this.joinSpan;
    }

    protected void addDiscriminatorToInsert(Insert insert) {
        if (this.discriminatorInsertable) {
            insert.addColumn(this.getDiscriminatorColumnName(), this.discriminatorSQLValue.toString());
        }
    }

    protected int[] getSubclassColumnTableNumberClosure() {
        return this.subclassColumnTableNumberClosure;
    }

    protected int[] getSubclassFormulaTableNumberClosure() {
        return this.subclassFormulaTableNumberClosure;
    }

    protected int[] getPropertyTableNumbers() {
        return this.propertyTableNumbers;
    }

    protected boolean isSubclassPropertyDeferred(String propertyName, String entityName) {
        return this.hasSequentialSelects && this.isSubclassTableSequentialSelect(this.getSubclassPropertyTableNumber(propertyName, entityName));
    }

    public boolean hasSequentialSelect() {
        return this.hasSequentialSelects;
    }

    private int getSubclassPropertyTableNumber(String propertyName, String entityName) {
        Type type = this.propertyMapping.toType(propertyName);
        if (type.isAssociationType() && ((AssociationType)type).useLHSPrimaryKey()) {
            return 0;
        }
        Integer tabnum = (Integer)this.propertyTableNumbersByNameAndSubclass.get(entityName + '.' + propertyName);
        return tabnum == null ? 0 : tabnum;
    }

    protected String getSequentialSelect(String entityName) {
        return (String)this.sequentialSelectStringsByEntityName.get(entityName);
    }

    private String generateSequentialSelect(Loadable persister) {
        BasicEntityPersister subclassPersister = (BasicEntityPersister)persister;
        HashSet<Integer> tableNumbers = new HashSet<Integer>();
        String[] props = subclassPersister.getPropertyNames();
        String[] classes = subclassPersister.getPropertySubclassNames();
        for (int i = 0; i < props.length; ++i) {
            int propTableNumber = this.getSubclassPropertyTableNumber(props[i], classes[i]);
            if (!this.isSubclassTableSequentialSelect(propTableNumber) || this.isSubclassTableLazy(propTableNumber)) continue;
            tableNumbers.add(new Integer(propTableNumber));
        }
        if (tableNumbers.isEmpty()) {
            return null;
        }
        ArrayList<Integer> columnNumbers = new ArrayList<Integer>();
        int[] columnTableNumbers = this.getSubclassColumnTableNumberClosure();
        for (int i = 0; i < this.getSubclassColumnClosure().length; ++i) {
            if (!tableNumbers.contains(new Integer(columnTableNumbers[i]))) continue;
            columnNumbers.add(new Integer(i));
        }
        ArrayList<Integer> formulaNumbers = new ArrayList<Integer>();
        int[] formulaTableNumbers = this.getSubclassColumnTableNumberClosure();
        for (int i = 0; i < this.getSubclassFormulaTemplateClosure().length; ++i) {
            if (!tableNumbers.contains(new Integer(formulaTableNumbers[i]))) continue;
            formulaNumbers.add(new Integer(i));
        }
        return this.renderSelect(ArrayHelper.toIntArray(tableNumbers), ArrayHelper.toIntArray(columnNumbers), ArrayHelper.toIntArray(formulaNumbers));
    }

    protected String[] getSubclassTableKeyColumns(int j) {
        return this.subclassTableKeyColumnClosure[j];
    }

    protected String getSubclassTableName(int j) {
        return this.subclassTableNameClosure[j];
    }

    protected int getSubclassTableSpan() {
        return this.subclassTableNameClosure.length;
    }

    protected boolean isClassOrSuperclassTable(int j) {
        return this.isClassOrSuperclassTable[j];
    }

    protected boolean isSubclassTableLazy(int j) {
        return this.subclassTableIsLazyClosure[j];
    }

    protected boolean isNullableTable(int j) {
        return this.isNullableTable[j];
    }

    protected boolean isNullableSubclassTable(int j) {
        return this.isNullableSubclassTable[j];
    }

    public String getPropertyTableName(String propertyName) {
        return this.qualifiedTableNames[this.propertyTableNumbers[this.getPropertyIndex(propertyName)]];
    }

    public void postInstantiate() {
        super.postInstantiate();
        if (this.hasSequentialSelects) {
            String[] entityNames = this.getSubclassClosure();
            for (int i = 1; i < entityNames.length; ++i) {
                Loadable loadable = (Loadable)this.getFactory().getEntityPersister(entityNames[i]);
                String sequentialSelect = this.generateSequentialSelect(loadable);
                this.sequentialSelectStringsByEntityName.put(entityNames[i], sequentialSelect);
            }
        }
    }
}

