/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.persister.collection;

import java.io.Serializable;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.Map;
import org.hibernate.HibernateException;
import org.hibernate.MappingException;
import org.hibernate.cache.CacheConcurrencyStrategy;
import org.hibernate.cache.CacheException;
import org.hibernate.cfg.Configuration;
import org.hibernate.collection.PersistentCollection;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.engine.Subquery;
import org.hibernate.exception.JDBCExceptionHelper;
import org.hibernate.loader.collection.BatchingCollectionInitializer;
import org.hibernate.loader.collection.CollectionInitializer;
import org.hibernate.loader.collection.SubqueryCollectionLoader;
import org.hibernate.mapping.Collection;
import org.hibernate.persister.collection.AbstractCollectionPersister;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.pretty.MessageHelper;
import org.hibernate.sql.Delete;
import org.hibernate.sql.Insert;
import org.hibernate.sql.Update;
import org.hibernate.util.ArrayHelper;

public class BasicCollectionPersister
extends AbstractCollectionPersister {
    public boolean isCascadeDeleteEnabled() {
        return false;
    }

    public BasicCollectionPersister(Collection collection, CacheConcurrencyStrategy cache, Configuration cfg, SessionFactoryImplementor factory) throws MappingException, CacheException {
        super(collection, cache, cfg, factory);
    }

    protected String generateDeleteString() {
        Delete delete = new Delete().setTableName(this.qualifiedTableName).setPrimaryKeyColumnNames(this.keyColumnNames);
        if (this.hasWhere) {
            delete.setWhere(this.sqlWhereString);
        }
        if (this.getFactory().getSettings().isCommentsEnabled()) {
            delete.setComment("delete collection " + this.getRole());
        }
        return delete.toStatementString();
    }

    protected String generateInsertRowString() {
        Insert insert = new Insert(null).setTableName(this.qualifiedTableName).addColumns(this.keyColumnNames);
        if (this.hasIdentifier) {
            insert.addColumn(this.identifierColumnName);
        }
        if (this.hasIndex) {
            insert.addColumns(this.indexColumnNames, this.indexColumnIsSettable);
        }
        if (this.getFactory().getSettings().isCommentsEnabled()) {
            insert.setComment("insert collection row " + this.getRole());
        }
        insert.addColumns(this.elementColumnNames, this.elementColumnIsSettable);
        return insert.toStatementString();
    }

    protected String generateUpdateRowString() {
        Update update = new Update().setTableName(this.qualifiedTableName);
        update.addColumns(this.elementColumnNames, this.elementColumnIsSettable);
        if (this.hasIdentifier) {
            update.setPrimaryKeyColumnNames(new String[]{this.identifierColumnName});
        } else if (this.hasIndex && !this.indexIsFormula) {
            update.setPrimaryKeyColumnNames(ArrayHelper.join(this.keyColumnNames, this.indexColumnNames));
        } else {
            update.setPrimaryKeyColumnNames(ArrayHelper.join(this.keyColumnNames, this.elementColumnNames));
        }
        if (this.getFactory().getSettings().isCommentsEnabled()) {
            update.setComment("update collection row " + this.getRole());
        }
        return update.toStatementString();
    }

    protected String generateDeleteRowString() {
        Delete delete = new Delete().setTableName(this.qualifiedTableName);
        if (this.hasIdentifier) {
            delete.setPrimaryKeyColumnNames(new String[]{this.identifierColumnName});
        } else if (this.hasIndex && !this.indexIsFormula) {
            delete.setPrimaryKeyColumnNames(ArrayHelper.join(this.keyColumnNames, this.indexColumnNames));
        } else {
            delete.setPrimaryKeyColumnNames(ArrayHelper.join(this.keyColumnNames, this.elementColumnNames));
        }
        if (this.getFactory().getSettings().isCommentsEnabled()) {
            delete.setComment("delete collection row " + this.getRole());
        }
        return delete.toStatementString();
    }

    public boolean consumesAlias() {
        return false;
    }

    public boolean isOneToMany() {
        return false;
    }

    public boolean isManyToMany() {
        return this.elementType.isEntityType();
    }

    protected int doUpdateRows(Serializable id, PersistentCollection collection, SessionImplementor session) throws HibernateException {
        if (ArrayHelper.isAllFalse(this.elementColumnIsSettable)) {
            return 0;
        }
        try {
            PreparedStatement st = null;
            boolean callable = this.isUpdateCallable();
            Iterator entries = collection.entries(this);
            try {
                int i = 0;
                int count = 0;
                while (entries.hasNext()) {
                    int offset = 1;
                    Object entry = entries.next();
                    if (collection.needsUpdating(entry, i, this.elementType)) {
                        if (st == null) {
                            if (callable) {
                                CallableStatement callstatement = session.getBatcher().prepareBatchCallableStatement(this.getSQLUpdateRowString());
                                callstatement.registerOutParameter(offset++, 2);
                                st = callstatement;
                            } else {
                                st = session.getBatcher().prepareBatchStatement(this.getSQLUpdateRowString());
                            }
                        }
                        int loc = this.writeElement(st, collection.getElement(entry), offset, session);
                        if (this.hasIdentifier) {
                            loc = this.writeIdentifier(st, collection.getIdentifier(entry, i), loc, session);
                        } else {
                            loc = this.writeKey(st, id, loc, session);
                            loc = this.hasIndex && !this.indexIsFormula ? this.writeIndexToWhere(st, collection.getIndex(entry, i, this), loc, session) : this.writeElementToWhere(st, collection.getSnapshotElement(entry, i), loc, session);
                        }
                        session.getBatcher().addToBatch(1);
                        ++count;
                    }
                    ++i;
                }
                return count;
            }
            catch (SQLException sqle) {
                session.getBatcher().abortBatch(sqle);
                throw sqle;
            }
        }
        catch (SQLException sqle) {
            throw JDBCExceptionHelper.convert(this.getSQLExceptionConverter(), sqle, "could not update collection rows: " + MessageHelper.collectionInfoString((CollectionPersister)this, id, this.getFactory()), this.getSQLUpdateRowString());
        }
    }

    public String selectFragment(String alias, String suffix, boolean includeCollectionColumns) {
        return includeCollectionColumns ? this.selectFragment(alias) : "";
    }

    protected CollectionInitializer createCollectionInitializer(Map enabledFilters) throws MappingException {
        return BatchingCollectionInitializer.createBatchingCollectionInitializer(this, this.batchSize, this.getFactory(), enabledFilters);
    }

    public String fromJoinFragment(String alias, boolean innerJoin, boolean includeSubclasses) {
        return "";
    }

    public String whereJoinFragment(String alias, boolean innerJoin, boolean includeSubclasses) {
        return "";
    }

    protected CollectionInitializer getSubqueryInitializer(Subquery subquery, SessionImplementor session) {
        return new SubqueryCollectionLoader(this, subquery.toSubqueryString(), subquery.getResult(), subquery.getQueryParameters(), session.getFactory(), session.getEnabledFilters());
    }
}

