/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.persister.collection;

import java.io.Serializable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.FlushMode;
import org.hibernate.HibernateException;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.impl.AbstractQueryImpl;
import org.hibernate.loader.collection.CollectionInitializer;
import org.hibernate.persister.collection.CollectionPersister;

public final class NamedQueryCollectionInitializer
implements CollectionInitializer {
    private final String queryName;
    private final CollectionPersister persister;
    private static final Log log;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.hibernate.persister.collection.NamedQueryCollectionInitializer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LogFactory.getLog((Class)clazz);
    }

    public NamedQueryCollectionInitializer(String queryName, CollectionPersister persister) {
        this.queryName = queryName;
        this.persister = persister;
    }

    public void initialize(Serializable key, SessionImplementor session) throws HibernateException {
        AbstractQueryImpl query;
        if (log.isDebugEnabled()) {
            log.debug((Object)("initializing collection: " + this.persister.getRole() + " using named query: " + this.queryName));
        }
        if ((query = (AbstractQueryImpl)session.getNamedQuery(this.queryName)).getNamedParameters().length > 0) {
            query.setParameter(query.getNamedParameters()[0], (Object)key, this.persister.getKeyType());
        } else {
            query.setParameter(0, (Object)key, this.persister.getKeyType());
        }
        query.setCollectionKey(key).setFlushMode(FlushMode.NEVER).list();
    }
}

