/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool.hbm2ddl;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.HibernateException;
import org.hibernate.cfg.Configuration;
import org.hibernate.cfg.NamingStrategy;
import org.hibernate.connection.ConnectionProvider;
import org.hibernate.connection.ConnectionProviderFactory;
import org.hibernate.dialect.Dialect;
import org.hibernate.util.JDBCExceptionReporter;
import org.hibernate.util.ReflectHelper;

public class SchemaExport {
    private static final Log log;
    private ConnectionHelper connectionHelper;
    private String[] dropSQL;
    private String[] createSQL;
    private String outputFile = null;
    private Dialect dialect;
    private String delimiter;
    private List exceptions;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.hibernate.tool.hbm2ddl.SchemaExport");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LogFactory.getLog((Class)clazz);
    }

    public SchemaExport(Configuration cfg) throws HibernateException {
        this(cfg, cfg.getProperties());
    }

    public SchemaExport(Configuration cfg, Properties connectionProperties) throws HibernateException {
        this.dialect = Dialect.getDialect(connectionProperties);
        Properties props = new Properties();
        props.putAll((Map<?, ?>)this.dialect.getDefaultProperties());
        props.putAll((Map<?, ?>)connectionProperties);
        this.connectionHelper = new ProviderConnectionHelper(props);
        this.dropSQL = cfg.generateDropSchemaScript(this.dialect);
        this.createSQL = cfg.generateSchemaCreationScript(this.dialect);
        this.exceptions = new ArrayList();
    }

    public SchemaExport(Configuration cfg, Connection connection) {
        this.connectionHelper = new SuppliedConnectionHelper(connection);
        this.dialect = Dialect.getDialect(cfg.getProperties());
        this.dropSQL = cfg.generateDropSchemaScript(this.dialect);
        this.createSQL = cfg.generateSchemaCreationScript(this.dialect);
        this.exceptions = new ArrayList();
    }

    public SchemaExport setOutputFile(String filename) {
        this.outputFile = filename;
        return this;
    }

    public SchemaExport setDelimiter(String delimiter) {
        this.delimiter = delimiter;
        return this;
    }

    public void create(boolean script, boolean export) {
        this.execute(script, export, false, true);
    }

    public void drop(boolean script, boolean export) {
        this.execute(script, export, true, true);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void execute(boolean script, boolean export, boolean justDrop, boolean format) {
        block36: {
            SchemaExport.log.info((Object)"Running hbm2ddl schema export");
            connection = null;
            fileOutput = null;
            statement = null;
            this.exceptions.clear();
            try {
                try {
                    block34: {
                        if (this.outputFile != null) {
                            SchemaExport.log.info((Object)("writing generated schema to file: " + this.outputFile));
                            fileOutput = new FileWriter(this.outputFile);
                        }
                        if (export) {
                            SchemaExport.log.info((Object)"exporting generated schema to database");
                            connection = this.connectionHelper.getConnection();
                            if (!connection.getAutoCommit()) {
                                connection.commit();
                                connection.setAutoCommit(true);
                            }
                            statement = connection.createStatement();
                        }
                        i = 0;
                        while (true) {
                            if (i >= this.dropSQL.length) {
                                if (!justDrop) {
                                    j = 0;
                                    break;
                                }
                                break block34;
                            }
                            try {
                                formatted = this.dropSQL[i];
                                if (this.delimiter != null) {
                                    formatted = String.valueOf(formatted) + this.delimiter;
                                }
                                if (script) {
                                    System.out.println(formatted);
                                }
                                SchemaExport.log.debug((Object)formatted);
                                if (this.outputFile != null) {
                                    fileOutput.write(String.valueOf(formatted) + "\n");
                                }
                                if (export) {
                                    statement.executeUpdate(this.dropSQL[i]);
                                }
                            }
                            catch (SQLException e) {
                                this.exceptions.add(e);
                                SchemaExport.log.debug((Object)("Unsuccessful: " + this.dropSQL[i]));
                                SchemaExport.log.debug((Object)e.getMessage());
                            }
                            ++i;
                        }
                        while (j < this.createSQL.length) {
                            try {
                                v0 = formatted = format != false ? SchemaExport.format(this.createSQL[j]) : this.createSQL[j];
                                if (this.delimiter != null) {
                                    formatted = String.valueOf(formatted) + this.delimiter;
                                }
                                if (script) {
                                    System.out.println(formatted);
                                }
                                SchemaExport.log.debug((Object)formatted);
                                if (this.outputFile != null) {
                                    fileOutput.write(String.valueOf(formatted) + "\n");
                                }
                                if (export) {
                                    statement.executeUpdate(this.createSQL[j]);
                                }
                            }
                            catch (SQLException e) {
                                this.exceptions.add(e);
                                SchemaExport.log.error((Object)("Unsuccessful: " + this.createSQL[j]));
                                SchemaExport.log.error((Object)e.getMessage());
                            }
                            ++j;
                        }
                    }
                    SchemaExport.log.info((Object)"schema export complete");
                }
                catch (Exception e) {
                    this.exceptions.add(e);
                    SchemaExport.log.error((Object)"schema export unsuccessful", (Throwable)e);
                }
            }
            catch (Throwable var11_13) {
                var10_14 = null;
                try {
                    if (statement != null) {
                        statement.close();
                    }
                    if (connection != null) {
                        this.connectionHelper.release();
                    }
                }
                catch (Exception e) {
                    this.exceptions.add(e);
                    SchemaExport.log.error((Object)"Could not close connection", (Throwable)e);
                }
                try {
                    if (fileOutput == null) throw var11_13;
                    fileOutput.close();
                    throw var11_13;
                }
                catch (IOException ioe) {
                    this.exceptions.add(ioe);
                    SchemaExport.log.error((Object)("Error closing output file: " + this.outputFile), (Throwable)ioe);
                }
                throw var11_13;
            }
            {
                var10_15 = null;
            }
            ** try [egrp 4[TRYBLOCK] [5 : 590->617)] { 
lbl99:
            // 1 sources

            if (statement != null) {
                statement.close();
            }
            if (connection != null) {
                this.connectionHelper.release();
            }
            break block36;
lbl104:
            // 1 sources

            catch (Exception e) {
                this.exceptions.add(e);
                SchemaExport.log.error((Object)"Could not close connection", (Throwable)e);
            }
        }
        try {}
        catch (IOException ioe) {
            this.exceptions.add(ioe);
            SchemaExport.log.error((Object)("Error closing output file: " + this.outputFile), (Throwable)ioe);
            return;
        }
        if (fileOutput == null) return;
        fileOutput.close();
    }

    private static String format(String sql) {
        String formatted;
        if (sql.indexOf("\"") > 0 || sql.indexOf("'") > 0) {
            return sql;
        }
        if (sql.toLowerCase().startsWith("create table")) {
            StringBuffer result = new StringBuffer(60);
            StringTokenizer tokens = new StringTokenizer(sql, "(,)", true);
            int depth = 0;
            while (tokens.hasMoreTokens()) {
                String tok = tokens.nextToken();
                if (")".equals(tok) && --depth == 0) {
                    result.append("\n");
                }
                result.append(tok);
                if (",".equals(tok) && depth == 1) {
                    result.append("\n  ");
                }
                if (!"(".equals(tok) || ++depth != 1) continue;
                result.append("\n   ");
            }
            formatted = result.toString();
        } else {
            formatted = sql;
        }
        return formatted;
    }

    public static void main(String[] args) {
        try {
            Configuration cfg = new Configuration();
            boolean script = true;
            boolean drop = false;
            boolean export = true;
            String outFile = null;
            String propFile = null;
            boolean formatSQL = false;
            String delim = null;
            int i = 0;
            while (i < args.length) {
                if (args[i].startsWith("--")) {
                    if (args[i].equals("--quiet")) {
                        script = false;
                    } else if (args[i].equals("--drop")) {
                        drop = true;
                    } else if (args[i].equals("--text")) {
                        export = false;
                    } else if (args[i].startsWith("--output=")) {
                        outFile = args[i].substring(9);
                    } else if (args[i].startsWith("--properties=")) {
                        propFile = args[i].substring(13);
                    } else if (args[i].equals("--format")) {
                        formatSQL = true;
                    } else if (args[i].startsWith("--delimiter=")) {
                        delim = args[i].substring(12);
                    } else if (args[i].startsWith("--config=")) {
                        cfg.configure(args[i].substring(9));
                    } else if (args[i].startsWith("--naming=")) {
                        cfg.setNamingStrategy((NamingStrategy)ReflectHelper.classForName(args[i].substring(9)).newInstance());
                    }
                } else {
                    String filename = args[i];
                    if (filename.endsWith(".jar")) {
                        cfg.addJar(new File(filename));
                    } else {
                        cfg.addFile(filename);
                    }
                }
                ++i;
            }
            if (propFile != null) {
                Properties props = new Properties();
                props.load(new FileInputStream(propFile));
                new SchemaExport(cfg, props).setOutputFile(outFile).setDelimiter(delim).execute(script, export, drop, formatSQL);
            } else {
                new SchemaExport(cfg).setOutputFile(outFile).setDelimiter(delim).execute(script, export, drop, formatSQL);
            }
        }
        catch (Exception e) {
            log.error((Object)"Error creating schema ", (Throwable)e);
            e.printStackTrace();
        }
    }

    public List getExceptions() {
        return this.exceptions;
    }

    private abstract class ConnectionHelper {
        ConnectionHelper() {
        }

        abstract Connection getConnection() throws SQLException;

        abstract void release() throws SQLException;

        protected final void logAnyWarnings(Connection connection) {
            try {
                JDBCExceptionReporter.logWarnings(connection.getWarnings());
                connection.clearWarnings();
            }
            catch (SQLException sqle) {
                SchemaExport.this.exceptions.add(sqle);
            }
        }
    }

    private class SuppliedConnectionHelper
    extends ConnectionHelper {
        private Connection connection;

        public SuppliedConnectionHelper(Connection connection) {
            this.connection = connection;
        }

        Connection getConnection() {
            return this.connection;
        }

        void release() {
            this.logAnyWarnings(this.connection);
            this.connection = null;
        }
    }

    private class ProviderConnectionHelper
    extends ConnectionHelper {
        private Properties cfgProperties;
        private ConnectionProvider connectionProvider;
        private Connection connection;

        public ProviderConnectionHelper(Properties cfgProperties) {
            this.cfgProperties = cfgProperties;
        }

        public Connection getConnection() throws SQLException {
            if (this.connection == null) {
                this.connectionProvider = ConnectionProviderFactory.newConnectionProvider(this.cfgProperties);
                this.connection = this.connectionProvider.getConnection();
                if (!this.connection.getAutoCommit()) {
                    this.connection.commit();
                    this.connection.setAutoCommit(true);
                }
            }
            return this.connection;
        }

        public void release() throws SQLException {
            if (this.connection != null) {
                this.logAnyWarnings(this.connection);
                this.connectionProvider.closeConnection(this.connection);
                this.connectionProvider.close();
            }
        }
    }
}

