/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.transaction;

import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.Transaction;
import org.hibernate.TransactionException;
import org.hibernate.jdbc.JDBCContext;
import org.hibernate.transaction.TransactionFactory;
import org.hibernate.util.JTAHelper;

public final class CacheSynchronization
implements Synchronization {
    private static final Log log;
    private final TransactionFactory.Context ctx;
    private JDBCContext jdbcContext;
    private final javax.transaction.Transaction transaction;
    private final Transaction hibernateTransaction;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.hibernate.transaction.CacheSynchronization");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LogFactory.getLog((Class)clazz);
    }

    public CacheSynchronization(TransactionFactory.Context ctx, JDBCContext jdbcContext, javax.transaction.Transaction transaction, Transaction tx) {
        this.ctx = ctx;
        this.jdbcContext = jdbcContext;
        this.transaction = transaction;
        this.hibernateTransaction = tx;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void beforeCompletion() {
        boolean flush;
        log.trace((Object)"transaction before completion callback");
        try {
            flush = !this.ctx.isFlushModeNever() && this.ctx.isFlushBeforeCompletionEnabled() && !JTAHelper.isRollback(this.transaction.getStatus());
        }
        catch (SystemException se) {
            log.error((Object)"could not determine transaction status", (Throwable)se);
            throw new TransactionException("could not determine transaction status in beforeCompletion()", (Exception)((Object)se));
        }
        try {
            if (flush) {
                log.trace((Object)"automatically flushing session");
                this.ctx.managedFlush();
            }
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            this.jdbcContext.beforeTransactionCompletion(this.hibernateTransaction);
            if (!this.ctx.shouldAutoClose()) throw throwable;
            if (!this.ctx.isOpen()) throw throwable;
            log.trace((Object)"automatically closing session");
            this.ctx.managedClose();
            throw throwable;
        }
        {
            Object var2_4 = null;
            this.jdbcContext.beforeTransactionCompletion(this.hibernateTransaction);
            if (!this.ctx.shouldAutoClose()) return;
            if (!this.ctx.isOpen()) return;
        }
        log.trace((Object)"automatically closing session");
        this.ctx.managedClose();
    }

    public void afterCompletion(int status) {
        if (log.isTraceEnabled()) {
            log.trace((Object)("transaction after completion callback, status: " + status));
        }
        this.jdbcContext.afterTransactionCompletion(status == 3, this.hibernateTransaction);
    }
}

