/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.transaction;

import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.UserTransaction;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.AssertionFailure;
import org.hibernate.HibernateException;
import org.hibernate.Transaction;
import org.hibernate.TransactionException;
import org.hibernate.jdbc.JDBCContext;
import org.hibernate.transaction.TransactionFactory;
import org.hibernate.util.JTAHelper;

public class JTATransaction
implements Transaction {
    private static final Log log;
    private final JDBCContext jdbcContext;
    private final TransactionFactory.Context transactionContext;
    private UserTransaction ut;
    private boolean newTransaction;
    private boolean synchronization;
    private boolean begun;
    private boolean commitFailed;
    private javax.transaction.Transaction transaction;
    private static final int NULL = Integer.MIN_VALUE;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.hibernate.transaction.JTATransaction");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LogFactory.getLog((Class)clazz);
    }

    public JTATransaction(JDBCContext jdbcContext, TransactionFactory.Context transactionContext) {
        this.jdbcContext = jdbcContext;
        this.transactionContext = transactionContext;
    }

    public void begin(InitialContext context, String utName) throws HibernateException {
        log.debug((Object)"begin");
        log.debug((Object)("Looking for UserTransaction under: " + utName));
        try {
            this.ut = (UserTransaction)context.lookup(utName);
        }
        catch (NamingException ne) {
            log.error((Object)"Could not find UserTransaction in JNDI", (Throwable)ne);
            throw new TransactionException("Could not find UserTransaction in JNDI: ", ne);
        }
        if (this.ut == null) {
            throw new AssertionFailure("A naming service lookup returned null");
        }
        log.debug((Object)"Obtained UserTransaction");
        try {
            boolean bl = this.newTransaction = this.ut.getStatus() == 6;
            if (this.newTransaction) {
                this.ut.begin();
                log.debug((Object)"Began a new JTA transaction");
            }
        }
        catch (Exception e) {
            log.error((Object)"JTA transaction begin failed", (Throwable)e);
            throw new TransactionException("JTA transaction begin failed", e);
        }
        this.synchronization = this.jdbcContext.registerSynchronizationIfPossible();
        if (!this.newTransaction && !this.synchronization) {
            log.warn((Object)"You should set hibernate.transaction.manager_lookup_class if cache is enabled");
        }
        if (!this.synchronization) {
            this.jdbcContext.registerCallbackIfNecessary();
        }
        this.begun = true;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void commit() throws HibernateException {
        boolean flush;
        if (!this.begun) {
            throw new TransactionException("Transaction not successfully started");
        }
        log.debug((Object)"commit");
        boolean bl = flush = !this.transactionContext.isFlushModeNever() && (!this.synchronization || !this.transactionContext.isFlushBeforeCompletionEnabled());
        if (flush) {
            this.transactionContext.managedFlush();
        }
        if (!this.synchronization && this.newTransaction) {
            this.jdbcContext.beforeTransactionCompletion(this);
        }
        this.closeIfRequired();
        if (!this.newTransaction) {
            this.afterCommitRollback();
            return;
        }
        try {
            try {
                this.ut.commit();
                log.debug((Object)"Committed JTA UserTransaction");
            }
            catch (Exception e) {
                this.commitFailed = true;
                log.error((Object)"JTA commit failed", (Throwable)e);
                throw new TransactionException("JTA commit failed: ", e);
            }
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            this.afterCommitRollback();
            throw throwable;
        }
        {
            Object var3_5 = null;
            this.afterCommitRollback();
            return;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void rollback() throws HibernateException {
        if (!this.begun) {
            throw new TransactionException("Transaction not successfully started");
        }
        log.debug((Object)"rollback");
        if (!this.synchronization && this.newTransaction && !this.commitFailed) {
            this.jdbcContext.beforeTransactionCompletion(this);
        }
        try {
            this.closeIfRequired();
        }
        catch (Exception e) {
            log.error((Object)"could not close session during rollback", (Throwable)e);
        }
        try {
            try {
                if (this.newTransaction) {
                    if (!this.commitFailed) {
                        this.ut.rollback();
                        log.debug((Object)"Rolled back JTA UserTransaction");
                    }
                } else {
                    this.ut.setRollbackOnly();
                    log.debug((Object)"set JTA UserTransaction to rollback only");
                }
            }
            catch (Exception e) {
                log.error((Object)"JTA rollback failed", (Throwable)e);
                throw new TransactionException("JTA rollback failed", e);
            }
        }
        catch (Throwable throwable) {
            Object var2_4 = null;
            this.afterCommitRollback();
            throw throwable;
        }
        {
            Object var2_5 = null;
        }
        this.afterCommitRollback();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void afterCommitRollback() throws TransactionException {
        if (this.synchronization) return;
        if (!this.newTransaction) {
            log.warn((Object)"You should set hibernate.transaction.manager_lookup_class if cache is enabled");
        }
        int status = Integer.MIN_VALUE;
        try {
            try {
                status = this.ut.getStatus();
            }
            catch (Exception e) {
                log.error((Object)"Could not determine transaction status after commit", (Throwable)e);
                throw new TransactionException("Could not determine transaction status after commit", e);
            }
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            this.jdbcContext.afterTransactionCompletion(status == 3, this);
            throw throwable;
        }
        {
            Object var3_5 = null;
            this.jdbcContext.afterTransactionCompletion(status == 3, this);
            return;
        }
    }

    public boolean wasRolledBack() throws TransactionException {
        int status;
        if (!this.begun) {
            return false;
        }
        if (this.commitFailed) {
            return true;
        }
        try {
            status = this.ut.getStatus();
        }
        catch (SystemException se) {
            log.error((Object)"Could not determine transaction status", (Throwable)se);
            throw new TransactionException("Could not determine transaction status", (Exception)((Object)se));
        }
        if (status == 5) {
            throw new TransactionException("Could not determine transaction status");
        }
        return JTAHelper.isRollback(status);
    }

    public boolean wasCommitted() throws TransactionException {
        int status;
        if (!this.begun || this.commitFailed) {
            return false;
        }
        try {
            status = this.ut.getStatus();
        }
        catch (SystemException se) {
            log.error((Object)"Could not determine transaction status", (Throwable)se);
            throw new TransactionException("Could not determine transaction status: ", (Exception)((Object)se));
        }
        if (status == 5) {
            throw new TransactionException("Could not determine transaction status");
        }
        return status == 3;
    }

    public void registerSynchronization(Synchronization sync) throws HibernateException {
        if (this.transaction != null) {
            try {
                this.transaction.registerSynchronization(sync);
            }
            catch (Exception e) {
                throw new TransactionException("could not register synchronization", e);
            }
        } else {
            throw new IllegalStateException("JTA TransactionManager not available");
        }
    }

    private void closeIfRequired() throws HibernateException {
        boolean close;
        boolean bl = close = !this.synchronization && this.transactionContext.shouldAutoClose() && this.transactionContext.isOpen();
        if (close) {
            this.transactionContext.managedClose();
        }
    }
}

