package cours5.test;



import java.util.List;

import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

import org.hibernate.Criteria;
import org.hibernate.FetchMode;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Example;
import org.hibernate.criterion.Expression;
import org.hibernate.criterion.MatchMode;

import test.TestCase;
import cours5.model.Characteristic;
import cours5.model.Coach;
import cours5.model.Player;
import cours5.model.School;
import cours5.model.Team;

/**
 * Anthony Patricio
 *
 * TODO To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Style - Code Templates
 */

public class CriteriaTest extends TestCaseWithData{

	public void testCriteria() throws Exception  {
	    System.out.println("==========testCriteria========");
	    init();
	    Session session = openSession();
	    Transaction tx=null;
	    try {
	        tx = session.beginTransaction();
	        Criteria criteria = session.createCriteria(Team.class);
	        Criterion nameEq = Expression.eq("name", "Team A");
	        criteria.add(nameEq);
	        criteria.list();
	        tx.commit();
	    }
	    catch (Exception e) {
	        if (tx!=null) tx.rollback();	
	        throw e;
	    }
	    finally {
	        session.close();
	        System.out.println("==========testCriteria========");
	    }
	}
	
	
	public void testComplexCriteria() throws Exception  {
	    System.out.println("==========testComplexCriteria========");
	    init();
	    Session session = openSession();
	    Transaction tx=null;
	    try {
	        tx = session.beginTransaction();
	        Criteria criteria = session.createCriteria(Team.class);
	        criteria.setFetchMode("players",FetchMode.JOIN)
	          .setFetchMode("coach",FetchMode.JOIN)
	          .createCriteria("players","player")
	            .add(Expression.like("name", "coachA", MatchMode.START))
	            .createCriteria("school")
	              .add(Expression.like("name", "SchoolA",MatchMode.ANYWHERE));
	        criteria.list();

	        tx.commit();
	    }
	    catch (Exception e) {
	        if (tx!=null) tx.rollback();	
	        throw e;
	    }
	    finally {
	        session.close();
	        System.out.println("==========testComplexCriteria========");
	    }
	}
	
	public void testSimpleQBE() throws Exception  {
	    System.out.println("==========testSimpleQBE========");
	    init();
	    Session session = openSession();
	    Transaction tx=null;
	    try {
	        // simulation de l'objet test
	        Team teamExample= new Team();
	        teamExample.setName("Team A");
	        // fin de simulation
	        tx = session.beginTransaction();
	    	Criteria criteria = session.createCriteria(Team.class);
	    	criteria.add( Example.create(teamExample) );
	    	List result = criteria.list();
	    	tx.commit();
	    }
	    catch (Exception e) {
	        if (tx!=null) tx.rollback();	
	        throw e;
	    }
	    finally {
	        session.close();
	        System.out.println("==========testSimpleQBE========");
	    }
	}	
	
	public void testQBECaseLike() throws Exception  {
	    System.out.println("==========testSimpleQBE========");
	    init();
	    Session session = openSession();
	    Transaction tx=null;
	    try {
	        // simulation de l'objet test
	        Team teamExample= new Team();
	        teamExample.setName("Team A");
	        // fin de simulation
	        tx = session.beginTransaction();
	    	Criteria criteria = session.createCriteria(Team.class);
	    	criteria.add( Example.create(teamExample).enableLike(MatchMode.ANYWHERE).ignoreCase());
	    	List result = criteria.list();
	    	tx.commit();
	    }
	    catch (Exception e) {
	        if (tx!=null) tx.rollback();	
	        throw e;
	    }
	    finally {
	        session.close();
	        System.out.println("==========testSimpleQBE========");
	    }
	}
	
	public void testComplexQBE() throws Exception  {
	    System.out.println("==========testComplexQBE========");
	    init();
	    Session session = openSession();
	    Transaction tx=null;
	    try {
	        // simulation de l'objet test
	        Team teamExample= new Team();
	        teamExample.setName("Team A");
	        Player playerExample = new Player();
	        playerExample.setName("pa1");
	        School schoolExample = new School();
	        schoolExample.setName("sc1");
	        // fin de simulation
	        tx = session.beginTransaction();
	    	//Criteria criteria = session.createCriteria(Team.class);
	    	//criteria.add( Example.create(teamExample).enableLike(MatchMode.ANYWHERE).ignoreCase());
	    	//List result = criteria.list();
	    	
	        Criteria criteria = session.createCriteria(Team.class);
	        criteria.add(Example.create(teamExample).enableLike(MatchMode.ANYWHERE).ignoreCase())
	        	.createCriteria("players","player")
	        		.add(Example.create(playerExample))
	        		.createCriteria("school")
	        			.add(Example.create(schoolExample));
	        List result = criteria.list();
	    	tx.commit();
	    }
	    catch (Exception e) {
	        if (tx!=null) tx.rollback();	
	        throw e;
	    }
	    finally {
	        session.close();
	        System.out.println("==========testComplexQBE========");
	    }
	}
	
	public void testComplexQBEIgnoreZero() throws Exception  {
	    System.out.println("==========testComplexQBEExcludeZeroes========");
	    init();
	    Session session = openSession();
	    Transaction tx=null;
	    try {
	        // simulation de l'objet test
	        Team teamExample= new Team();
	        teamExample.setName("Team A");
	        Player playerExample = new Player();
	        playerExample.setName("pa1");
	        School schoolExample = new School();
	        schoolExample.setName("sc1");
	        // fin de simulation
	        tx = session.beginTransaction();
	    	//Criteria criteria = session.createCriteria(Team.class);
	    	//criteria.add( Example.create(teamExample).enableLike(MatchMode.ANYWHERE).ignoreCase());
	    	//List result = criteria.list();
	    	
	        Criteria criteria = session.createCriteria(Team.class);
	        criteria.add(Example.create(teamExample).enableLike(MatchMode.ANYWHERE).ignoreCase())
	        	.createCriteria("players","player")
	        		.add(Example.create(playerExample).excludeZeroes())
	        		.createCriteria("school")
	        			.add(Example.create(schoolExample));
	        List result = criteria.list();
	    	tx.commit();
	    }
	    catch (Exception e) {
	        if (tx!=null) tx.rollback();	
	        throw e;
	    }
	    finally {
	        session.close();
	        System.out.println("==========testComplexQBEExcludeZeroes========");
	    }
	}
	
	public void testPagingCriteria() throws Exception  {
	    System.out.println("==========testPagingCriteria========");
	    init();
	    Session session = openSession();
	    Transaction tx=null;
	    try {
	        tx = session.beginTransaction();
	    	Criteria criteria = session.createCriteria(Team.class);
	    	criteria.setFirstResult(10)
	    		.setMaxResults(20);
	        List result = criteria.list();
	    	tx.commit();
	    }
	    catch (Exception e) {
	        if (tx!=null) tx.rollback();	
	        throw e;
	    }
	    finally {
	        session.close();
	        System.out.println("==========testPagingCriteria========");
	    }
	}
	
	public void testCriteriaBetween() throws Exception  {
	    System.out.println("==========testCriteriaBetween========");
	    init();
	    Session session = openSession();
	    Transaction tx=null;
	    try {
	        tx = session.beginTransaction();
	        Criteria criteria = session.createCriteria(Player.class)
	        	.add( Expression.between("height",new Long("1,80"),new Long("1,90")));
	        List Expression = criteria.list();
	    	tx.commit();
	    }
	    catch (Exception e) {
	        if (tx!=null) tx.rollback();	
	        throw e;
	    }
	    finally {
	        session.close();
	        System.out.println("==========testCriteriaBetween========");
	    }
	}
	
	public void testCriteriaIn() throws Exception  {
	    System.out.println("==========testCriteriaIn========");
	    init();
	    Session session = openSession();
	    Transaction tx=null;
	    try {
	        tx = session.beginTransaction();
	        Criteria criteria = session.createCriteria(Player.class)
	        	.add( Expression.in("height",new Long[]{new Long("1.80"),new Long("1.90")}));
	        List Expression = criteria.list();
	    	tx.commit();
	    }
	    catch (Exception e) {
	        if (tx!=null) tx.rollback();	
	        throw e;
	    }
	    finally {
	        session.close();
	        System.out.println("==========testCriteriaIn========");
	    }
	}
	

		public String[] getMappings() {
			return new String[] {"cours5/model/Team.hbm.xml",
					"cours5/model/Coach.hbm.xml",
					"cours5/model/Player.hbm.xml",
					"cours5/model/Characteristic.hbm.xml",
					"cours5/model/School.hbm.xml",
					"cours5/model/Game.hbm.xml" };
		}
		
    	public CriteriaTest(String x) {
    		super(x);
    	}

    	public static Test suite() {
    		return new TestSuite(CriteriaTest.class);
    	}

    	public static void main(String[] args) throws Exception {
    		TestRunner.run( suite() );
    	}
}
