package cours5.test;



import java.util.List;

import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

import org.hibernate.Query;
import org.hibernate.SQLQuery;
import org.hibernate.Session;
import org.hibernate.Transaction;

import test.TestCase;
import cours5.model.Characteristic;
import cours5.model.Coach;
import cours5.model.Player;
import cours5.model.School;
import cours5.model.Team;

/**
 * Anthony Patricio
 *
 * TODO To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Style - Code Templates
 */

public class SQLTest extends TestCaseWithData{
	public void testSQLQuery() throws Exception  {
	    System.out.println("==========testSQLQuery========");
	    init();
	    Session session = openSession();
	    Transaction tx=null;
	    try {
	        tx = session.beginTransaction();
	        StringBuffer queryString = new StringBuffer();
	        queryString.append("select {team.*} ")
	        	.append("from TEAM {team}, COACH coach ")
	        	.append("where coach.COACH_NAME='coachA' ")
	        	.append("and team.COACH_ID=coach.COACH_ID");
	        //Query query = session.createSQLQuery(queryString.toString(),"team",Team.class);
	        SQLQuery query = session.createSQLQuery(queryString.toString());
            query.addEntity("team",Team.class);
	        List results = query.list();
            
            Query query2 = session.getNamedQuery("testNamedSQLQuery");
            List results2 = query2.list();

	        tx.commit();
	    }
	    catch (Exception e) {
	        e.printStackTrace();
	        if (tx!=null) tx.rollback();	
	        throw e;
	    }
	    finally {
	        session.close();
	        System.out.println("==========testSQLQuery========");
	    }
	}
	
	public void testComplexSQLQuery() throws Exception  {
	    System.out.println("==========testComplexSQLQuery========");
	    init();
	    Session session = openSession();
	    Transaction tx=null;
	    try {
	        tx = session.beginTransaction();
	        StringBuffer queryString = new StringBuffer();
	        queryString.append("select {team.*},  ")
	        	.append("coach.COACH_ID as {coach.id}, ")
	        	.append("coach.BIRTHDAY as {coach.birthday}, ")
	        	.append("coach.HEIGHT as {coach.height}, ")
	        	.append("coach.WEIGHT as {coach.weight}, ")
	        	.append("coach.COACH_NAME as {coach.name} ")
		        .append("from TEAM {team}, COACH {coach} ")
	        	.append("where coach.COACH_NAME='coachA' ")
	        	.append("and team.COACH_ID=coach.COACH_ID");
	        SQLQuery query = session.createSQLQuery(queryString.toString());
            query.addEntity("team",Team.class);
            query.addEntity("coach",Coach.class);
	        List results = query.list();
	        tx.commit();
	    }
	    catch (Exception e) {
	        e.printStackTrace();
	        if (tx!=null) tx.rollback();	
	        throw e;
	    }
	    finally {
	        session.close();
	        System.out.println("==========testComplexSQLQuery========");
	    }
	}
	
	public String[] getMappings() {
		return new String[] {"cours5/model/Team.hbm.xml",
				"cours5/model/Coach.hbm.xml",
				"cours5/model/Player.hbm.xml",
				"cours5/model/Characteristic.hbm.xml",
				"cours5/model/School.hbm.xml",
				"cours5/model/Game.hbm.xml" };
	}    
    
		
    	public SQLTest(String x) {
    		super(x);
    	}

    	public static Test suite() {
    		return new TestSuite(SQLTest.class);
    	}

    	public static void main(String[] args) throws Exception {
    		TestRunner.run( suite() );
    	}
}
