package cours8.xmlMapping.test;

import java.util.List;

import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

import org.dom4j.Document;
import org.dom4j.DocumentFactory;
import org.dom4j.Element;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;
import org.hibernate.EntityMode;
import org.hibernate.Session;
import org.hibernate.Transaction;

/**
 * Anthony Patricio
 *
 * TODO To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
public class XmlMappingTest extends TestCaseWithData{
    public void testGetCoach() throws Exception  {
        // on suppose que la gestion des exceptions est dsormais
        // gre par vos classes utilitaires et/ou framework
        initData();
        Session session = openSession();
        Transaction tx = null ;
        Session dom4jSession = session.getSession(EntityMode.DOM4J);
        tx = dom4jSession.beginTransaction();
        List elements = dom4jSession.createQuery("from Coach").list();
        for (int i=0; i<elements.size(); i++) {
            print( (Element) elements.get(i) );
        }
        tx.commit();
        session.close();
    }
    
    public void testGetTeam() throws Exception  {
        // on suppose que la gestion des exceptions est dsormais
        // gre par vos classes utilitaires et/ou framework
        initData();
        Session session = openSession();
        Transaction tx = null ;
        Session dom4jSession = session.getSession(EntityMode.DOM4J);
        tx = dom4jSession.beginTransaction();
        List elements = dom4jSession.createQuery("from Team").list();
        for (int i=0; i<elements.size(); i++) {
            print( (Element) elements.get(i) );
        }
        tx.commit();
        session.close();
    }
	
    public void simplePersist()throws Exception {
        initData(); 
        Element coach = DocumentFactory.getInstance().createElement("Coach");
        coach.addAttribute( "name","XMLCOACH" );

        print(coach);
        Session s = openSession();
        Session dom4jSession = s.getSession(EntityMode.DOM4J);
        Transaction t = dom4jSession.beginTransaction();
        try{
            dom4jSession.persist("cours8.xmlMapping.model.Coach",coach);
        }
        catch (Exception e){
            e.printStackTrace();
        }
        t.commit();
        dom4jSession.close();
        s.close();
    }
    
    	// ********************************************************** //

    public static void print(Element elt) throws Exception {
        OutputFormat outformat = OutputFormat.createPrettyPrint();
        // outformat.setEncoding(aEncodingScheme);
        XMLWriter writer = new XMLWriter( System.out, outformat );
        writer.write( elt );
        writer.flush();
        // System.out.println( elt.asXML() );
    }	

	
	public XmlMappingTest(String arg0) {
		super(arg0);
	}
	
	public String[] getMappings() {
        return new String[] {
                "cours8/xmlMapping/model/Coach.hbm.xml",
                "cours8/xmlMapping/model/Team.hbm.xml",
                "cours8/xmlMapping/model/Player.hbm.xml",
                "cours8/xmlMapping/model/Game.hbm.xml"};
	}

	public static Test suite() {
		return new TestSuite(XmlMappingTest.class);
	}
	
	public static void main(String[] args) throws Exception {
		TestRunner.run( suite() );
	}
}
