//$Id: ArrayTest.java,v 1.1 2005/04/25 21:40:12 epbernard Exp $
package testMap;

import org.hibernate.Session;
import org.hibernate.Transaction;

import test.TestCase;

/**
 * @author Anthony Patricio
 */
public class MapTest extends TestCase {

	public void testMapKeyManyToMany() throws Exception {
		Session s;
		Transaction tx;
		Season s1 = new Season();
		s = openSession();
		tx = s.beginTransaction();
		Coach c1 = new Coach();
		c1.setName( "Vahid" );
		Coach c2 = new Coach();
		c2.setName( "Fernandez" );
		Team team = new Team();
		Season s2 = new Season();
		s.persist( s1 );
		s.persist( s2 );
		team.getCoachs2().put(s1,c1);
		team.getCoachs2().put(s2,c2);
		s.persist( team );
		tx.commit();
		s.close();

		s = openSession();
		tx = s.beginTransaction();
		team = (Team) s.get( Team.class, team.getId() );

		tx.commit();
		s.close();
	}

	public MapTest(String x) {
		super( x );
	}

	protected String[] getMappings() {
		return new String[] {
			"testMap/Coach.hbm.xml",
			"testMap/Season.hbm.xml",
			"testMap/Team.hbm.xml"
		};
	}
}
