package cours2.test;

import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

import org.hibernate.HibernateException;
import org.hibernate.LockMode;
import org.hibernate.Session;
import org.hibernate.Transaction;

import cours3.model.Player;
import cours3.model.Team;

/**
 * @author Anthony
 *
 * Test entity lifecycle (merge, persist, lock...) and retrieve (get).
 */
public class TeamTest extends TestCaseWithData{
	public void testGet() throws Exception  {
		initData();
		Session session = openSession();
		// ou Session session = HibernateUtil.getSession();
		Transaction tx = null ;
		try {
			tx = session.beginTransaction();
			//faire votre travail
			Team team = (Team)session.get(Team.class, new Long(1));
			assertNotNull(team);
			// ou load
			//fin de travail
			tx.commit();
		}
		catch (Exception e) {
			if (tx != null) {
				try {
					tx.rollback();
				} catch (HibernateException he) {
				throw he;
				}
			}
			throw e;
		}
		finally {
			try {
			  session.close();
			} catch (HibernateException ex) {
			  throw new Exception(ex); 	//exception fatale
			}			
		}
	}
	
	
	
	public void testMakePersistent() throws Exception  {
	    initData();
		Session session = openSession();
		// ou Session session = HibernateUtil.getSession();
		Transaction tx = null ;
		try {
			tx = session.beginTransaction();
			//faire votre travail
			Team team = new Team("La nouvelle team");
			assertNull(team.getId());
			session.persist(team);
			//fin de travail
			assertNotSame(null,team.getId());
			tx.commit();
		}
		catch (Exception e) {
			if (tx != null) {
				try {
					tx.rollback();
				} catch (HibernateException he) {
				throw he;
  				}
			}
			throw e;
		}
		finally {
			try {
			  session.close();
			} catch (HibernateException ex) {
			  throw new Exception(ex); 	//exception fatale
			}			
		}

	}
	
	public void testUpdateAttached() throws Exception  {
		// on suppose que la gestion des exceptions est dsormais
		// gre par vos classes utilitaires et/ou framework
		initData();
		Session session = openSession();
		// ou Session session = HibernateUtil.getSession();
		Transaction tx = null ;
		tx = session.beginTransaction();
		//faire votre travail
		Player player = (Player)session.get(Player.class, new Long(1));
		player.setName("le nouveau nom du player");
		//fin de travail
		tx.commit();
		session.close();
		
		session = openSession();
		// ou Session session = HibernateUtil.getSession();
		tx = null ;
		tx = session.beginTransaction();
		//faire votre travail
		Player player2 = (Player)session.get(Player.class, new Long(1));
		assertEquals(player.getName(),player2.getName());
		tx.commit();
		session.close();
	}
	
	public void testUpdateDetached() throws Exception  {
		// on suppose que la gestion des exceptions est dsormais
		// gre par vos classes utilitaires et/ou framework
		initData();
		Session session = openSession();
		// ou Session session = HibernateUtil.getSession();
		Transaction tx = null ;
		tx = session.beginTransaction();
		//faire votre travail
		Player player = (Player)session.get(Player.class, new Long(1));
		tx.commit();
		session.close();
		
		player.setName("le nouveau nom du player");
		session = openSession();
		assertFalse(session.contains(player));
		tx = session.beginTransaction();
		session.update(player);
		// ou session.merge
		//fin de travail
		assertTrue(session.contains(player));
		tx.commit();
		session.close();
	}
	
	public void testReattachUnmodified() throws Exception  {
		// on suppose que la gestion des exceptions est dsormais
		// gre par vos classes utilitaires et/ou framework
		initData();
		Session session = openSession();
		// ou Session session = HibernateUtil.getSession();
		Transaction tx = null ;
		tx = session.beginTransaction();
		//faire votre travail
		Player player = (Player)session.get(Player.class, new Long(1));
		tx.commit();
		session.close();
		
		session = openSession();
		assertFalse(session.contains(player));
		tx = session.beginTransaction();
		session.lock(player,LockMode.NONE);
		assertTrue(session.contains(player));
		//fin de travail
		tx.commit();
		session.close();
	}
	
	public void testMakeTransient() throws Exception  {
		// on suppose que la gestion des exceptions est dsormais
		// gre par vos classes utilitaires et/ou framework
		// cette mthode soulve une exception, trouvez en la cause
		initData();
		Session session = openSession();
		// ou Session session = HibernateUtil.getSession();
		Transaction tx = null ;
		tx = session.beginTransaction();
		//faire votre travail
		Player player = (Player)session.get(Player.class, new Long(1));
		session.delete(player);
		// une exception est souleve, trouvez la cause
		//fin de travail
		assertNull(session.get(Player.class,player.getId()));
		tx.commit();
		session.close();
		
	}
	
    	// ********************************************************** //

	

	
	public TeamTest(String arg0) {
		super(arg0);
	}
	
	public String[] getMappings() {
		return new String[] {"cours3/model/Team.hbm.xml","cours3/model/Coach.hbm.xml","cours3/model/Player.hbm.xml","cours3/model/Game.hbm.xml" };
	}

	public static Test suite() {
		return new TestSuite(TeamTest.class);
	}
	
	public static void main(String[] args) throws Exception {
		TestRunner.run( suite() );
	}
}
