package cours4.model;

import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

/**
 * Une instance de cette classe reprsente une Team.
 * Des players et des games sont associs  cette team. 
 * Son cycle de vie est indpendant de celui des objets associs
 * @author Anthony Patricio <anthony@hibernate.org>  
 */
public class Team implements Serializable{

    private Long id;
    private String name;
	private int nbWon;
	private int nbLost;
	private int nbPlayed;
	private Coach coach;
	private Set players = new HashSet();
	//private Set players = new HashSet();
	private Map homeGames = new HashMap();
	private Map awayGames = new HashMap();
	private transient Map games = new HashMap();
	private transient Set wonGames = new HashSet();
	private transient Set lostGames = new HashSet();
	
	private int nbPlayer;
	
    /**
     * Contructeur par dfaut 
     */
    public Team() {
    }
    
    public Team(String name){
        this.name = name;        
    }
	/**
	 * @return la liste des games gagnes
	 */
	public Set getWonGames(){
	    games = getGames();
	    wonGames.clear();
	    for (Iterator it=games.values().iterator(); it.hasNext(); ) {
	        Game game = (Game)it.next();
	        if (game.getVictoriousTeam().equals(this))
	            wonGames.add(game);
	    }
	    return wonGames;	    
	}
	
	/**
	 * @return la liste des games perdues
	 */
	public Set getLostGames(){
	    games = getGames();
	    lostGames.clear();
	    for (Iterator it=games.values().iterator(); it.hasNext(); ) {
	        Game game = (Game)it.next();
	        if (game.getDefeatedTeam().equals(this))
	            lostGames.add(game);
	    }
	    return wonGames;	    
	}

	public Map getGames() {
	    games.putAll(homeGames);
	    games.putAll(awayGames);
	    return games;
	}

	public Set gamesKeySet() {
		return getGames().keySet();
	}

	public Collection gamesValues() {
		return getGames().values();
	}

	public boolean gamesContainsKey(Date key) {
		return getGames().containsKey(key);
	}

	public boolean gamesContainsValue(Game value) {
		return getGames().containsValue(value);
	}

	public Game getGames(Date key) {
		return (Game) getGames().get(key);
	}

    /**
     * @return Returns the nbLost.
     */
    public int getNbLost() {
        return nbLost;
    }
    /**
     * @param nbLost The nbLost to set.
     */
    public void setNbLost(int nbLost) {
        this.nbLost = nbLost;
    }
    /**
     * @return retourne le nombre de game  score null.
     */
    public int getNbNull() {
        return nbPlayed - nbLost - nbWon;
    }

    /**
     * @return Returns the nbPlayed.
     */
    public int getNbPlayed() {
        return nbPlayed;
    }
    /**
     * @param nbPlayed The nbPlayed to set.
     */
    public void setNbPlayed(int nbPlayed) {
        this.nbPlayed = nbPlayed;
    }
    /**
     * @return Returns the nbWon.
     */
    public int getNbWon() {
        return nbWon;
    }
    /**
     * @param nbWon The nbWon to set.
     */
    public void setNbWon(int nbWon) {
        this.nbWon = nbWon;
    }
    /**
     * @return Returns the players.
     */
    public Set getPlayers() {
        return players;
    }
    /**
     * @param players The players to set.
     */
    private void setPlayers(Set players) {
        this.players = players;
    }
    
    public void addPlayer (Player p){
		if (p == null)
			throw new IllegalArgumentException("Can't add a null player.");
		if (p.getTeam() != null && p.getTeam().equals(this))
		    throw new IllegalArgumentException("Player is already in this team");
		else if (p.getTeam() != null)
		    // on pourrait ajouter un test sur les conditions de contrats
		    p.getTeam().removePlayer(p);
		p.setTeam(this);
		this.getPlayers().add(p);   
    }
    
    public void removePlayer (Player p){
		if (p == null)
			throw new IllegalArgumentException("Can't add a null player.");     
		p.setTeam(null);
		this.getPlayers().remove(p);
    }
    /**
     * @return Returns the coach.
     */
    public Coach getCoach() {
        return coach;
    }
    /**
     * @param coach The coach to set.
     */
    public void setCoach(Coach c) {
        // pas d'ancien coach
        if (getCoach() == null && c != null){
            this.coach = c;
        }
        // l'ancien coach est limog, l'quipe se retrouve sans coach
        else if (getCoach() != null && c == null){
            this.coach = c;
        }
        //remplacement de l'ancien coach
        else if (getCoach() != null && c != null){
            if (!(getCoach().equals(c))){
                this.coach = c;
            }
        }
    }
    
    /**
     * @return Returns the id.
     */
    public Long getId() {
        return id;
    }
    /**
     * @param id The id to set.
     */
    public void setId(Long id) {
        this.id = id;
    }
    /**
     * @return Returns the name.
     */
    public String getName() {
        return name;
    }
    /**
     * @param name The name to set.
     */
    public void setName(String name) {
        this.name = name;
    }
    /**
     * @return Returns the awayGames.
     */
    public Map getAwayGames() {
        return awayGames;
    }
    /**
     * @param awayGames The awayGames to set.
     */
    public void setAwayGames(Map awayGames) {
        this.awayGames = awayGames;
    }
    /**
     * @return Returns the homeGames.
     */
    public Map getHomeGames() {
        return homeGames;
    }
    /**
     * @param homeGames The homeGames to set.
     */
    public void setHomeGames(Map homeGames) {
        this.homeGames = homeGames;
    }
    /**
     * @return Returns the nbPlayer.
     */
    public int getNbPlayer() {
        return nbPlayer;
    }
    /**
     * @param nbPlayer The nbPlayer to set.
     */
    public void setNbPlayer(int nbPlayer) {
        this.nbPlayer = nbPlayer;
    }
}
