package cours4.test;

import java.util.List;

import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

import org.hibernate.Session;
import org.hibernate.Transaction;

import test.TestCase;
import cours4.model.Coach;
import cours4.model.Rookie;
import cours4.model.Season;
import cours4.model.Team;


/**
 * @author Anthony
 *
 * Test inheritance.
 * For the second part of the chapter (ternary + bidirectionnal, 
 * you must rewrite the code yourself
 */
public class TernaryTest extends TestCase{

	public void testTernary() throws Exception  {
		Season s1 = new Season();
		Season s2 = new Season();

		Team t1 = new Team("t1"); 
		Team t2 = new Team("t2");
		
		Coach c = new Coach("c");
		
		
		Session session = openSession();
		Transaction tx=null;
		try {
		  tx = session.beginTransaction();

		  session.persist(s1);
		  session.persist(s2);
		  session.persist(c);
		  tx.commit();  
		  
		}
		catch (Exception e) {
		  if (tx!=null) tx.rollback();	
		  throw e;
		}
		finally {
		  session.close();
		}

	}
	


	
	public TernaryTest(String arg0) {
		super(arg0);
	}
	
	public String[] getMappings() {
		return new String[] {
                "cours4/model/TeamTernary.hbm.xml",
				"cours4/model/CoachTernary.hbm.xml",
				"cours4/model/PlayerTernary.hbm.xml",
				"cours4/model/SeasonTernary.hbm.xml",
				"cours4/model/GameTernary.hbm.xml"};
	}

	public static Test suite() {
		return new TestSuite(TernaryTest.class);
	}
	
	public static void main(String[] args) throws Exception {
		TestRunner.run( suite() );
	}
}
