package cours5.model;

import java.io.Serializable;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;

/**
 * Une instance de cette classe reprsente une Team.
 * Des players et des games sont associs  cette team. 
 * Son cycle de vie est indpendant de celui des objets associs
 * @author Anthony Patricio <anthony@hibernate.org>  
 */
public class Team implements Serializable{

    private Long id;
    private String name;
	private Coach coach ;
	private Set players = new HashSet();
	private Set games = new HashSet();
	private Integer version;
	private Date timestamp;
	
    /**
     * Contructeur par dfaut 
     */
    public Team() {
    }
    
    public Team(String s) {
        name = s;
    }
    
    /**
     * @return Returns the coach.
     */
    public Coach getCoach() {
        return coach;
    }
    /**
     * @param coach The coach to set.
     */
    public void setCoach(Coach coach) {
        this.coach = coach;
    }
    /**
     * @return Returns the games.
     */
    public Set getGames() {
        return games;
    }
    /**
     * @param games The games to set.
     */
    public void setGames(Set games) {
        this.games = games;
    }
    /**
     * @return Returns the id.
     */
    public Long getId() {
        return id;
    }
    /**
     * @param id The id to set.
     */
    public void setId(Long id) {
        this.id = id;
    }
    /**
     * @return Returns the name.
     */
    public String getName() {
        return name;
    }
    /**
     * @param name The name to set.
     */
    public void setName(String name) {
        this.name = name;
    }
    /**
     * @return Returns the players.
     */
    public Set getPlayers() {
        return players;
    }
    /**
     * @param players The players to set.
     */
    public void setPlayers(Set players) {
        this.players = players;
    }
    
    public void addPlayer(Player p){
        this.getPlayers().add(p);
    }
    
    public void removePlayer(Player p){
        this.getPlayers().remove(p);
    }
    /**
     * @return Returns the version.
     */
    public Integer getVersion() {
        return version;
    }
    /**
     * @param version The version to set.
     */
    public void setVersion(Integer version) {
        this.version = version;
    }
}
