package cours5.test;

import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

import org.hibernate.LockMode;
import org.hibernate.Session;
import org.hibernate.Transaction;

import test.TestCase;
import cours5.model.Characteristic;
import cours5.model.Coach;
import cours5.model.Player;
import cours5.model.School;
import cours5.model.Team;

/**
 * Anthony Patricio
 *
 * TODO To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
public class PersistenceByReachabilityTest extends TestCaseWithData {
	public void testCascadepersist() throws Exception  {
	    System.out.println("==========testCascadepersist========");
        Team team = new Team("cascade test team");
        Player player = new Player ("cascade player test");
        School school = new School ("cascade school test");
        Coach coach= new Coach("cascade test coach");
        player.setSchool(school);
        team.addPlayer(player);
        team.setCoach(coach);
	    Session session = openSession();
	    Transaction tx=null;
	    try {
	        tx = session.beginTransaction();
	        session.persist(team);
	        //session.persist(coach);
	        //session.persist(school);
	        //session.persist(player);	        
	        tx.commit();
	    }
	    catch (Exception e) {
	        e.printStackTrace();
	        if (tx!=null) tx.rollback();	
	        throw e;
	    }
	    finally {
	        session.close();
	        System.out.println("==========testCascadepersist========");
	    }
	}
	
	public void testLock() throws Exception  {
	    init();
	    System.out.println("==========testLock========");
	    Session session = openSession();
	    Transaction tx=null;
        try{
	    	// phase de dtachement
		     tx = session.beginTransaction();
		    Team detachedTeam = (Team)session.get(Team.class,new Long(1));
		    tx.commit();
		    session.close();
		    // team est dtche
		    
		    // phase de modification
		    //detachedTeam.setName("nouveau nom");
		    // phase de r attachement
		    session = openSession();
		    tx = session.beginTransaction();
		    session.lock(detachedTeam,LockMode.WRITE);
		    Session session2 = getSessions().openSession();
		    Team detachedTeam2 = (Team)session.get(Team.class,new Long(1));
		    tx.commit();
		    session.close();
        }
	    catch (Exception e) {
	        e.printStackTrace();
	        if (tx!=null) tx.rollback();	
	        throw e;
	    }
	    finally {
	        session.close();
	        System.out.println("==========testLock========");
	    }
	}
	
	public void testVersionning() throws Exception  {
	    init();
	    System.out.println("==========testVersionning========");
	    Session session = openSession();
	    Session session2 = getSessions().openSession();
	    Transaction tx=null;
	    Transaction tx2=null;
        try{
	    	tx = session.beginTransaction();
		    tx2 = session2.beginTransaction();
		    Team team = (Team)session.get(Team.class,new Long(1));
		    Team team2 = (Team)session2.get(Team.class,new Long(1));
		    team.setName("nouveau nom");
		    team2.setName("nouveau nom2");
		    session.lock(team,LockMode.READ);
		    tx2.commit();
		    tx.commit();		    
        }
	    catch (Exception e) {
	        e.printStackTrace();
	        if (tx!=null) tx.rollback();	
	        throw e;
	    }
	    finally {
	        session.close();
	        session2.close();
		    System.out.println("==========testVersionning========");
	    }
	}
	
	public void testConcurrencyDelete() throws Exception  {
	    init();
	    System.out.println("==========testVersionning========");
	    Session session = openSession();
	    Session session2 = getSessions().openSession();
	    Transaction tx=null;
	    Transaction tx2=null;
        try{
	    	tx = session.beginTransaction();
		    tx2 = session2.beginTransaction();
		    Team team = (Team)session.get(Team.class,new Long(1));
		    Team team2 = (Team)session2.get(Team.class,new Long(1));
		    team.setName("nouveau nom");
		    session2.delete(team2);
		    tx2.commit();
		    tx.commit();		    
        }
	    catch (Exception e) {
	        e.printStackTrace();
	        if (tx!=null) tx.rollback();	
	        throw e;
	    }
	    finally {
	        session.close();
	        session2.close();
		    System.out.println("==========testVersionning========");
	    }
	}
	
	public void testCascadeSave() throws Exception  {
	    System.out.println("==========testCascadeSave========");
        Team team = new Team("cascade test team");
//        Player player = new Player ("cascade player test");
//        School school = new School ("cascade school test");
//        Coach coach= new Coach("cascade test coach");
//        player.setSchool(school);
//        team.addPlayer(player);
//        team.setCoach(coach);
	    Session session = openSession();
	    Transaction tx=null;
	    try {
	        tx = session.beginTransaction();
	        session.save(team);
	        //session.persist(coach);
	        //session.persist(school);
	        //session.persist(player);	        
	        tx.commit();
	    }
	    catch (Exception e) {
	        e.printStackTrace();
	        if (tx!=null) tx.rollback();	
	        throw e;
	    }
	    finally {
	        session.close();
	        System.out.println("==========testCascadeSave========");
	    }
	}
	
	public void testMerge() throws Exception  {
	    init();
		System.out.println("==========testMerge========");
        try{
	    	// phase de dtachement
		    Session session = openSession();
		    Transaction tx = session.beginTransaction();
		    Team detachedTeam = (Team)session.get(Team.class,new Long(1));
		    tx.commit();
		    session.close();
		    // team est dtche
		    
		    // phase de modification
		    detachedTeam.setName("nouveau nom");
		    
		    // phase de r attachement
		    session = openSession();
		    tx = session.beginTransaction();
		    Team persistedTeam = (Team) session.merge(detachedTeam);
		    
		    // qui est attach  la session?
		    assertFalse(session.contains(detachedTeam));
		    assertTrue(session.contains(persistedTeam));
		    tx.commit();
		    session.close();
        }
	    catch (Exception e) {
	        e.printStackTrace();
	        throw e;
	    }
	    System.out.println("==========testMerge========");
	    
	}
	
	public void testUpdate() throws Exception  {
	    init();
		System.out.println("==========testUpdate========");
        try{
	    	// phase de dtachement
		    Session session = openSession();
		    Transaction tx = session.beginTransaction();
		    Team detachedTeam = (Team)session.get(Team.class,new Long(1));
		    tx.commit();
		    session.close();
		    // team est dtche
		    
		    // phase de modification
		    //detachedTeam.setName("nouveau nom");
		    // phase de r attachement
		    session = openSession();
		    tx = session.beginTransaction();
		    session.update(detachedTeam);
		    
		    tx.commit();
		    session.close();
        }
	    catch (Exception e) {
	        e.printStackTrace();
	        throw e;
	    }
	    System.out.println("==========testUpdate========");
	    
	}
	
	public void testDelete() throws Exception  {
	    init();
		System.out.println("==========testUpdate========");
        try{
	    	Session session = openSession();
		    Transaction tx = session.beginTransaction();
		    Team team = (Team)session.get(Team.class,new Long(1));		    
		    session.delete(team);
		    tx.commit();
		    session.close();
        }
	    catch (Exception e) {
	        e.printStackTrace();
	        throw e;
	    }
	    System.out.println("==========testUpdate========");
	    
	}
	
	public void testDeleteOrphan() throws Exception  {
	    init();
		System.out.println("==========testDeleteOrphan========");
        try{
	    	Session session = openSession();
		    Transaction tx = session.beginTransaction();
		    Team team = (Team)session.get(Team.class,new Long(1));		    
		    Player player = (Player)team.getPlayers().iterator().next();
		    team.removePlayer(player);
		    tx.commit();
		    session.close();
        }
	    catch (Exception e) {
	        e.printStackTrace();
	        throw e;
	    }
	    System.out.println("==========testDeleteOrphan========");
	    
	}
	
	public void testDeleteOrphanMovingToCollection() throws Exception  {
	    init();
		System.out.println("==========testDeleteOrphanMovingToCollection========");
        try{
	    	Session session = openSession();
		    Transaction tx = session.beginTransaction();
		    Team team1 = (Team)session.get(Team.class,new Long(1));		    
		    Team team2 = (Team)session.get(Team.class,new Long(2));
		    Player player = (Player)team1.getPlayers().iterator().next();
		    team1.removePlayer(player);
		    team2.addPlayer(player);
		    tx.commit();
		    session.close();
        }
	    catch (Exception e) {
	        e.printStackTrace();
	        throw e;
	    }
	    System.out.println("==========testDeleteOrphanMovingToCollection========");
	    
	}
    
 
    
	public String[] getMappings() {
		return new String[] {"cours5/model/Team.hbm.xml",
				"cours5/model/Coach.hbm.xml",
				"cours5/model/Player.hbm.xml",
				"cours5/model/Characteristic.hbm.xml",
				"cours5/model/School.hbm.xml",
				"cours5/model/Game.hbm.xml" };
	}    
    
    
    
    public PersistenceByReachabilityTest(String x) {
		super(x);
	}

	public static Test suite() {
		return new TestSuite(PersistenceByReachabilityTest.class);
	}

	public static void main(String[] args) throws Exception {
		TestRunner.run( suite() );
	}
}
