package testArray;

import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

import org.hibernate.Session;
import org.hibernate.Transaction;


import test.TestCase;
import cours3.model.Player;

public class ArrayTest extends TestCase{
	public void testArray() throws Exception  {
		Session s;
		Transaction tx;
		s = openSession();
		tx = s.beginTransaction();
		A a = new A();
        B b1 = new B();
        B b2 = new B();
        a.setBs(new B[]{b1,b2});
        s.persist(a);
		tx.commit();
		s.close();
		
		s = openSession();
		tx = s.beginTransaction();
		A a2 = (A) s.get(A.class, a.getId() );
		assertNotNull(a2);
        assertEquals(2, a2.getBs().length);
		tx.commit();
		s.close();
	}
	
	public ArrayTest(String arg0) {
		super(arg0);
	}
	
	public String[] getMappings() {
		return new String[] {"testArray/A.hbm.xml","testArray/B.hbm.xml"};
	}

	public static Test suite() {
		return new TestSuite(ArrayTest.class);
	}
	
	public static void main(String[] args) throws Exception {
		TestRunner.run( suite() );
	}
}
