--
delimiter $

--
DROP TABLE IF EXISTS test.Trace$
CREATE TABLE test.Trace(message VARCHAR(80))$

--
DROP PROCEDURE IF EXISTS calculTemps$

--
CREATE PROCEDURE calculTemps()
BEGIN
 DECLARE fincurs BOOLEAN DEFAULT 0;
 DECLARE v_nomLog   VARCHAR(20);
 DECLARE v_nomPoste VARCHAR(20);
 DECLARE v_dateAch  DATETIME;
 DECLARE v_dateIns  TIMESTAMP;
 DECLARE v_nLog     VARCHAR(5);
 DECLARE v_nPoste   VARCHAR(7); 
--nb jours entier
 DECLARE v_attente  SMALLINT;
--nb jour dcimal
 DECLARE v_jourdecimal DECIMAL(8,2);
--criture en format "TIME tendu"
 DECLARE v_chainejour VARCHAR(30);

 DECLARE curseur CURSOR FOR
         SELECT   l.nomLog,p.nomPoste,l.dateAch,i.dateIns,i.nLog,i.nPoste
	    FROM  Installer i, Logiciel l, Poste p
	    WHERE i.nPoste = p.nPoste AND i.nLog = l.nLog;
 DECLARE CONTINUE HANDLER FOR NOT FOUND SET fincurs := 1;
 OPEN curseur;
 FETCH curseur INTO v_nomLog,v_nomPoste,v_dateAch,v_dateIns,v_nLog,v_nPoste;
 WHILE (NOT fincurs) DO
  IF v_dateAch IS NULL THEN
     INSERT INTO test.Trace VALUES (CONCAT('Date d''achat inconnue pour le logiciel ' 
             ,v_nomLog,' sur ',v_nomPoste));
  ELSE 
     SET v_attente :=  DATEDIFF(v_dateIns,v_dateAch);
     IF v_attente < 0 THEN
        INSERT INTO test.Trace VALUES (CONCAT('Logiciel ',v_nomLog,' install sur ',
                                       v_nomPoste,' ', -v_attente,' jour(s) avant l''achat!'));
     ELSE
        IF v_attente = 0 THEN
           INSERT INTO test.Trace VALUES (CONCAT(v_nomLog,' sur ',v_nomPoste,
                                         ' achet et install le mme jour!'));		
	ELSE 
	  INSERT INTO test.Trace VALUES (CONCAT('Logiciel ',v_nomLog,' sur ',v_nomPoste,
                                        ' attente ',v_attente,' jour(s).'));
          SET  v_jourdecimal := TIMESTAMPDIFF(SECOND,v_dateAch,v_dateIns)/(24*3600);
          SET v_chainejour := CONCAT(SIGN(v_jourdecimal) * FLOOR(ABS(v_jourdecimal))," j ", 
             SEC_TO_TIME((ABS(v_jourdecimal)-FLOOR(ABS(v_jourdecimal)))* 86400));
	  INSERT INTO test.Trace VALUES (CONCAT('En format TIME tendu ', v_chainejour));
	  UPDATE Installer SET delai = v_jourdecimal
		  WHERE  nPoste = v_nPoste AND nLog = v_nLog;
        END IF;	
     END IF;
 END IF;
 FETCH curseur INTO v_nomLog,v_nomPoste,v_dateAch,v_dateIns,v_nLog,v_nPoste;
 END WHILE;
 CLOSE curseur;
 SELECT * FROM test.Trace;
END;
$

--Test et appel

UPDATE Installer SET delai = NULL$
SELECT * FROM Installer$
DELETE FROM test.Trace$

CALL calculTemps()$

--Vrification
SELECT * FROM Installer$




--